/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.collections;

import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

public class ResourceReaderCollection
extends MappedCollection<String, Resource> {
    public ResourceReaderCollection(Collection<Resource> coll) {
        super(coll, (UnaryFunction)new UnaryFunction<String, Resource>(){

            public String evaluate(Resource resource) {
                try {
                    StringWriter buffer = new StringWriter();
                    IOUtils.copy((InputStream)resource.getInputStream(), (Writer)buffer);
                    return buffer.toString();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("cannot read resource", e);
                }
            }
        });
    }
}

