/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.aop;

import eu.dnetlib.springutils.aop.MethodCacheInterceptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MethodCacheInterceptorTest {
    private static final String TEST_VALUE = "mockedTestValue";
    private transient CacheManager singletonManager;
    private transient Cache cache;
    private transient MethodInvocation inv;
    private transient MethodInvocation invArgs;
    private transient MethodCacheInterceptor inter;

    @Before
    public void setUp() throws Throwable {
        this.singletonManager = CacheManager.create();
        this.singletonManager.addCache("testCache");
        this.cache = this.singletonManager.getCache("testCache");
        this.inter = new MethodCacheInterceptor();
        this.inter.setCache(this.cache);
        MethodCacheInterceptorTest _this = (MethodCacheInterceptorTest)Mockito.mock(MethodCacheInterceptorTest.class);
        this.inv = (MethodInvocation)Mockito.mock(MethodInvocation.class);
        Method method = MethodCacheInterceptorTest.class.getDeclaredMethod("test", new Class[0]);
        Mockito.when((Object)this.inv.getThis()).thenReturn((Object)_this);
        Mockito.when((Object)this.inv.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)this.inv.proceed()).thenReturn((Object)TEST_VALUE);
        this.invArgs = (MethodInvocation)Mockito.mock(MethodInvocation.class);
        Method methodArgs = MethodCacheInterceptorTest.class.getDeclaredMethod("testWithArgs", String.class);
        Mockito.when((Object)this.invArgs.getThis()).thenReturn((Object)_this);
        Mockito.when((Object)this.invArgs.getMethod()).thenReturn((Object)methodArgs);
        Mockito.when((Object)this.invArgs.getArguments()).thenReturn((Object)new Object[]{"test1"});
        Mockito.when((Object)this.invArgs.proceed()).thenReturn((Object)"mockedTestValueWithArgs");
    }

    @After
    public void tearDown() throws Exception {
        this.singletonManager.removeAllCaches();
    }

    @Test
    public void testCache() {
        this.cache.put(new Element((Serializable)((Object)"key"), (Serializable)((Object)"value")));
        Assert.assertEquals((String)"check cache", (Object)"value", (Object)this.cache.get((Serializable)((Object)"key")).getObjectValue());
    }

    @Test
    public void testInterceptor() throws Throwable {
        Assert.assertEquals((String)"first invocation", (Object)TEST_VALUE, (Object)this.inter.invoke(this.inv));
        Assert.assertEquals((String)"cached invocation", (Object)TEST_VALUE, (Object)this.inter.invoke(this.inv));
        ((MethodInvocation)Mockito.verify((Object)this.inv)).proceed();
    }

    @Test
    public void testFlush() throws Throwable {
        Assert.assertEquals((String)"first invocation", (Object)TEST_VALUE, (Object)this.inter.invoke(this.inv));
        this.cache.flush();
        Assert.assertEquals((String)"cache not flushed", (Object)TEST_VALUE, (Object)this.inter.invoke(this.inv));
    }

    @Test
    public void testWithArguments() throws Throwable {
        Assert.assertEquals((String)"first invocation", (Object)"mockedTestValueWithArgs", (Object)this.inter.invoke(this.invArgs));
        Assert.assertEquals((String)"cached invocation", (Object)"mockedTestValueWithArgs", (Object)this.inter.invoke(this.invArgs));
        ((MethodInvocation)Mockito.verify((Object)this.invArgs)).proceed();
    }

    public String test() {
        return null;
    }

    public String testWithArgs(String arg) {
        return null;
    }

    @Test
    public void testAfterPropertiesSet() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.inter.getClass().getMethod("afterPropertiesSet", new Class[0]).invoke((Object)this.inter, new Object[0]);
        Assert.assertNotNull((String)"dummy", (Object)this.inter);
    }

    @Test
    public void testSetWriteOnly() {
        Assert.assertFalse((String)"getter", (boolean)this.inter.isWriteOnly());
        this.inter.setWriteOnly(true);
        Assert.assertTrue((String)"getter", (boolean)this.inter.isWriteOnly());
    }
}

