/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.enabling.resultset.FetchList;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.enabling.resultset.SizedIterable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IterableResultSet
implements ResultSetListener,
ResultSetAware {
    private static final Log log = LogFactory.getLog(IterableResultSet.class);
    private ResultSet resultSet;
    private FetchList<String> fetchList;
    private int optionalNumberOfElements;

    protected IterableResultSet(Iterable<String> iter, int fetchSize) {
        this.fetchList = new FetchList<String>(iter.iterator(), fetchSize);
        this.optionalNumberOfElements = iter instanceof SizedIterable ? ((SizedIterable)iter).getNumberOfElements() : -1;
    }

    @Override
    public List<String> getResult(int fromPosition, int toPosition) {
        log.debug((Object)(" - getting result from " + fromPosition + " to " + toPosition + ", consumedElements: " + this.fetchList.getConsumedElements()));
        if (fromPosition != this.fetchList.getConsumedElements() + 1) {
            throw new RuntimeException("Unexpected value for 'fromPosition' parameter");
        }
        if (toPosition < fromPosition) {
            throw new RuntimeException("'fromPosition' must be lower or equal than 'toPosition'");
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = fromPosition;
        while (i <= toPosition) {
            if (this.fetchList.size() <= 0) break;
            result.add(this.fetchList.poll());
            ++i;
        }
        this.ensureClosed();
        return result;
    }

    private void ensureClosed() {
        if (this.fetchList.size() == 0 && this.resultSet.isOpen()) {
            log.info((Object)">>>>>>>>>>> closing resultset <<<<<<<<<<<<<");
            this.close();
        }
    }

    public String getRSStatus() {
        if (this.resultSet.isOpen()) {
            return "open";
        }
        return "closed";
    }

    @Override
    public int getSize() {
        this.ensureClosed();
        if (this.optionalNumberOfElements == -1) {
            return this.fetchList.getTotalElements();
        }
        return this.optionalNumberOfElements;
    }

    protected void close() {
        this.resultSet.close();
    }

    @Override
    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

