/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.resultset.inspector;

import com.google.common.collect.Ordering;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.resultset.LocalResultSetImpl;
import eu.dnetlib.enabling.resultset.MappedResultSet;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.enabling.resultset.ResultSetRegistryImpl;
import eu.dnetlib.miscutils.cache.Cache;
import eu.dnetlib.miscutils.cache.CacheElement;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.string.EscapeHtml;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.miscutils.functional.xml.IndentXmlString;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ResultsetInspector
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(ResultsetInspector.class);
    @Resource
    private ResultSetRegistryImpl registry;

    @RequestMapping(value={"/inspector/resultsets.do"})
    public void resultsets(Model model) {
        final Cache cache = this.registry.getCache();
        List descriptors = MappedCollection.listMap((Iterable)cache.keySet(), (UnaryFunction)new UnaryFunction<ResultsetDescription, String>(){

            public ResultsetDescription evaluate(String arg) {
                ResultSet rs = (ResultSet)cache.get((Object)arg);
                if (rs == null) {
                    return new ResultsetDescription("expired", null, null, true, 0);
                }
                String handler = "";
                if (rs instanceof LocalResultSetImpl) {
                    ResultSetListener listener = ((LocalResultSetImpl)rs).getListener();
                    handler = listener.getClass().getName();
                    if (listener instanceof MappedResultSet) {
                        MappedResultSet mappedResultSet = (MappedResultSet)listener;
                        UnaryFunction mapper = mappedResultSet.getMapper();
                        handler = handler + "(" + mapper.getClass().getName() + ")";
                        if (mapper instanceof ApplyXslt) {
                            handler = handler + ": " + ((ApplyXslt)mapper).getXsltName();
                        }
                    }
                }
                int number = -1;
                try {
                    number = rs.getNumberOfResults();
                }
                catch (Throwable e) {
                    log.debug((Object)"cannot get number of results", e);
                }
                return new ResultsetDescription(arg, rs.getClass().getSimpleName(), handler, rs.isOpen(), number);
            }
        });
        Ordering<ResultsetDescription> byCreationTime = new Ordering<ResultsetDescription>(){

            public int compare(ResultsetDescription left, ResultsetDescription right) {
                CacheElement rightElement = cache.getElement((Object)right.getId());
                CacheElement leftElement = cache.getElement((Object)left.getId());
                if (leftElement == null && rightElement == null) {
                    return 0;
                }
                if (rightElement == null && leftElement != null) {
                    return -1;
                }
                if (leftElement == null && rightElement != null) {
                    return 1;
                }
                return (int)(rightElement.getCreationTime() - leftElement.getCreationTime());
            }
        };
        model.addAttribute("resultsets", (Object)byCreationTime.nullsLast().sortedCopy((Iterable)descriptors));
    }

    @RequestMapping(value={"/inspector/resultset.do"})
    public void resultset(Model model, @RequestParam(value="id") String id, @RequestParam(value="from", required=false) Integer from, @RequestParam(value="to", required=false) Integer to) {
        model.addAttribute("id", (Object)id);
        model.addAttribute("from", (Object)from);
        model.addAttribute("to", (Object)to);
        if (from != null && to != null) {
            this.fetchPage(model, id, from, to);
        }
    }

    private void fetchPage(Model model, String rsId, Integer from, Integer to) {
        ResultSet rs = this.registry.getResultSetById(rsId);
        List res = rs.getResults(from.intValue(), to.intValue());
        model.addAttribute("res", (Object)MappedCollection.listMap((Iterable)MappedCollection.listMap((Iterable)res, (UnaryFunction)new IndentXmlString()), (UnaryFunction)new EscapeHtml()));
    }

    class ResultsetDescription {
        private String id;
        private String type;
        private String handler;
        private boolean open;
        private int size;

        public ResultsetDescription(String id, String type, String handler, boolean open, int size) {
            this.id = id;
            this.type = type;
            this.handler = handler;
            this.open = open;
            this.size = size;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getHandler() {
            return this.handler;
        }

        public void setHandler(String handler) {
            this.handler = handler;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void setOpen(boolean open) {
            this.open = open;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }
}

