/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.service;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import gr.uoa.di.validator.Validator;
import gr.uoa.di.validator.ValidatorException;
import gr.uoa.di.validator.dao.JobSubmitted;
import gr.uoa.di.validator.dao.JobSubmittedDAO;
import gr.uoa.di.validator.dao.RuleSet;
import gr.uoa.di.validator.dao.RuleSetDAO;
import gr.uoa.di.validator.dao.RuleStored;
import gr.uoa.di.validator.dao.RuleStoredDAO;
import gr.uoa.di.validator.dao.Utilities;
import gr.uoa.di.validator.data.Rule;
import gr.uoa.di.validator.execution.Job;
import gr.uoa.di.validator.impls.listeners.DnetListener;
import gr.uoa.di.validator.impls.listeners.ValidatorJobListener;
import gr.uoa.di.validator.impls.rules.ChainRule;
import gr.uoa.di.validator.impls.rules.RuleTypes;
import gr.uoa.di.validator.service.ValidatorManager;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRED)
public abstract class ValidatorManagerImpl
implements ValidatorManager {
    private Validator validator;
    private JobSubmittedDAO jobSubmittedDao;
    private RuleSetDAO ruleSetDao;
    private RuleStoredDAO ruleStoredDao;
    private Map<Integer, Integer> ruleLinkingMap = new HashMap<Integer, Integer>();
    private Integer jobIdRegistry = 1;
    private Integer ruleIdRegistry = 1;
    private static Logger logger = Logger.getLogger(ValidatorManagerImpl.class);

    protected abstract ValidatorJobListener createListener();

    protected abstract DnetListener createDnetListener();

    public void start() {
        logger.debug((Object)"Initializing Validator Manager module");
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JobSubmitted beginDataJobForWorkflow(String datasource, BlackboardJob bJob) throws ValidatorException {
        try {
            Object tempRuleChain1;
            Object tempRule;
            Object ruleId2;
            logger.debug((Object)"Submitting data job for workflow");
            Set<Object> ruleIdsContent = new HashSet();
            for (RuleSet ruleset : this.ruleSetDao.getRuleSetIdNames()) {
                String regRuleset = "OpenAIRE For Literature Repositories";
                if (!ruleset.getName().equals(regRuleset)) continue;
                ruleIdsContent = Utilities.convertListToSet(ruleset.getRuleIdsContent());
            }
            Properties pros = null;
            pros = new Properties();
            pros.setProperty("DATASOURCE", datasource);
            pros.setProperty("BATCH_SIZE", "10");
            pros.setProperty("RECORDS", "5");
            JobSubmitted newJob = new JobSubmitted();
            HashSet<Integer> rules = new HashSet<Integer>();
            for (Object ruleId2 : ruleIdsContent) {
                tempRule = (RuleStored)this.ruleStoredDao.get(((Integer)ruleId2).toString());
                if (((RuleStored)tempRule).getType().equals("ChainRule")) {
                    logger.debug((Object)"chain rule found");
                    tempRuleChain1 = (RuleStored)this.ruleStoredDao.get(((RuleStored)tempRule).getConfiguration().getProperty("rule_1"));
                    RuleStored tempRuleChain2 = (RuleStored)this.ruleStoredDao.get(((RuleStored)tempRule).getConfiguration().getProperty("rule_2"));
                    ArrayList<Rule> rules_chain = new ArrayList<Rule>();
                    rules_chain.add((Rule)this.getRuleClassInstanceByType(((RuleStored)tempRuleChain1).getType(), ((RuleStored)tempRuleChain1).getConfiguration(), this.ruleIdRegistry));
                    Integer n = this.ruleIdRegistry;
                    Integer n2 = this.ruleIdRegistry = Integer.valueOf(this.ruleIdRegistry + 1);
                    rules_chain.add((Rule)this.getRuleClassInstanceByType(tempRuleChain2.getType(), tempRuleChain2.getConfiguration(), this.ruleIdRegistry));
                    n = this.ruleIdRegistry;
                    n2 = this.ruleIdRegistry = Integer.valueOf(this.ruleIdRegistry + 1);
                    Properties chainPros = new Properties();
                    chainPros.setProperty("type", ((RuleStored)tempRule).getConfiguration().getProperty("type"));
                    ChainRule chainRule = new ChainRule(chainPros, this.ruleIdRegistry, rules_chain);
                    this.validator.addToRegistry(this.ruleIdRegistry, chainRule, "RULES");
                } else {
                    this.validator.addToRegistry(this.ruleIdRegistry, this.getRuleClassInstanceByType(((RuleStored)tempRule).getType(), ((RuleStored)tempRule).getConfiguration(), this.ruleIdRegistry), "RULES");
                }
                rules.add(this.ruleIdRegistry);
                this.linkRules(this.ruleIdRegistry, (Integer)ruleId2);
                tempRuleChain1 = this.ruleIdRegistry;
                Integer n = this.ruleIdRegistry = Integer.valueOf(this.ruleIdRegistry + 1);
            }
            Job job = new Job(this.jobIdRegistry, 3, rules, pros);
            ruleId2 = this;
            tempRule = ((ValidatorManagerImpl)ruleId2).jobIdRegistry;
            ((ValidatorManagerImpl)ruleId2).jobIdRegistry = ((ValidatorManagerImpl)ruleId2).jobIdRegistry + 1;
            tempRuleChain1 = ((ValidatorManagerImpl)ruleId2).jobIdRegistry;
            newJob.setUser("Workflow Service");
            newJob.setType("OAI Content Validation");
            newJob.setStatus("working");
            newJob.setRuleset("Workflow Request");
            newJob.setActivation_id(null);
            newJob.setDuration("--");
            newJob.setRepo(datasource);
            newJob.setRules(ruleIdsContent);
            newJob.setRecords(pros.getProperty("RECORDS"));
            newJob.setSet("dnet-workflow");
            newJob.setGroupBy_xpath(null);
            newJob.setMetadata_prefix("");
            newJob.setId("-1");
            int jobIdStored = this.jobSubmittedDao.save(newJob);
            ValidatorJobListener listener = this.createListener();
            listener.setJobSubmittedId(jobIdStored);
            listener.setJobSubmittedUser("Workflow Service");
            listener.setRuleLinkingMap(this.ruleLinkingMap);
            listener.setGroupBy_xpath(null);
            listener.setInternalJobsSum(1);
            DnetListener dnetListener = this.createDnetListener();
            dnetListener.setJob(bJob);
            this.validator.submitJob(job, listener, dnetListener);
            return newJob;
        }
        catch (Exception e) {
            logger.error((Object)"Error Submitting content job for workflow", (Throwable)e);
            throw new ValidatorException(e);
        }
    }

    @Override
    public JobSubmitted beginContentJobForWorkflow(String baseUrl, String validationSet, BlackboardJob bJob) throws ValidatorException {
        try {
            Object tempRuleChain1;
            Object tempRule;
            Object ruleId2;
            logger.debug((Object)"Submitting content job for workflow");
            Set<Object> ruleIdsContent = new HashSet();
            for (RuleSet ruleset : this.ruleSetDao.getRuleSetIdNames()) {
                String regRuleset = validationSet.equalsIgnoreCase("openaire_data") ? "OpenAIRE For Data Archives" : "OpenAIRE For Literature Repositories";
                if (!ruleset.getName().equals(regRuleset)) continue;
                ruleIdsContent = Utilities.convertListToSet(ruleset.getRuleIdsContent());
            }
            Properties pros = null;
            pros = new Properties();
            pros.setProperty("BASEURL", baseUrl);
            pros.setProperty("metadataPrefix", "oai_dc");
            pros.setProperty("TIMEOUT", "360000");
            pros.setProperty("DELAY", "1000");
            pros.setProperty("RETRY_DELAY", "60000");
            pros.setProperty("RETRY_EFFORTS", "3");
            pros.setProperty("records", "all");
            pros.setProperty("set", validationSet);
            JobSubmitted newJob = new JobSubmitted();
            HashSet<Integer> rules = new HashSet<Integer>();
            for (Object ruleId2 : ruleIdsContent) {
                tempRule = (RuleStored)this.ruleStoredDao.get(((Integer)ruleId2).toString());
                if (((RuleStored)tempRule).getType().equals("ChainRule")) {
                    logger.debug((Object)"chain rule found");
                    tempRuleChain1 = (RuleStored)this.ruleStoredDao.get(((RuleStored)tempRule).getConfiguration().getProperty("rule_1"));
                    RuleStored tempRuleChain2 = (RuleStored)this.ruleStoredDao.get(((RuleStored)tempRule).getConfiguration().getProperty("rule_2"));
                    ArrayList<Rule> rules_chain = new ArrayList<Rule>();
                    rules_chain.add((Rule)this.getRuleClassInstanceByType(((RuleStored)tempRuleChain1).getType(), ((RuleStored)tempRuleChain1).getConfiguration(), this.ruleIdRegistry));
                    Integer n = this.ruleIdRegistry;
                    Integer n2 = this.ruleIdRegistry = Integer.valueOf(this.ruleIdRegistry + 1);
                    rules_chain.add((Rule)this.getRuleClassInstanceByType(tempRuleChain2.getType(), tempRuleChain2.getConfiguration(), this.ruleIdRegistry));
                    n = this.ruleIdRegistry;
                    n2 = this.ruleIdRegistry = Integer.valueOf(this.ruleIdRegistry + 1);
                    Properties chainPros = new Properties();
                    chainPros.setProperty("type", ((RuleStored)tempRule).getConfiguration().getProperty("type"));
                    ChainRule chainRule = new ChainRule(chainPros, this.ruleIdRegistry, rules_chain);
                    this.validator.addToRegistry(this.ruleIdRegistry, chainRule, "RULES");
                } else {
                    this.validator.addToRegistry(this.ruleIdRegistry, this.getRuleClassInstanceByType(((RuleStored)tempRule).getType(), ((RuleStored)tempRule).getConfiguration(), this.ruleIdRegistry), "RULES");
                }
                rules.add(this.ruleIdRegistry);
                this.linkRules(this.ruleIdRegistry, (Integer)ruleId2);
                tempRuleChain1 = this.ruleIdRegistry;
                Integer n = this.ruleIdRegistry = Integer.valueOf(this.ruleIdRegistry + 1);
            }
            if (pros.getProperty("set").equalsIgnoreCase("openaire_data")) {
                pros.setProperty("metadataPrefix", "oai_datacite");
            }
            Job job = new Job(this.jobIdRegistry, 1, rules, pros);
            ruleId2 = this;
            tempRule = ((ValidatorManagerImpl)ruleId2).jobIdRegistry;
            ((ValidatorManagerImpl)ruleId2).jobIdRegistry = ((ValidatorManagerImpl)ruleId2).jobIdRegistry + 1;
            tempRuleChain1 = ((ValidatorManagerImpl)ruleId2).jobIdRegistry;
            newJob.setUser("Workflow Service");
            newJob.setType("OAI Content Validation");
            newJob.setStatus("working");
            newJob.setRuleset("Workflow Request");
            newJob.setActivation_id(null);
            newJob.setDuration("--");
            newJob.setRepo(baseUrl);
            newJob.setRules(ruleIdsContent);
            newJob.setRecords(pros.getProperty("records"));
            newJob.setSet(pros.getProperty("set"));
            newJob.setGroupBy_xpath(null);
            newJob.setMetadata_prefix(pros.getProperty("metadataPrefix"));
            newJob.setId("-1");
            int jobIdStored = this.jobSubmittedDao.save(newJob);
            ValidatorJobListener listener = this.createListener();
            listener.setJobSubmittedId(jobIdStored);
            listener.setJobSubmittedUser("Workflow Service");
            listener.setRuleLinkingMap(this.ruleLinkingMap);
            listener.setGroupBy_xpath(null);
            listener.setInternalJobsSum(1);
            DnetListener dnetListener = this.createDnetListener();
            dnetListener.setJob(bJob);
            this.validator.submitJob(job, listener, dnetListener);
            return newJob;
        }
        catch (Exception e) {
            logger.error((Object)"Error Submitting content job for workflow", (Throwable)e);
            throw new ValidatorException(e);
        }
    }

    @Override
    public JobSubmitted beginUsageJobForWorkflow(String baseUrl, String validationSet, BlackboardJob bJob) throws ValidatorException {
        try {
            logger.debug((Object)"Submitting Usage job(s) for workflow");
            Set<Object> ruleIdsUsage = new HashSet();
            for (RuleSet ruleset : this.ruleSetDao.getRuleSetIdNames()) {
                String regRuleset = validationSet.equalsIgnoreCase("openaire_data") ? "OpenAIRE For Data Archives" : "OpenAIRE For Literature Repositories";
                if (!ruleset.getName().equals(regRuleset)) continue;
                ruleIdsUsage = Utilities.convertListToSet(ruleset.getRuleIdsUsage());
            }
            Properties pros = new Properties();
            pros.setProperty("BASEURL", baseUrl);
            pros.setProperty("TIMEOUT", "360000");
            pros.setProperty("DELAY", "1000");
            pros.setProperty("RETRY_DELAY", "60000");
            pros.setProperty("RETRY_EFFORTS", "3");
            JobSubmitted newJob = new JobSubmitted();
            ArrayList rulesStored = new ArrayList();
            for (Integer n : ruleIdsUsage) {
                logger.debug((Object)("Rule with id: " + n + " added"));
                rulesStored.add(this.ruleStoredDao.get(n.toString()));
            }
            logger.debug((Object)"Creating map for provider information");
            HashMap verbRuleMap = new HashMap();
            HashSet<Integer> temp = null;
            for (RuleStored ruleStored : rulesStored) {
                logger.debug((Object)("Checking for verb : " + ruleStored.getProvider_information()));
                Set set = (Set)verbRuleMap.get(ruleStored.getProvider_information());
                if (set == null) {
                    logger.debug((Object)"Verb doesn't exist");
                    temp = new HashSet<Integer>();
                    temp.add(Integer.parseInt(ruleStored.getId()));
                    verbRuleMap.put(ruleStored.getProvider_information(), temp);
                    continue;
                }
                logger.debug((Object)"Verb exists");
                set.add(Integer.parseInt(ruleStored.getId()));
            }
            HashSet<Integer> rules = null;
            Job job = null;
            newJob.setUser("Workflow Service");
            newJob.setType("OAI Usage Validation");
            newJob.setStatus("working");
            newJob.setRuleset("Workflow Request");
            newJob.setActivation_id(null);
            newJob.setDuration("--");
            newJob.setRepo(pros.getProperty("BASEURL"));
            newJob.setRules(ruleIdsUsage);
            newJob.setMetadata_prefix(pros.getProperty("metadataPrefix"));
            newJob.setId("-1");
            int jobIdStored = this.jobSubmittedDao.save(newJob);
            ValidatorJobListener listener = this.createListener();
            listener.setJobSubmittedId(jobIdStored);
            listener.setJobSubmittedUser("Workflow Service");
            listener.setRuleLinkingMap(this.ruleLinkingMap);
            listener.setInternalJobsSum(verbRuleMap.size());
            for (Map.Entry entry : verbRuleMap.entrySet()) {
                Integer n;
                pros.remove("VERB");
                pros.setProperty("VERB", (String)entry.getKey());
                rules = new HashSet<Integer>();
                for (Integer ruleId : (Set)entry.getValue()) {
                    RuleStored tempRule = (RuleStored)this.ruleStoredDao.get(Integer.toString(ruleId));
                    logger.debug((Object)("prepare to add rule to registry with regexp: " + tempRule.getConfiguration().getProperty("regexp") + " and ruleIdregistry: " + this.ruleIdRegistry));
                    this.validator.addToRegistry(this.ruleIdRegistry, this.getRuleClassInstanceByType(tempRule.getType(), tempRule.getConfiguration(), this.ruleIdRegistry), "RULES");
                    rules.add(this.ruleIdRegistry);
                    this.linkRules(this.ruleIdRegistry, ruleId);
                    n = this.ruleIdRegistry;
                    Integer n2 = this.ruleIdRegistry = Integer.valueOf(this.ruleIdRegistry + 1);
                }
                job = new Job(this.jobIdRegistry, 2, rules, pros);
                DnetListener dnetListener = this.createDnetListener();
                dnetListener.setJob(bJob);
                this.validator.submitJob(job, listener, dnetListener);
                ValidatorManagerImpl validatorManagerImpl = this;
                Integer n3 = validatorManagerImpl.jobIdRegistry;
                n = validatorManagerImpl.jobIdRegistry = Integer.valueOf(validatorManagerImpl.jobIdRegistry + 1);
            }
            return newJob;
        }
        catch (Exception e) {
            logger.error((Object)"Error Submitting usage job(s)", (Throwable)e);
            throw new ValidatorException(e);
        }
    }

    @Override
    public Serializable getRuleClassInstanceByType(String type, Properties pros, int id) throws ValidatorException {
        logger.debug((Object)("getting rule object of type " + type));
        String classname = RuleTypes.getClassOfType(type);
        if (classname == null) {
            logger.debug((Object)("error getting rule object of type " + type + " classname=null"));
            return null;
        }
        try {
            Class<?> clazz = Class.forName(classname);
            logger.debug((Object)("classname: " + clazz.getName()));
            return (Serializable)clazz.getConstructor(Properties.class, Integer.TYPE).newInstance(pros, id);
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)("error getting rule object: " + e));
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)("error getting rule object: " + e));
            return null;
        }
        catch (InvocationTargetException e) {
            logger.debug((Object)("error getting rule object: " + e));
            return null;
        }
        catch (InstantiationException e) {
            logger.debug((Object)("error getting rule object: " + e));
            return null;
        }
        catch (IllegalAccessException e) {
            logger.debug((Object)("error getting rule object: " + e));
            return null;
        }
    }

    @Override
    public void linkRules(int ruleRegistry, int ruleStored) {
        this.ruleLinkingMap.put(ruleRegistry, ruleStored);
    }

    @Override
    public int getRuleFromLink(int ruleRegistry) {
        return this.ruleLinkingMap.get(ruleRegistry);
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public JobSubmittedDAO getJobSubmittedDao() {
        return this.jobSubmittedDao;
    }

    public void setJobSubmittedDao(JobSubmittedDAO jobSubmittedDao) {
        this.jobSubmittedDao = jobSubmittedDao;
    }

    public RuleSetDAO getRuleSetDao() {
        return this.ruleSetDao;
    }

    public void setRuleSetDao(RuleSetDAO ruleSetDao) {
        this.ruleSetDao = ruleSetDao;
    }

    public RuleStoredDAO getRuleStoredDao() {
        return this.ruleStoredDao;
    }

    public void setRuleStoredDao(RuleStoredDAO ruleStoredDao) {
        this.ruleStoredDao = ruleStoredDao;
    }

    public Map<Integer, Integer> getRuleLinkingMap() {
        return this.ruleLinkingMap;
    }

    public void setRuleLinkingMap(Map<Integer, Integer> ruleLinkingMap) {
        this.ruleLinkingMap = ruleLinkingMap;
    }
}

