/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.service;

import eu.dnetlib.enabling.tools.blackboard.ActionStatus;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import gr.uoa.di.validator.ValidatorException;
import gr.uoa.di.validator.service.ValidatorManagerImpl;
import org.apache.log4j.Logger;

public class NotificationListener
extends BlackboardNotificationHandler<BlackboardServerHandler> {
    private static Logger logger = Logger.getLogger(NotificationListener.class);
    private ValidatorManagerImpl valManager;

    protected void processJob(BlackboardJob job) {
        super.processJob(job);
        String baseUrl = (String)job.getParameters().get("baseUrl");
        String validationSet = (String)job.getParameters().get("validationSet");
        String validationType = (String)job.getParameters().get("validationType");
        String type = (String)job.getParameters().get("type");
        String datasource = (String)job.getParameters().get("datasource");
        logger.debug((Object)("New Job of type: " + type));
        try {
            if (type.equalsIgnoreCase("OAI")) {
                logger.debug((Object)"type is oai");
                if (validationType.equalsIgnoreCase("OAI Content Validation")) {
                    this.valManager.beginContentJobForWorkflow(baseUrl, validationSet, job);
                } else if (validationType.equalsIgnoreCase("OAI Usage Validation")) {
                    this.valManager.beginUsageJobForWorkflow(baseUrl, validationSet, job);
                } else {
                    logger.error((Object)"Unknown validation type");
                }
            } else if (type.equalsIgnoreCase("DNET")) {
                logger.debug((Object)"type is dnet");
                this.valManager.beginDataJobForWorkflow(datasource, job);
            }
            job.setActionStatus(ActionStatus.ASSIGNED);
        }
        catch (ValidatorException e) {
            logger.error((Object)"Failed to begin the workflow for the job received");
        }
    }

    public ValidatorManagerImpl getValManager() {
        return this.valManager;
    }

    public void setValManager(ValidatorManagerImpl valManager) {
        this.valManager = valManager;
    }
}

