/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.service;

import eu.dnetlib.data.information.DataSinkSourceException;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.utils.EPRUtils;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.Provider;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.valobjs.XMLTextValidationObject;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class DnetProvider
extends Provider {
    private static final long serialVersionUID = -4280319954962194170L;
    private static DataSourceResolver dataSourceResolver = null;
    private static ResultSetFactory rsFactory = null;
    public static final String DATASOURCE = "DATASOURCE";
    public static final String BATCH_SIZE = "BATCH_SIZE";
    public static final String RECORDS = "RECORDS";

    public DnetProvider(Integer id) {
        super(id);
    }

    @Override
    public gr.uoa.di.validator.data.ResultSet<ValidationObject> getValidationObjects() throws Provider.ProviderException {
        return new DnetRecordResultSet();
    }

    @Override
    public gr.uoa.di.validator.data.ResultSet<String> getValidationObjectIds() throws Provider.ProviderException, UnsupportedOperationException {
        return null;
    }

    @Override
    public ValidationObject getValidationObject(String valObjId) throws Provider.ProviderException, UnsupportedOperationException {
        return null;
    }

    public static void printXmlDocument(Document document) {
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        String string = lsSerializer.writeToString(document);
        System.out.println(string);
    }

    public static DataSourceResolver getDataSourceResolver() {
        return dataSourceResolver;
    }

    public static void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        DnetProvider.dataSourceResolver = dataSourceResolver;
    }

    public static ResultSetFactory getRsFactory() {
        return rsFactory;
    }

    public static void setRsFactory(ResultSetFactory rsFactory) {
        DnetProvider.rsFactory = rsFactory;
    }

    private class DnetRecordResultSet
    extends DnetResultSet
    implements gr.uoa.di.validator.data.ResultSet<ValidationObject> {
        private DnetRecordResultSet() {
        }

        @Override
        public String getError() {
            if (this.error != null) {
                DnetProvider.this.log.debug((Object)("An error occured " + this.error));
            } else {
                DnetProvider.this.log.debug((Object)"No errors on request");
            }
            return this.error;
        }

        @Override
        public boolean next() throws DataException {
            ++this.index;
            DnetProvider.this.log.debug((Object)("Moving cursor to result " + this.index));
            if (this.records == null || this.index >= this.records.size()) {
                this.index = -1;
                this.records = this.getRecords();
                return this.next();
            }
            return true;
        }

        @Override
        public ValidationObject get() throws DataException {
            XMLTextValidationObject ret = null;
            try {
                Document newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element root = newXmlDocument.createElement("root");
                newXmlDocument.appendChild(root);
                Node node = (Node)this.records.get(this.index);
                Node copyNode = newXmlDocument.importNode(node, true);
                root.appendChild(copyNode);
                ret = new XMLTextValidationObject(newXmlDocument);
                XPathFactory factory = XPathFactory.newInstance();
                XPath xPath = factory.newXPath();
                ret.setId(xPath.evaluate("header/identifier", this.records.get(this.index)));
                ret.setStatus(xPath.evaluate("header/@status", this.records.get(this.index)));
            }
            catch (ParserConfigurationException e) {
                DnetProvider.this.log.error((Object)("error getting object" + e));
            }
            catch (XPathExpressionException e) {
                DnetProvider.this.log.error((Object)("error getting object" + e));
            }
            return ret;
        }
    }

    private class DnetResultSet {
        protected W3CEndpointReference w3cEpr = null;
        ResultSet<String> rs = null;
        protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        protected DocumentBuilder builder;
        protected XPathFactory xfactory = XPathFactory.newInstance();
        protected List<Node> records = null;
        protected int records_sum = 0;
        protected int index = -1;
        protected int pointer = 0;
        protected String error = null;

        public DnetResultSet() {
            try {
                this.builder = this.factory.newDocumentBuilder();
                DnetProvider.this.log.debug((Object)"Retrieving the datasource..");
                DnetProvider.this.log.debug((Object)("RECORDS " + DnetProvider.this.pros.getProperty(DnetProvider.RECORDS)));
                DnetProvider.this.log.debug((Object)("DATASOURCE: " + DnetProvider.this.pros.getProperty(DnetProvider.DATASOURCE)));
                this.w3cEpr = dataSourceResolver.resolve(DnetProvider.this.pros.getProperty(DnetProvider.DATASOURCE)).retrieve();
                DnetProvider.this.log.debug((Object)("w3cEpr: " + this.w3cEpr));
                this.rs = rsFactory.createResultSet(EPRUtils.createEPR((W3CEndpointReference)this.w3cEpr));
                DnetProvider.this.log.debug((Object)"rs created");
                this.records_sum = this.rs.size();
                DnetProvider.this.log.debug((Object)("Number of records in ResultSet: " + this.records_sum));
            }
            catch (ParserConfigurationException e) {
                DnetProvider.this.log.error((Object)"", (Throwable)e);
            }
            catch (DataSinkSourceException e) {
                DnetProvider.this.log.error((Object)"", (Throwable)e);
            }
            catch (Exception e) {
                DnetProvider.this.log.error((Object)"", (Throwable)e);
            }
        }

        protected List<Node> getRecords() throws DataException {
            ArrayList<Node> records = new ArrayList<Node>();
            DnetProvider.this.log.debug((Object)("Issuing request on datasource: " + DnetProvider.this.pros.getProperty(DnetProvider.DATASOURCE)));
            try {
                List tempRecords = this.rs.get(this.pointer, Integer.parseInt(DnetProvider.this.pros.getProperty(DnetProvider.BATCH_SIZE)));
                for (String record : tempRecords) {
                    InputSource is = new InputSource(new StringReader(record));
                    Document doc = this.builder.parse(is);
                    XPath xpath = this.xfactory.newXPath();
                    XPathExpression expr = xpath.compile("//record");
                    records.add((Node)expr.evaluate(doc, XPathConstants.NODE));
                }
                if (records.size() == 0) {
                    DnetProvider.this.log.debug((Object)"There are no records. ");
                    this.error = "There are no records";
                    DnetProvider.this.log.debug((Object)("Error: " + this.error));
                }
            }
            catch (Exception e) {
                DnetProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            return records;
        }
    }
}

