/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.valobjs;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.impls.valobjs.TextValidationObject;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XMLTextValidationObject
implements TextValidationObject {
    private transient Logger log = Logger.getLogger(XMLTextValidationObject.class);
    private String id = "";
    private String status;
    private final Document doc;
    private XPathFactory factory = XPathFactory.newInstance();

    public XMLTextValidationObject(Document doc) {
        this.doc = doc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public Object getContentAsObject() {
        return this.doc;
    }

    @Override
    public String getContentAsText() {
        StringWriter sw = new StringWriter();
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.doc);
            StreamResult output = new StreamResult(sw);
            transformer.transform(source, output);
        }
        catch (TransformerConfigurationException e) {
            this.log.error((Object)"", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            this.log.error((Object)"", (Throwable)e);
        }
        catch (TransformerException e) {
            this.log.error((Object)"", (Throwable)e);
        }
        return sw.toString();
    }

    public Document getDocument() {
        return this.doc;
    }

    public NodeList getNodes(String xpath) throws DataException {
        this.log.debug((Object)("xpath: " + xpath));
        try {
            XPath xxpath = this.factory.newXPath();
            XPathExpression expr = xxpath.compile(xpath);
            return (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new DataException();
        }
    }
}

