/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.rules.xml;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.RuleException;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.rules.VocabularyRule;
import gr.uoa.di.validator.impls.rules.xml.XMLRule;
import gr.uoa.di.validator.impls.valobjs.XMLTextValidationObject;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLVocabularyRule
extends VocabularyRule
implements XMLRule {
    private static final long serialVersionUID = 5138104621562420041L;

    public XMLVocabularyRule(Properties pros, int id) {
        super(pros, id);
    }

    @Override
    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        String[] aterms = this.pros.getProperty("terms").split(",");
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        int success = 0;
        int all = nodes.getLength();
        block2: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            this.log.debug((Object)("XML Vocabulary Rule. Node: " + node.getNodeValue()));
            for (String term : aterms) {
                if (!term.trim().equals(node.getNodeValue().trim())) continue;
                this.log.debug((Object)("XML Vocabulary Rule. Node: " + node.getNodeValue().trim() + " matches with " + term));
                ++success;
                continue block2;
            }
        }
        String successConditions = this.pros.getProperty("success");
        return XMLRule.Utils.success(successConditions, success, all);
    }
}

