/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.rules.xml;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.RuleException;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.rules.ValidUrlRule;
import gr.uoa.di.validator.impls.rules.xml.XMLRule;
import gr.uoa.di.validator.impls.valobjs.XMLTextValidationObject;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLValidURL
extends ValidUrlRule
implements XMLRule {
    private static final long serialVersionUID = -4236498857969746873L;

    public XMLValidURL(Properties pros, int id) {
        super(pros, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        int success = 0;
        int all = nodes.getLength();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String val = node.getNodeValue();
            this.log.debug((Object)("XML Valid url. Node: " + val));
            URLConnection connection = null;
            HttpURLConnection httpConnection = null;
            try {
                URL url = new URL(val);
                connection = url.openConnection();
                if (!(connection instanceof HttpURLConnection)) continue;
                httpConnection = (HttpURLConnection)connection;
                httpConnection.connect();
                InputStream is = httpConnection.getInputStream();
                byte[] buffer = new byte[128];
                int numberOfBytes = is.read(buffer);
                if (numberOfBytes == -1) continue;
                is.close();
                ++success;
                continue;
            }
            catch (Exception e) {
                continue;
            }
            finally {
                if (connection != null) {
                    httpConnection.disconnect();
                }
            }
        }
        String successConditions = this.pros.getProperty("success");
        return XMLRule.Utils.success(successConditions, success, all);
    }
}

