/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.rules.xml;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.rules.RegularExpressionRule;
import gr.uoa.di.validator.impls.rules.xml.XMLRule;
import gr.uoa.di.validator.impls.valobjs.XMLTextValidationObject;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRegularExpressionRule
extends RegularExpressionRule
implements XMLRule {
    private static final long serialVersionUID = -7791692519583028162L;

    public XMLRegularExpressionRule(Properties pros, int id) {
        super(pros, id);
    }

    @Override
    public boolean apply(ValidationObject obj) {
        NodeList nodes;
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        int success = 0;
        int all = nodes.getLength();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            this.log.debug((Object)("XML RegExp Rule. Field Value: " + node.getNodeValue()));
            if (!node.getNodeValue().matches(this.pros.getProperty("regexp"))) continue;
            ++success;
        }
        String successConditions = this.pros.getProperty("success");
        return XMLRule.Utils.success(successConditions, success, all);
    }
}

