/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.rules.xml;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.Rule;
import gr.uoa.di.validator.data.RuleException;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.rules.xml.XMLRule;
import gr.uoa.di.validator.impls.valobjs.XMLTextValidationObject;
import java.util.ArrayList;
import java.util.Properties;
import org.w3c.dom.NodeList;

public class XMLNotConfusedFieldsRule
extends Rule
implements XMLRule {
    private static final long serialVersionUID = -6253009649310760559L;
    public static final String FIELDS = "fields";

    public XMLNotConfusedFieldsRule(Properties pros, int id) {
        super(pros, id);
    }

    @Override
    public boolean apply(ValidationObject obj) throws RuleException {
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        ArrayList<NodeList> lnodelist = new ArrayList<NodeList>();
        try {
            String[] xpaths;
            for (String xpath : xpaths = this.pros.getProperty(FIELDS).split(",")) {
                lnodelist.add(tobj.getNodes(xpath.trim()));
            }
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        for (int i = 0; i < lnodelist.size(); ++i) {
            for (int k = 0; k < ((NodeList)lnodelist.get(i)).getLength(); ++k) {
                String val1 = ((NodeList)lnodelist.get(i)).item(k).getNodeValue();
                this.log.debug((Object)("XML Not Confused Fields Rule. Val1: " + val1));
                for (int j = i + 1; j < lnodelist.size(); ++j) {
                    for (int l = 0; l < ((NodeList)lnodelist.get(j)).getLength(); ++l) {
                        String val2 = ((NodeList)lnodelist.get(j)).item(l).getNodeValue();
                        this.log.debug((Object)("XML Not Confused Fields Rule. Val1: " + val2));
                        if (!val1.trim().equalsIgnoreCase(val2.trim())) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

