/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.rules.xml;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.RuleException;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.rules.CardinalityRule;
import gr.uoa.di.validator.impls.rules.xml.XMLRule;
import gr.uoa.di.validator.impls.valobjs.XMLTextValidationObject;
import java.util.Properties;
import org.w3c.dom.NodeList;

public class XMLCardinalityRule
extends CardinalityRule
implements XMLRule {
    private static final long serialVersionUID = -3293960407395273309L;

    public XMLCardinalityRule(Properties pros, int id) {
        super(pros, id);
    }

    @Override
    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        int number = nodes.getLength();
        this.log.debug((Object)("XML Cardinality Rule. Count: " + number));
        return number < Integer.parseInt(this.pros.getProperty("lt")) && number > Integer.parseInt(this.pros.getProperty("gt"));
    }
}

