/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.rules.oaipmh;

import gr.uoa.di.validator.data.Rule;
import gr.uoa.di.validator.data.RuleException;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.rules.ChainRule;
import gr.uoa.di.validator.impls.rules.xml.XMLRegularExpressionRule;
import gr.uoa.di.validator.impls.rules.xml.XMLVocabularyRule;
import java.util.ArrayList;
import java.util.Properties;

public class OAIPMHEmbargoDateRule
extends Rule {
    private static final long serialVersionUID = 770275867973085409L;

    public OAIPMHEmbargoDateRule(Properties pros, int id) {
        super(pros, id);
    }

    @Override
    public boolean apply(ValidationObject obj) throws RuleException {
        Properties pros1 = new Properties();
        pros1.setProperty("xpath", "/OAI-PMH/GetRecord/record/metadata//*[name()='dc:rights']/text()");
        pros1.setProperty("terms", "info:eu-repo/semantics/embargoedAccess");
        pros1.setProperty("success", ">0");
        XMLVocabularyRule rights = new XMLVocabularyRule(pros1, 1);
        Properties pros2 = new Properties();
        pros2.setProperty("regexp", "info:eu-repo/date/embargoEnd/[0123456789]{4}-[01][0123456789]-[0123][0123456789]");
        pros2.setProperty("xpath", "/OAI-PMH/GetRecord/record/metadata//*[name()='dc:date']/text()");
        pros2.setProperty("success", ">0");
        XMLRegularExpressionRule date = new XMLRegularExpressionRule(pros2, 2);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(rights);
        rules.add(date);
        Properties pros3 = new Properties();
        pros3.setProperty("type", "horn");
        ChainRule chain = new ChainRule(pros3, 3, rules);
        return chain.apply(obj);
    }
}

