/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.providers;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.Provider;
import gr.uoa.di.validator.data.ResultSet;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.providers.URLStreamer;
import gr.uoa.di.validator.impls.valobjs.XMLTextValidationObject;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OAIPMHSinglePageVerbProvider
extends Provider {
    private static final long serialVersionUID = -8398496197308270467L;
    public static final String BASEURL = "BASEURL";
    public static final String VERB = "VERB";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String DELAY = "DELAY";
    public static final String RETRY_DELAY = "RETRY_DELAY";
    public static final String RETRY_EFFORTS = "RETRY_EFFORTS";

    public OAIPMHSinglePageVerbProvider(Integer id) {
        super(id);
    }

    @Override
    public ResultSet<ValidationObject> getValidationObjects() throws Provider.ProviderException {
        return new OAIPMHVerbResultSet();
    }

    @Override
    public ResultSet<String> getValidationObjectIds() throws Provider.ProviderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValidationObject getValidationObject(String valObjId) throws Provider.ProviderException {
        throw new UnsupportedOperationException();
    }

    private class OAIPMHVerbResultSet
    implements ResultSet<ValidationObject> {
        protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        protected DocumentBuilder builder;
        private URLStreamer streamer = new URLStreamer();
        private Document doc = null;
        boolean finished = false;

        public OAIPMHVerbResultSet() {
            try {
                this.builder = this.factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                OAIPMHSinglePageVerbProvider.this.log.error((Object)"", (Throwable)e);
            }
        }

        @Override
        public boolean next() throws DataException {
            if (!this.finished) {
                String surl = OAIPMHSinglePageVerbProvider.this.pros.getProperty(OAIPMHSinglePageVerbProvider.BASEURL) + "?verb=" + OAIPMHSinglePageVerbProvider.this.pros.getProperty(OAIPMHSinglePageVerbProvider.VERB);
                String response = null;
                OAIPMHSinglePageVerbProvider.this.log.debug((Object)("Issuing request: " + surl));
                try {
                    response = this.streamer.getResponse(new URL(surl), Integer.parseInt(OAIPMHSinglePageVerbProvider.this.pros.getProperty(OAIPMHSinglePageVerbProvider.TIMEOUT)), Integer.parseInt(OAIPMHSinglePageVerbProvider.this.pros.getProperty(OAIPMHSinglePageVerbProvider.DELAY)), Integer.parseInt(OAIPMHSinglePageVerbProvider.this.pros.getProperty(OAIPMHSinglePageVerbProvider.RETRY_DELAY)), Integer.parseInt(OAIPMHSinglePageVerbProvider.this.pros.getProperty(OAIPMHSinglePageVerbProvider.RETRY_EFFORTS)));
                }
                catch (NumberFormatException e) {
                    OAIPMHSinglePageVerbProvider.this.log.error((Object)"", (Throwable)e);
                    throw new DataException();
                }
                catch (MalformedURLException e) {
                    OAIPMHSinglePageVerbProvider.this.log.error((Object)"", (Throwable)e);
                    throw new DataException();
                }
                catch (IOException e) {
                    OAIPMHSinglePageVerbProvider.this.log.error((Object)"", (Throwable)e);
                    throw new DataException();
                }
                InputSource is = new InputSource(new StringReader(response));
                try {
                    this.doc = this.builder.parse(is);
                }
                catch (SAXException e) {
                    OAIPMHSinglePageVerbProvider.this.log.error((Object)"", (Throwable)e);
                    throw new DataException();
                }
                catch (IOException e) {
                    OAIPMHSinglePageVerbProvider.this.log.error((Object)"", (Throwable)e);
                    throw new DataException();
                }
                this.finished = true;
                return true;
            }
            return false;
        }

        @Override
        public ValidationObject get() throws DataException {
            XMLTextValidationObject obj = new XMLTextValidationObject(this.doc);
            obj.setId(OAIPMHSinglePageVerbProvider.this.pros.getProperty(OAIPMHSinglePageVerbProvider.VERB) + "@" + OAIPMHSinglePageVerbProvider.this.pros.getProperty(OAIPMHSinglePageVerbProvider.BASEURL));
            OAIPMHSinglePageVerbProvider.this.log.debug((Object)("Getting object with id " + obj.getId()));
            return obj;
        }

        @Override
        public String getError() {
            return null;
        }
    }
}

