/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.providers;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.Provider;
import gr.uoa.di.validator.data.ResultSet;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.providers.URLStreamer;
import gr.uoa.di.validator.impls.valobjs.XMLTextValidationObject;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OAIPMHRecordProvider
extends Provider {
    private static final long serialVersionUID = 3386029339653670731L;
    public static final String BASEURL = "BASEURL";
    public static final String METADATA_PREFIX = "metadataPrefix";
    public static final String FROM = "from";
    public static final String UNTIL = "until";
    public static final String SET = "set";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String DELAY = "DELAY";
    public static final String RETRY_DELAY = "RETRY_DELAY";
    public static final String RETRY_EFFORTS = "RETRY_EFFORTS";
    public static final String RECORDS = "records";

    public OAIPMHRecordProvider(Integer id) {
        super(id);
    }

    @Override
    public ResultSet<ValidationObject> getValidationObjects() throws Provider.ProviderException {
        return new OAIPMHRecordResultSet();
    }

    @Override
    public ResultSet<String> getValidationObjectIds() throws Provider.ProviderException {
        return new OAIPMHRecordIdentifierResultSet();
    }

    @Override
    public ValidationObject getValidationObject(String valObjId) throws Provider.ProviderException {
        OAIPMHResultSet oai = new OAIPMHResultSet();
        try {
            return new XMLTextValidationObject(oai.getRecord(valObjId));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new Provider.ProviderException(this);
        }
    }

    public static void printXmlDocument(Document document) {
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        String string = lsSerializer.writeToString(document);
        System.out.println(string);
    }

    private class OAIPMHRecordIdentifierResultSet
    extends OAIPMHResultSet
    implements ResultSet<String> {
        private OAIPMHRecordIdentifierResultSet() {
        }

        @Override
        public boolean next() throws DataException {
            ++this.index;
            OAIPMHRecordProvider.this.log.debug((Object)("Moving cursor to result " + this.index));
            if (this.recordIds == null || this.index >= this.recordIds.getLength()) {
                if (this.recordIds != null && (this.resumptionToken == null || this.resumptionToken.trim().length() == 0)) {
                    return false;
                }
                this.index = -1;
                this.recordIds = this.getIds();
                return this.next();
            }
            return true;
        }

        @Override
        public String get() throws DataException {
            String id = this.recordIds.item(this.index).getNodeValue();
            OAIPMHRecordProvider.this.log.debug((Object)("Returing object with id " + id));
            return id;
        }

        @Override
        public String getError() {
            return null;
        }
    }

    private class OAIPMHRecordResultSet
    extends OAIPMHResultSet
    implements ResultSet<ValidationObject> {
        private OAIPMHRecordResultSet() {
        }

        @Override
        public String getError() {
            if (this.error != null) {
                OAIPMHRecordProvider.this.log.debug((Object)("An error occured " + this.error));
            } else {
                OAIPMHRecordProvider.this.log.debug((Object)"No errors on request");
            }
            return this.error;
        }

        @Override
        public boolean next() throws DataException {
            ++this.index;
            OAIPMHRecordProvider.this.log.debug((Object)("Moving cursor to result " + this.index));
            if (this.records == null || this.index >= this.records.getLength()) {
                if (this.records != null && (this.resumptionToken == null || this.resumptionToken.trim().length() == 0)) {
                    return false;
                }
                this.index = -1;
                this.records = this.getRecords();
                return this.next();
            }
            return true;
        }

        @Override
        public ValidationObject get() throws DataException {
            XMLTextValidationObject ret = null;
            try {
                Document newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element root = newXmlDocument.createElement("root");
                newXmlDocument.appendChild(root);
                Node node = this.records.item(this.index);
                Node copyNode = newXmlDocument.importNode(node, true);
                root.appendChild(copyNode);
                ret = new XMLTextValidationObject(newXmlDocument);
                XPathFactory factory = XPathFactory.newInstance();
                XPath xPath = factory.newXPath();
                ret.setId(xPath.evaluate("header/identifier", this.records.item(this.index)));
                ret.setStatus(xPath.evaluate("header/@status", this.records.item(this.index)));
            }
            catch (ParserConfigurationException e) {
                OAIPMHRecordProvider.this.log.error((Object)("error getting object" + e));
            }
            catch (XPathExpressionException e) {
                OAIPMHRecordProvider.this.log.error((Object)("error getting object" + e));
            }
            return ret;
        }
    }

    private class OAIPMHResultSet {
        protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        protected DocumentBuilder builder;
        protected XPathFactory xfactory = XPathFactory.newInstance();
        protected NodeList recordIds = null;
        protected NodeList records = null;
        protected int index = -1;
        protected String resumptionToken = null;
        protected String error = null;
        private URLStreamer streamer = new URLStreamer();

        public OAIPMHResultSet() {
            try {
                this.builder = this.factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
            }
        }

        protected NodeList getIds() throws DataException {
            NodeList recordIds = null;
            String surl = OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.BASEURL) + "?verb=ListIdentifiers";
            if (this.resumptionToken == null || this.resumptionToken.trim().length() == 0) {
                surl = surl + "&metadataPrefix=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.METADATA_PREFIX);
                if (OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.FROM) != null) {
                    surl = surl + "&from=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.FROM);
                }
                if (OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.UNTIL) != null) {
                    surl = surl + "&until=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.UNTIL);
                }
                if (!OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.SET).equals("null")) {
                    surl = surl + "&set=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.SET);
                }
            } else {
                surl = surl + "&resumptionToken=" + this.resumptionToken;
            }
            OAIPMHRecordProvider.this.log.debug((Object)("Issuing request " + surl));
            String response = null;
            try {
                response = this.streamer.getResponse(new URL(surl), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.TIMEOUT)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.DELAY)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.RETRY_DELAY)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.RETRY_EFFORTS)));
            }
            catch (NumberFormatException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            catch (MalformedURLException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            catch (IOException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            try {
                InputSource is = new InputSource(new StringReader(response));
                Document doc = this.builder.parse(is);
                XPath xpath = this.xfactory.newXPath();
                XPathExpression expr = xpath.compile("OAI-PMH/ListIdentifiers/header/identifier/text()");
                recordIds = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                XPath xpath2 = this.xfactory.newXPath();
                XPathExpression expr2 = xpath2.compile("OAI-PMH/ListIdentifiers/resumptionToken/text()");
                NodeList rtl = (NodeList)expr2.evaluate(doc, XPathConstants.NODESET);
                if (rtl == null || rtl.getLength() == 0) {
                    OAIPMHRecordProvider.this.log.debug((Object)"There seems to be no resumption token present");
                    this.resumptionToken = null;
                } else {
                    this.resumptionToken = rtl.item(0).getNodeValue();
                    this.resumptionToken = URLEncoder.encode(this.resumptionToken, "UTF-8");
                    OAIPMHRecordProvider.this.log.debug((Object)("Found resumption token: " + this.resumptionToken));
                }
            }
            catch (Exception e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            return recordIds;
        }

        protected NodeList getRecords() throws DataException {
            NodeList records = null;
            String surl = OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.BASEURL) + "?verb=ListRecords";
            if (this.resumptionToken == null || this.resumptionToken.trim().length() == 0) {
                surl = surl + "&metadataPrefix=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.METADATA_PREFIX);
                if (OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.FROM) != null) {
                    surl = surl + "&from=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.FROM);
                }
                if (OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.UNTIL) != null) {
                    surl = surl + "&until=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.UNTIL);
                }
                if (!OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.SET).equals("null")) {
                    surl = surl + "&set=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.SET);
                }
            } else {
                surl = surl + "&resumptionToken=" + this.resumptionToken;
            }
            OAIPMHRecordProvider.this.log.debug((Object)("Issuing request " + surl));
            String response = null;
            try {
                response = this.streamer.getResponse(new URL(surl), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.TIMEOUT)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.DELAY)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.RETRY_DELAY)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.RETRY_EFFORTS)));
            }
            catch (NumberFormatException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            catch (MalformedURLException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            catch (IOException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            try {
                InputSource is = new InputSource(new StringReader(response));
                Document doc = this.builder.parse(is);
                XPath xpath = this.xfactory.newXPath();
                XPathExpression expr = xpath.compile("OAI-PMH/ListRecords/record");
                records = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                XPath xpath2 = this.xfactory.newXPath();
                XPathExpression expr2 = xpath2.compile("OAI-PMH/ListRecords/resumptionToken/text()");
                NodeList rtl = (NodeList)expr2.evaluate(doc, XPathConstants.NODESET);
                OAIPMHRecordProvider.this.log.debug((Object)("Check number of records: " + records.getLength()));
                if (records.getLength() == 0) {
                    OAIPMHRecordProvider.this.log.debug((Object)("There are no records: " + records.getLength()));
                    XPath xpath3 = this.xfactory.newXPath();
                    XPathExpression expr3 = xpath3.compile("OAI-PMH/error/text()");
                    this.error = "The response on request: " + surl + " was the following: ";
                    this.error = this.error + "<b>" + (String)expr3.evaluate(doc, XPathConstants.STRING) + "</b>";
                    OAIPMHRecordProvider.this.log.debug((Object)("Error: " + this.error));
                }
                if (rtl == null || rtl.getLength() == 0) {
                    OAIPMHRecordProvider.this.log.debug((Object)"There seems to be no resumption token present");
                    this.resumptionToken = null;
                } else {
                    this.resumptionToken = rtl.item(0).getNodeValue();
                    this.resumptionToken = URLEncoder.encode(this.resumptionToken, "UTF-8");
                    OAIPMHRecordProvider.this.log.debug((Object)("Found resumption token: " + this.resumptionToken));
                }
            }
            catch (Exception e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            return records;
        }

        protected Document getRecord(String id) throws DataException {
            Document doc;
            String surl = OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.BASEURL) + "?verb=GetRecord";
            surl = surl + "&metadataPrefix=" + OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.METADATA_PREFIX);
            surl = surl + "&identifier=" + id;
            OAIPMHRecordProvider.this.log.debug((Object)("Issuing request: " + surl));
            String response = null;
            try {
                response = this.streamer.getResponse(new URL(surl), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.TIMEOUT)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.DELAY)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.RETRY_DELAY)), Integer.parseInt(OAIPMHRecordProvider.this.pros.getProperty(OAIPMHRecordProvider.RETRY_EFFORTS)));
            }
            catch (NumberFormatException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            catch (MalformedURLException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            catch (IOException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            InputSource is = new InputSource(new StringReader(response));
            try {
                doc = this.builder.parse(is);
            }
            catch (SAXException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            catch (IOException e) {
                OAIPMHRecordProvider.this.log.error((Object)"", (Throwable)e);
                throw new DataException();
            }
            return doc;
        }
    }
}

