/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.persistance;

import com.thoughtworks.xstream.XStream;
import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.ResultSet;
import gr.uoa.di.validator.persistance.Persistance;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

public class XMLFilePersistance
implements Persistance {
    private XStream xstream = null;
    private Properties props = null;
    private String versionForRestore = null;
    private String versionForPersist = null;
    private Map<String, Integer> nums = new HashMap<String, Integer>();
    private transient Logger log = Logger.getLogger(XMLFilePersistance.class);
    public static final String DIRECTORY = "directory";

    public XMLFilePersistance(Properties props) {
        this.props = props;
    }

    @Override
    public <T extends Serializable> void persist(int objid, T obj, String container) throws DataException {
        if (this.versionForPersist == null) {
            try {
                this.getNextVersion();
                this.log.debug((Object)("Persisting to version " + this.versionForPersist));
            }
            catch (IOException e1) {
                this.log.error((Object)"", (Throwable)e1);
                throw new DataException();
            }
        }
        if (this.nums.get(container) == null) {
            this.nums.put(container, 0);
        }
        int num = this.nums.get(container);
        this.nums.put(container, num + 1);
        FileOutputStream stream = null;
        try {
            this.log.debug((Object)("Writing object " + objid + " to disk"));
            stream = new FileOutputStream(new File(this.getFileName(container, num, true)));
            this.xstream.toXML(obj, (OutputStream)stream);
            stream.close();
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new DataException();
        }
        catch (IOException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new DataException();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"FATAL IO ERROR", (Throwable)e);
                }
            }
        }
    }

    @Override
    public <T extends Serializable> ResultSet<T> restore(String container) throws DataException {
        if (this.versionForRestore == null) {
            try {
                this.getLatestVersion();
                this.log.debug((Object)("Restore version " + this.versionForRestore));
            }
            catch (IOException e1) {
                this.log.error((Object)"", (Throwable)e1);
                throw new DataException();
            }
        }
        return new XMLFilesResultSet(container);
    }

    private String getFileName(String container, int num, boolean persist) {
        String version = persist ? this.versionForPersist : this.versionForRestore;
        return this.props.getProperty(DIRECTORY) + "/" + version + "/" + container + "." + num + ".xml";
    }

    private String getNextVersion() throws IOException {
        this.log.debug((Object)("creating new persistance file on directory: " + this.props.getProperty(DIRECTORY)));
        File version = new File(this.props.getProperty(DIRECTORY) + "/version");
        if (!version.exists()) {
            version.createNewFile();
            this.versionForPersist = "0";
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(version));
        this.versionForPersist = UUID.randomUUID().toString();
        bw.write(this.versionForPersist);
        bw.close();
        File versionDirectory = new File(this.props.getProperty(DIRECTORY) + "/" + this.versionForPersist + "/");
        versionDirectory.mkdir();
        return this.versionForPersist;
    }

    private String getLatestVersion() throws IOException {
        File file = new File(this.props.getProperty(DIRECTORY) + "/version");
        if (!file.exists()) {
            this.versionForRestore = "0";
        } else {
            BufferedReader br = new BufferedReader(new FileReader(file));
            this.versionForRestore = br.readLine();
            br.close();
        }
        return this.versionForRestore;
    }

    @Override
    public void open() throws DataException {
        this.xstream = new XStream();
        try {
            this.getLatestVersion();
        }
        catch (IOException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new DataException();
        }
        if (this.versionForRestore.equals("0")) {
            File versionDirectory = new File(this.props.getProperty(DIRECTORY) + "/" + this.versionForRestore + "/");
            versionDirectory.mkdir();
        }
    }

    @Override
    public void close() {
        this.xstream = null;
        File dir = new File(this.props.getProperty(DIRECTORY));
        if (dir.exists() && dir.isDirectory()) {
            String[] dirNames;
            for (String dirName : dirNames = dir.list()) {
                if (dirName.equals(this.versionForPersist) || dirName.equals(this.versionForRestore) || dirName.equals("version")) continue;
                this.log.debug((Object)("Deleting older version " + dirName));
                this.deleteDir(new File(this.props.getProperty(DIRECTORY) + "/" + dirName + "/"));
            }
        }
    }

    private boolean deleteDir(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public class XMLFilesResultSet<T extends Serializable>
    implements ResultSet<T> {
        private final String container;
        private T current = null;
        private int num = 0;

        public XMLFilesResultSet(String container) {
            this.container = container;
        }

        @Override
        public boolean next() throws DataException {
            XMLFilePersistance.this.log.debug((Object)("Moving cursor to object from container " + this.container + " with num " + this.num));
            File file = new File(XMLFilePersistance.this.getFileName(this.container, this.num++, false));
            if (file.exists()) {
                this.current = (Serializable)XMLFilePersistance.this.xstream.fromXML(file);
                return true;
            }
            this.current = null;
            return false;
        }

        @Override
        public T get() throws DataException {
            return this.current;
        }

        @Override
        public String getError() {
            return null;
        }
    }
}

