/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.listeners;

import gr.uoa.di.validator.dao.JobSubmittedDAO;
import gr.uoa.di.validator.dao.RuleStored;
import gr.uoa.di.validator.dao.RuleStoredDAO;
import gr.uoa.di.validator.dao.TaskStored;
import gr.uoa.di.validator.dao.TaskStoredDAO;
import gr.uoa.di.validator.execution.CompletedTask;
import gr.uoa.di.validator.execution.JobListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorJobListener
implements JobListener {
    private static Logger logger = Logger.getLogger(ValidatorJobListener.class);
    private Integer jobSubmittedId;
    private String jobSubmittedUser;
    private TaskStoredDAO taskStoredDao;
    private JobSubmittedDAO jobSubmittedDao;
    private RuleStoredDAO ruleStoredDao;
    private int objsValidated = 0;
    private int score = 0;
    private int internalJobsFinished = 0;
    private String valBaseUrl = null;
    private int internalJobsSum = 1;
    private Map<Integer, Integer> ruleLinkingMap = new HashMap<Integer, Integer>();
    private String groupBy_xpath = null;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext, Throwable t) {
        logger.error((Object)("Completed tasks for " + jobId + " (exception). Error: " + t.getMessage()));
        ArrayList<TaskStored> tasksStored = new ArrayList<TaskStored>();
        for (CompletedTask ctask : tasks) {
            TaskStored taskStored = new TaskStored();
            taskStored.setEnded(ctask.finished.toString());
            taskStored.setStarted(ctask.started.toString());
            taskStored.setJobId(Integer.toString(this.jobSubmittedId));
            taskStored.setRecordIdentifier(ctask.valobjId);
            taskStored.setRuleId(Integer.toString(this.getRuleFromLink(ctask.ruleId)));
            taskStored.setSuccess(ctask.success);
            taskStored.setStatus("finished");
            tasksStored.add(taskStored);
            logger.debug((Object)("JOBID:" + this.jobSubmittedId + "# Task-failed: rule " + ctask.ruleId + " on " + ctask.valobjId + " with success " + ctask.success + " ruleId: " + taskStored.getRuleId() + " error:" + t.getMessage()));
        }
        List<String> groupBy_values = this.parseGroupByValues(record, this.groupBy_xpath);
        this.taskStoredDao.saveTasks(tasksStored, groupBy_values);
        this.jobSubmittedDao.setStatus(this.jobSubmittedId.toString(), "working - " + this.objsValidated + " records so far");
        ++this.objsValidated;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext) {
        ArrayList veloList = new ArrayList();
        logger.debug((Object)("JOBID:" + this.jobSubmittedId + "# Updating Completed Tasks"));
        System.out.println("Completed tasks for job " + jobId + " (no exception)");
        ArrayList<TaskStored> tasksStored = new ArrayList<TaskStored>();
        HashMap<Integer, Boolean> ruleIdsSuccess = new HashMap<Integer, Boolean>();
        HashMap<String, String> veloMap = null;
        for (CompletedTask ctask : tasks) {
            veloMap = new HashMap<String, String>();
            TaskStored taskStored = new TaskStored();
            taskStored.setEnded(ctask.finished.toString());
            taskStored.setStarted(ctask.started.toString());
            taskStored.setJobId(Integer.toString(this.jobSubmittedId));
            taskStored.setRecordIdentifier(ctask.valobjId);
            taskStored.setRuleId(Integer.toString(this.getRuleFromLink(ctask.ruleId)));
            taskStored.setSuccess(ctask.success);
            taskStored.setStatus("finished");
            tasksStored.add(taskStored);
            ruleIdsSuccess.put(Integer.parseInt(taskStored.getRuleId()), ctask.success);
            if (ctask.success) continue;
            veloMap.put("id", taskStored.getRuleId());
            veloMap.put("error", "...");
            veloList.add(veloMap);
        }
        List<String> groupBy_values = this.parseGroupByValues(record, this.groupBy_xpath);
        this.taskStoredDao.saveTasks(tasksStored, groupBy_values);
        this.jobSubmittedDao.setStatus(this.jobSubmittedId.toString(), "working - " + this.objsValidated + " records so far");
        int score = this.calculateRecordScore(ruleIdsSuccess);
        HashMap<String, String> recordValidationResult = new HashMap<String, String>();
        recordValidationResult.put("score", Integer.toString(score));
        recordValidationResult.put("id", tasks.get((int)0).valobjId);
        if (score > 0) {
            recordValidationResult.put("status", "pass");
        } else {
            recordValidationResult.put("status", "fail");
        }
        recordContext.put("veloList", veloList);
        recordContext.put("recordValidationResult", recordValidationResult);
        recordContext.put("score", score);
        ++this.objsValidated;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void finished(int jobId, Map<String, Object> jobContext) {
        ++this.internalJobsFinished;
        if (this.internalJobsFinished == this.internalJobsSum) {
            logger.debug((Object)("JOBID:" + this.jobSubmittedId + "# Set job finished"));
            this.jobSubmittedDao.setJobFinished(Integer.toString(this.jobSubmittedId), null, false);
            this.score = this.jobSubmittedDao.setScore(Integer.toString(this.jobSubmittedId), null, this.groupBy_xpath);
            jobContext.put("score", this.score);
            jobContext.put("jobSubmittedId", (int)this.jobSubmittedId);
            jobContext.put("jobSubmittedUser", this.jobSubmittedUser);
            jobContext.put("allJobsFinished", 1);
            logger.debug((Object)"score ok");
            this.taskStoredDao.cleanTasks(this.jobSubmittedId);
        } else {
            logger.debug((Object)("JOBID:" + this.jobSubmittedId + "#Job finished. Waiting " + (this.internalJobsSum - this.internalJobsFinished) + " job(s) to finish"));
            jobContext.put("allJobsFinished", 0);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
        ++this.internalJobsFinished;
        if (this.internalJobsFinished == this.internalJobsSum) {
            ++this.internalJobsFinished;
            logger.debug((Object)("JOBID:" + this.jobSubmittedId + "# Set job finished-failed"));
            this.jobSubmittedDao.setJobFinished(Integer.toString(this.jobSubmittedId), t.getMessage(), true);
            this.score = this.jobSubmittedDao.setScore(Integer.toString(this.jobSubmittedId), "0", this.groupBy_xpath);
            jobContext.put("score", 0);
            jobContext.put("jobSubmittedId", (int)this.jobSubmittedId);
            jobContext.put("jobSubmittedUser", this.jobSubmittedUser);
            jobContext.put("allJobsFinished", 1);
            this.taskStoredDao.cleanTasks(this.jobSubmittedId);
        } else {
            logger.debug((Object)("JOBID:" + this.jobSubmittedId + "#Job finished. Waiting " + (this.internalJobsSum - this.internalJobsFinished) + " job(s) to finish"));
            jobContext.put("allJobsFinished", 0);
        }
    }

    private int calculateRecordScore(Map<Integer, Boolean> ruleIdsSuccess) {
        float score = 0.0f;
        float sum = 0.0f;
        float weights = 0.0f;
        for (Map.Entry<Integer, Boolean> entry : ruleIdsSuccess.entrySet()) {
            RuleStored rule = (RuleStored)this.ruleStoredDao.get(entry.getKey().toString());
            if (rule.getMandatory().equals("true")) {
                weights += (float)Integer.parseInt(rule.getWeight());
                if (entry.getValue().booleanValue()) {
                    sum += (float)Integer.parseInt(rule.getWeight());
                }
            }
            score = sum / weights * 100.0f;
        }
        return (int)score;
    }

    private List<String> parseGroupByValues(Object record, String xpath) {
        ArrayList<String> groupBy_values = null;
        logger.debug((Object)("groupBy field: " + xpath));
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            NodeList rtl = (NodeList)xPath.evaluate(xpath + "/text()", record, XPathConstants.NODESET);
            groupBy_values = new ArrayList<String>();
            if (rtl.getLength() > 0) {
                for (int i = 0; i < rtl.getLength(); ++i) {
                    Node childNode = rtl.item(i);
                    groupBy_values.add(childNode.getNodeValue());
                    logger.debug((Object)("value: " + childNode.getNodeValue()));
                }
            } else {
                groupBy_values.add("all");
            }
        }
        catch (XPathExpressionException e) {
            logger.error((Object)("error getting object" + e));
        }
        return groupBy_values;
    }

    private int getRuleFromLink(int ruleRegistry) {
        return this.ruleLinkingMap.get(ruleRegistry);
    }

    public Integer getJobSubmittedId() {
        return this.jobSubmittedId;
    }

    public void setJobSubmittedId(Integer jobSubmittedId) {
        this.jobSubmittedId = jobSubmittedId;
    }

    public String getJobSubmittedUser() {
        return this.jobSubmittedUser;
    }

    public void setJobSubmittedUser(String jobSubmittedUser) {
        this.jobSubmittedUser = jobSubmittedUser;
    }

    public TaskStoredDAO getTaskStoredDao() {
        return this.taskStoredDao;
    }

    public void setTaskStoredDao(TaskStoredDAO taskStoredDao) {
        this.taskStoredDao = taskStoredDao;
    }

    public JobSubmittedDAO getJobSubmittedDao() {
        return this.jobSubmittedDao;
    }

    public void setJobSubmittedDao(JobSubmittedDAO jobSubmittedDao) {
        this.jobSubmittedDao = jobSubmittedDao;
    }

    public RuleStoredDAO getRuleStoredDao() {
        return this.ruleStoredDao;
    }

    public void setRuleStoredDao(RuleStoredDAO ruleStoredDao) {
        this.ruleStoredDao = ruleStoredDao;
    }

    public Map<Integer, Integer> getRuleLinkingMap() {
        return this.ruleLinkingMap;
    }

    public void setRuleLinkingMap(Map<Integer, Integer> ruleLinkingMap) {
        this.ruleLinkingMap = ruleLinkingMap;
    }

    public String getGroupBy_xpath() {
        return this.groupBy_xpath;
    }

    public void setGroupBy_xpath(String groupBy_xpath) {
        this.groupBy_xpath = groupBy_xpath;
    }

    public String getValBaseUrl() {
        return this.valBaseUrl;
    }

    public void setValBaseUrl(String valBaseUrl) {
        this.valBaseUrl = valBaseUrl;
    }

    public int getInternalJobsSum() {
        return this.internalJobsSum;
    }

    public void setInternalJobsSum(int internalJobsSum) {
        this.internalJobsSum = internalJobsSum;
    }
}

