/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.listeners;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecordXMLBuilder {
    private static Logger logger = Logger.getLogger(RecordXMLBuilder.class);
    private VelocityEngine ve = null;

    public void init() throws Exception {
        this.ve = new VelocityEngine();
        this.ve.setProperty("resource.loader", (Object)"classpath");
        this.ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        this.ve.init();
    }

    public String buildXml(List<Map<String, String>> veloList, Object record, Map<String, String> recordValidationResult) {
        logger.debug((Object)"Building XML file for record");
        String xmlRetString = null;
        try {
            VelocityContext context = new VelocityContext();
            NodeList list = ((Node)record).getChildNodes();
            Node recordNode = null;
            block7: for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!node.getNodeName().equals("root")) continue;
                logger.debug((Object)"root found");
                list = node.getChildNodes();
                for (i = 0; i < list.getLength(); ++i) {
                    node = list.item(i);
                    if (!node.getNodeName().equals("record")) continue;
                    recordNode = node;
                    logger.debug((Object)"record found");
                    continue block7;
                }
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("version", "no");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(recordNode);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            context.put("recordFull", (Object)xmlString);
            context.put("ruleList", veloList);
            context.put("record", recordValidationResult);
            Template t = this.ve.getTemplate("/gr/uoa/di/validator/impls/listeners/xml.vm");
            StringWriter writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
            xmlRetString = writer.toString();
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (ParseErrorException e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        return xmlRetString;
    }
}

