/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.listeners;

import eu.dnetlib.api.enabling.ResultSetService;
import eu.dnetlib.api.enabling.ResultSetServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.enabling.tools.blackboard.ActionStatus;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.validator.execution.CompletedTask;
import gr.uoa.di.validator.execution.JobListener;
import gr.uoa.di.validator.impls.listeners.RecordXMLBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DnetListener
implements JobListener {
    private static Logger logger = Logger.getLogger(DnetListener.class);
    private RecordXMLBuilder xmlBuilder;
    private BlackboardJob job;
    private ServiceLocator<ResultSetService> resultSetServiceLocator = null;
    private ResultSetService resultSetService;
    private String resultSetPassID;
    private String resultSetFailID;
    private List<String> passBuffer;
    private List<String> failBuffer;

    public void init() {
        try {
            this.resultSetService = (ResultSetService)this.resultSetServiceLocator.getService();
            EPR eprPass = this.resultSetService.createPushRS(86400, 0);
            EPR eprFail = this.resultSetService.createPushRS(86400, 0);
            this.resultSetPassID = eprPass.getParameter("ResourceIdentifier");
            this.resultSetFailID = eprFail.getParameter("ResourceIdentifier");
            this.passBuffer = new ArrayList<String>();
            this.failBuffer = new ArrayList<String>();
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing ResultSetService.", (Throwable)e);
        }
    }

    public void sendToPassQueue(String xmlString) {
        logger.debug((Object)"received passed XMLresult");
        this.passBuffer.add(xmlString);
        if (this.passBuffer.size() > 30) {
            try {
                this.resultSetService.populateRS(this.resultSetPassID, this.passBuffer);
                this.passBuffer.clear();
            }
            catch (ResultSetServiceException e) {
                logger.error((Object)"Error populating ResultSetService.", (Throwable)e);
            }
        }
        logger.debug((Object)("XML: " + xmlString));
    }

    public void sendToFailQueue(String xmlString) {
        logger.debug((Object)"received failed XMLresult");
        this.failBuffer.add(xmlString);
        if (this.failBuffer.size() > 30) {
            try {
                this.resultSetService.populateRS(this.resultSetFailID, this.failBuffer);
                this.failBuffer.clear();
            }
            catch (ResultSetServiceException e) {
                logger.error((Object)"Error populating ResultSetService.", (Throwable)e);
            }
        }
        logger.debug((Object)("XML: " + xmlString));
    }

    @Override
    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext, Throwable t) {
        String xmlString = this.xmlBuilder.buildXml((List)recordContext.get("veloList"), record, (Map)recordContext.get("recordValidationResult"));
        if ((Integer)recordContext.get("score") > 0) {
            this.sendToPassQueue(xmlString);
        } else {
            this.sendToFailQueue(xmlString);
        }
        logger.debug((Object)("XML: " + xmlString));
        this.job.setActionStatus(ActionStatus.ONGOING);
    }

    @Override
    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext) {
        String xmlString = this.xmlBuilder.buildXml((List)recordContext.get("veloList"), record, (Map)recordContext.get("recordValidationResult"));
        if ((Integer)recordContext.get("score") > 0) {
            this.sendToPassQueue(xmlString);
        } else {
            this.sendToFailQueue(xmlString);
        }
        logger.debug((Object)("XML: " + xmlString));
        this.job.setActionStatus(ActionStatus.ONGOING);
    }

    @Override
    public synchronized void finished(int jobId, Map<String, Object> jobContext) {
        if (this.passBuffer.size() > 0) {
            try {
                this.resultSetService.populateRS(this.resultSetPassID, this.passBuffer);
                this.passBuffer.clear();
            }
            catch (ResultSetServiceException e) {
                logger.error((Object)"Error populating ResultSetService.", (Throwable)e);
            }
        }
        if (this.failBuffer.size() > 0) {
            try {
                this.resultSetService.populateRS(this.resultSetFailID, this.failBuffer);
                this.failBuffer.clear();
            }
            catch (ResultSetServiceException e) {
                logger.error((Object)"Error populating ResultSetService.", (Throwable)e);
            }
        }
        this.resultSetService.closeRS(this.resultSetPassID);
        this.resultSetService.closeRS(this.resultSetFailID);
        this.job.setActionStatus(ActionStatus.DONE);
    }

    @Override
    public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
        this.resultSetService.closeRS(this.resultSetPassID);
        this.resultSetService.closeRS(this.resultSetFailID);
        this.job.setActionStatus(ActionStatus.FAILED);
    }

    public RecordXMLBuilder getXmlBuilder() {
        return this.xmlBuilder;
    }

    public void setXmlBuilder(RecordXMLBuilder xmlBuilder) {
        this.xmlBuilder = xmlBuilder;
    }

    public BlackboardJob getJob() {
        return this.job;
    }

    public void setJob(BlackboardJob job) {
        this.job = job;
    }

    public ServiceLocator<ResultSetService> getResultSetServiceLocator() {
        return this.resultSetServiceLocator;
    }

    public void setResultSetServiceLocator(ServiceLocator<ResultSetService> resultSetServiceLocator) {
        this.resultSetServiceLocator = resultSetServiceLocator;
    }
}

