/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.executors;

import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.Provider;
import gr.uoa.di.validator.data.ResultSet;
import gr.uoa.di.validator.data.Rule;
import gr.uoa.di.validator.execution.Executor;
import gr.uoa.di.validator.execution.JobListener;
import gr.uoa.di.validator.execution.Task;
import gr.uoa.di.validator.execution.TaskList;
import gr.uoa.di.validator.execution.ValidationObject;
import gr.uoa.di.validator.impls.executors.ExecutorSubmitter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ThreadExecutorSubmitter
extends ExecutorSubmitter {
    private transient Logger log = Logger.getLogger(ThreadExecutorSubmitter.class);
    public final Executor executor;
    public final long timeout;
    public final long generalTimeout;
    private Map<String, Object> recordContext;

    public ThreadExecutorSubmitter(int jobId, List<Rule> rules, Provider provider, JobListener validatorListener, Executor executor, long timeout, long generalTimeout, JobListener ... listeners) {
        super(jobId, rules, provider, new HashMap<String, Object>(), validatorListener, listeners);
        this.log.debug((Object)("Creating a new executor submitter with timeout " + timeout + " and general timeout " + generalTimeout));
        this.executor = executor;
        this.timeout = timeout;
        this.generalTimeout = generalTimeout;
    }

    @Override
    public void submit() throws ExecutorSubmitter.ExecutionException {
        long elapsed = 0L;
        int count = 0;
        int record_limit = -1;
        if (this.provider.getConfiguration().getProperty("records") != null && !this.provider.getConfiguration().getProperty("records").trim().equals("all")) {
            record_limit = Integer.parseInt(this.provider.getConfiguration().getProperty("records").trim());
        }
        if (this.provider.getConfiguration().getProperty("RECORDS") != null && !this.provider.getConfiguration().getProperty("RECORDS").trim().equals("all")) {
            record_limit = Integer.parseInt(this.provider.getConfiguration().getProperty("RECORDS").trim());
        }
        this.log.debug((Object)("Number of records to validate: " + record_limit + " (-1 for all)"));
        boolean success = false;
        ArrayList<Task> tasks = new ArrayList<Task>();
        ResultSet<ValidationObject> ivobjs = null;
        try {
            this.log.debug((Object)"request to get validation objects..");
            ivobjs = this.provider.getValidationObjects();
        }
        catch (Provider.ProviderException e1) {
            this.log.error((Object)"", (Throwable)e1);
            for (JobListener listener : this.listeners) {
                listener.failed(this.jobId, this.jobContext, e1);
            }
        }
        block7: while (true) {
            try {
                while (ivobjs.next() && (count < record_limit || record_limit == -1)) {
                    this.recordContext = new HashMap<String, Object>();
                    tasks.clear();
                    ValidationObject vobj = ivobjs.get();
                    this.log.debug((Object)("Applying rules on object " + vobj.getId()));
                    if (vobj.getStatus() != null && vobj.getStatus().equalsIgnoreCase("deleted")) {
                        this.log.debug((Object)"Object is deleted and will be ignored");
                        continue;
                    }
                    ++count;
                    for (Rule rule : this.rules) {
                        Task task = new Task(vobj, rule);
                        tasks.add(task);
                    }
                    TaskList ltasks = new TaskList(tasks);
                    try {
                        long time1 = Calendar.getInstance().getTimeInMillis() / 1000L;
                        this.executor.execute(ltasks).get(this.timeout, TimeUnit.SECONDS);
                        long time2 = Calendar.getInstance().getTimeInMillis() / 1000L;
                        this.log.debug((Object)("Task execution took " + (time2 - time1) + " seconds"));
                        this.log.debug((Object)("Elapsed time till now is " + (elapsed += time2 - time1) + " seconds"));
                        if (elapsed > this.generalTimeout) {
                            throw new ExecutorSubmitter.ExecutionException("Job timed out");
                        }
                        for (JobListener listener : this.listeners) {
                            listener.currentResults(ltasks.getCtasks(), this.jobId, vobj.getContentAsObject(), this.recordContext);
                        }
                        success = true;
                        continue block7;
                    }
                    catch (Exception e) {
                        this.log.error((Object)("an error occured: " + e));
                        for (JobListener listener : this.listeners) {
                            listener.currentResults(ltasks.getCtasks(), this.jobId, vobj.getContentAsObject(), this.recordContext, e);
                        }
                    }
                }
                break;
            }
            catch (DataException e) {
                this.log.error((Object)"data error", (Throwable)e);
                for (JobListener listener : this.listeners) {
                    listener.failed(this.jobId, this.jobContext, e);
                }
                break;
            }
        }
        if (success) {
            for (JobListener listener : this.listeners) {
                listener.finished(this.jobId, this.jobContext);
            }
        } else {
            this.log.error((Object)"an error occured");
            for (JobListener listener : this.listeners) {
                if (ivobjs.getError() == null) {
                    listener.failed(this.jobId, this.jobContext, new ExecutorSubmitter.ExecutionException("All tasks failed"));
                    continue;
                }
                listener.failed(this.jobId, this.jobContext, new ExecutorSubmitter.ExecutionException(ivobjs.getError()));
                this.log.error((Object)("an error occured : " + new ExecutorSubmitter.ExecutionException(ivobjs.getError()).getMessage()));
            }
        }
    }
}

