/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls.executors;

import gr.uoa.di.validator.ValidatorException;
import gr.uoa.di.validator.data.Provider;
import gr.uoa.di.validator.data.Rule;
import gr.uoa.di.validator.execution.JobListener;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ExecutorSubmitter
implements Runnable {
    public final int jobId;
    public final List<Rule> rules;
    public final Provider provider;
    public final JobListener validatorListener;
    public final JobListener[] listeners;
    protected Map<String, Object> jobContext;
    private transient Logger log = Logger.getLogger(ExecutorSubmitter.class);

    public ExecutorSubmitter(int jobId, List<Rule> rules, Provider provider, Map<String, Object> jobContext, JobListener validatorListener, JobListener ... listeners) {
        this.jobId = jobId;
        this.rules = rules;
        this.provider = provider;
        this.jobContext = jobContext;
        this.listeners = listeners;
        this.validatorListener = validatorListener;
    }

    public abstract void submit() throws ExecutionException;

    @Override
    public void run() {
        try {
            this.submit();
        }
        catch (ExecutionException e) {
            this.log.error((Object)"", (Throwable)e);
            for (JobListener listener : this.listeners) {
                listener.failed(this.jobId, this.jobContext, e);
            }
            this.validatorListener.failed(this.jobId, this.jobContext, e);
            return;
        }
        this.validatorListener.finished(this.jobId, this.jobContext);
    }

    public class ExecutionException
    extends ValidatorException {
        private static final long serialVersionUID = -1748951703892618739L;

        public ExecutionException() {
        }

        public ExecutionException(String msg) {
            super(msg);
        }
    }
}

