/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.impls;

import eu.dnetlib.data.information.DataSourceResolver;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.validator.Validator;
import gr.uoa.di.validator.ValidatorException;
import gr.uoa.di.validator.data.DataException;
import gr.uoa.di.validator.data.Provider;
import gr.uoa.di.validator.data.ResultSet;
import gr.uoa.di.validator.data.Rule;
import gr.uoa.di.validator.execution.CompletedTask;
import gr.uoa.di.validator.execution.Executor;
import gr.uoa.di.validator.execution.Job;
import gr.uoa.di.validator.execution.JobListener;
import gr.uoa.di.validator.impls.executors.ThreadExecutorSubmitter;
import gr.uoa.di.validator.impls.persistance.MemoryRegistry;
import gr.uoa.di.validator.impls.persistance.ThreadSafeMemoryRegistry;
import gr.uoa.di.validator.impls.providers.OAIPMHRecordProvider;
import gr.uoa.di.validator.impls.providers.OAIPMHSinglePageVerbProvider;
import gr.uoa.di.validator.persistance.Persistance;
import gr.uoa.di.validator.service.DnetProvider;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class MemoryThreadValidator
implements Validator {
    private transient Logger log = Logger.getLogger(MemoryThreadValidator.class);
    private final Persistance persistance;
    private final ExecutorService executor;
    private final Executor taskExecutor;
    private final long timeout;
    private final long generalTimeout;
    private DataSourceResolver dataSourceResolver = null;
    private ResultSetFactory rsFactory = null;
    private ThreadSafeMemoryRegistry<Job> jobs;
    private MemoryRegistry<Rule> rules;
    private MemoryRegistry<Provider> providers;

    public MemoryThreadValidator(Persistance persistance, ExecutorService executor, Executor taskExecutor, long timeout, long generalTimeout) {
        this.log.debug((Object)"Creating a new Validator");
        this.persistance = persistance;
        this.executor = executor;
        this.taskExecutor = taskExecutor;
        this.timeout = timeout;
        this.generalTimeout = generalTimeout;
        this.jobs = new ThreadSafeMemoryRegistry("JOBS");
        this.rules = new MemoryRegistry("RULES");
        this.providers = new MemoryRegistry("PROVIDERS");
    }

    public void init() {
    }

    @Override
    public void persist() throws DataException {
        this.log.debug((Object)"Persisting the validator");
        try {
            this.persistance.open();
            this.log.debug((Object)"Persisting the rules");
            for (Rule rule : this.rules.getAllObjects().values()) {
                this.log.debug((Object)("Persisting rule: " + rule.getId()));
                this.persistance.persist(rule.getId(), rule, "RULES");
            }
            this.log.debug((Object)"Persisting the providers");
            for (Provider provider : this.providers.getAllObjects().values()) {
                this.log.debug((Object)("Persisting provider: " + provider.getId()));
                this.persistance.persist(provider.getId(), provider, "PROVIDERS");
            }
            this.log.debug((Object)"Persisting the jobs");
            this.jobs.lock();
            for (Job job : this.jobs.getAllObjects().values()) {
                this.log.debug((Object)("Persisting job: " + job.id));
                this.persistance.persist(job.id, job, "JOBS");
            }
            this.jobs.unlock();
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            throw e;
        }
        finally {
            this.persistance.close();
        }
    }

    @Override
    public void restore() throws DataException {
        this.log.debug((Object)"Restoring the validator");
        try {
            this.persistance.open();
            this.log.debug((Object)"Restoring the rules");
            ResultSet ruleRS = this.persistance.restore("RULES");
            while (ruleRS.next()) {
                Rule rule = (Rule)ruleRS.get();
                this.log.debug((Object)("Restoring rule: " + rule.getId()));
                this.rules.addObject(rule.getId(), rule);
            }
            this.log.debug((Object)"Restoring the providers");
            ResultSet providerRS = this.persistance.restore("PROVIDERS");
            while (providerRS.next()) {
                Provider provider = (Provider)providerRS.get();
                this.log.debug((Object)("Persisting provider: " + provider.getId()));
                this.providers.addObject(provider.getId(), provider);
            }
            this.log.debug((Object)"Restoring the jobs");
            this.jobs.lock();
            ResultSet jobRS = this.persistance.restore("JOBS");
            while (jobRS.next()) {
                Job job = (Job)jobRS.get();
                this.log.debug((Object)("Persisting job: " + job.id));
                this.jobs.addObject(job.id, job);
            }
            this.jobs.unlock();
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            throw e;
        }
        finally {
            this.persistance.close();
        }
    }

    @Override
    public <T extends Serializable> void addToRegistry(int objid, T obj, String registryName) {
        if (registryName.equals("PROVIDERS")) {
            Provider provider = (Provider)obj;
            this.log.debug((Object)("Adding to registry provider " + provider.getId()));
            this.providers.addObject(provider.getId(), provider);
        } else if (registryName.equals("RULES")) {
            Rule rule = (Rule)obj;
            this.log.debug((Object)("Adding to registry rule " + rule.getId()));
            this.rules.addObject(rule.getId(), rule);
        } else {
            throw new UnsupportedOperationException("You may not add an object to a non-existing registry");
        }
    }

    @Override
    public Serializable getFromRegistry(int objid, String registryName) throws ValidatorException {
        if (registryName.equals("PROVIDERS")) {
            return this.providers.getObject(objid);
        }
        if (registryName.equals("RULES")) {
            return this.rules.getObject(objid);
        }
        if (registryName.equals("JOBS")) {
            this.jobs.lock();
            Job ret = (Job)this.jobs.getObject(objid);
            this.jobs.unlock();
            return ret;
        }
        throw new ValidatorException("The registry " + registryName + " does not exist");
    }

    @Override
    public <T extends Serializable> void addRegistry(String name) {
        throw new UnsupportedOperationException("You may not add new registries to this Validator implementation");
    }

    @Override
    public void submitJob(Job job, JobListener ... listeners) throws ValidatorException {
        this.log.debug((Object)("Submitting job " + job.id));
        this.jobs.lock();
        this.jobs.addObject(job.id, job);
        this.jobs.unlock();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Integer ruleId : job.ruleIds) {
            rules.add(this.rules.getObject(ruleId));
        }
        Provider prv = this.providers.getObject(job.providerId);
        Provider provider = null;
        try {
            this.log.debug((Object)"Creating a new provider instance");
            provider = (Provider)prv.getClass().getConstructor(Integer.class).newInstance(job.providerId);
        }
        catch (SecurityException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new ValidatorException();
        }
        catch (NoSuchMethodException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new ValidatorException();
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new ValidatorException();
        }
        catch (InstantiationException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new ValidatorException();
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new ValidatorException();
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new ValidatorException();
        }
        provider.setConfiguration(job.providerProps);
        ThreadExecutorSubmitter submitter = new ThreadExecutorSubmitter(job.id, rules, provider, new ValidatorJobListener(), this.taskExecutor, this.timeout, this.generalTimeout, listeners);
        this.executor.submit(submitter);
    }

    @Override
    public void shutdown() throws ValidatorException {
        this.log.debug((Object)"Shutting down validator");
        this.jobs = null;
        this.providers = null;
        this.rules = null;
    }

    @Override
    public List<Job> start() throws ValidatorException {
        this.log.debug((Object)"Starting validator");
        OAIPMHRecordProvider prv1 = new OAIPMHRecordProvider(1);
        OAIPMHSinglePageVerbProvider prv2 = new OAIPMHSinglePageVerbProvider(2);
        DnetProvider prv3 = new DnetProvider(3);
        DnetProvider.setDataSourceResolver(this.dataSourceResolver);
        DnetProvider.setRsFactory(this.rsFactory);
        this.addToRegistry(1, prv1, "PROVIDERS");
        this.addToRegistry(2, prv2, "PROVIDERS");
        this.addToRegistry(3, prv3, "PROVIDERS");
        ArrayList<Job> ret = new ArrayList<Job>();
        for (Job job : this.jobs.getAllObjects().values()) {
            ret.add(job);
        }
        this.jobs = new ThreadSafeMemoryRegistry("JOBS");
        return ret;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public ResultSetFactory getRsFactory() {
        return this.rsFactory;
    }

    public void setRsFactory(ResultSetFactory rsFactory) {
        this.rsFactory = rsFactory;
    }

    private class ValidatorJobListener
    implements JobListener {
        private ValidatorJobListener() {
        }

        @Override
        public void currentResults(List<CompletedTask> tasks, int jobId, Object object, Map<String, Object> recordContext, Throwable t) {
        }

        @Override
        public void currentResults(List<CompletedTask> tasks, int jobId, Object object, Map<String, Object> recordContext) {
        }

        @Override
        public void finished(int jobId, Map<String, Object> jobContext) {
            MemoryThreadValidator.this.log.debug((Object)("Job " + jobId + " has finished, removing it from the reigstry"));
            MemoryThreadValidator.this.jobs.lock();
            MemoryThreadValidator.this.jobs.removeObject(jobId);
            MemoryThreadValidator.this.jobs.unlock();
        }

        @Override
        public void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
            MemoryThreadValidator.this.log.debug((Object)"A job has finished, removing it from the registry");
            MemoryThreadValidator.this.jobs.lock();
            MemoryThreadValidator.this.jobs.removeObject(jobId);
            MemoryThreadValidator.this.jobs.unlock();
        }
    }

    public static interface RegistryType {
        public static final String jobs = "JOBS";
        public static final String rules = "RULES";
        public static final String providers = "PROVIDERS";
    }
}

