/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.dao;

import gr.uoa.di.validator.dao.AbstractDAO;
import gr.uoa.di.validator.dao.UserStored;
import gr.uoa.di.validator.dao.UserStoredDAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UserStoredDAOimpl
extends AbstractDAO<UserStored>
implements UserStoredDAO {
    @Override
    protected PreparedStatement getUpdateStatement(UserStored t, Connection con) throws SQLException {
        String query = "UPDATE users SET activation_id=? WHERE activation_id=?";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setString(1, null);
        stmt.setString(2, t.getActivationId());
        return stmt;
    }

    @Override
    protected PreparedStatement getInsertStatement(UserStored t, Connection con) throws SQLException {
        String query = "INSERT INTO users(email,password,activation_id) VALUES(?,?,?)";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setString(1, t.getEmail());
        stmt.setString(2, t.getPassword());
        stmt.setString(3, t.getActivationId());
        return stmt;
    }

    @Override
    protected PreparedStatement getDeleteStatement(String id, Connection con) throws SQLException {
        return null;
    }

    @Override
    protected int getLastId() throws SQLException {
        return 0;
    }

    @Override
    public UserStored get(String id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCorrectCreds(UserStored newUser) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to check correct credentials");
        try {
            con = this.getConnection();
            String query = "SELECT * FROM users WHERE email=? AND password=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, newUser.getEmail());
            stmt.setString(2, newUser.getPassword());
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to check correct credentials: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to check correct credentials: " + e));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdmin(String email) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to check if user is admin");
        try {
            con = this.getConnection();
            String query = "SELECT * FROM admins WHERE username=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, email);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to check if user is admin: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to check if user is admin: " + e));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActivated(String email) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to check if user is activated");
        try {
            con = this.getConnection();
            String query = "SELECT * FROM users WHERE email=? AND activation_id is null";
            stmt = con.prepareStatement(query);
            stmt.setString(1, email);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to check if user is activated " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to check if user is activated " + e));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean userExists(String email) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)("Accessing DB to check if user " + email + " exists"));
        try {
            con = this.getConnection();
            String query = "SELECT * FROM users WHERE email=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, email);
            rs = stmt.executeQuery();
            if (rs.next()) {
                logger.debug((Object)"user exists");
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to check if user exists: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to check if user exists: " + e));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareResetPassword(String uuid, String email) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to prepare reset password");
        try {
            con = this.getConnection();
            String query = "UPDATE users SET activation_id=? WHERE email=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, uuid);
            stmt.setString(2, email);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to prepare reset password: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to prepare reset password: " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ResetPassword(String uuid, String password) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to reset password");
        try {
            con = this.getConnection();
            String query = "UPDATE users SET password=? WHERE activation_id=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, password);
            stmt.setString(2, uuid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to reset password: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to reset password: " + e));
                }
            }
        }
    }
}

