/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.dao;

import gr.uoa.di.validator.dao.AbstractDAO;
import gr.uoa.di.validator.dao.TaskStored;
import gr.uoa.di.validator.dao.TaskStoredDAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TaskStoredDAOimpl
extends AbstractDAO<TaskStored>
implements TaskStoredDAO {
    @Override
    protected PreparedStatement getUpdateStatement(TaskStored t, Connection con) throws SQLException {
        String query = "UPDATE tasks set status=?, success=?, started=?, ended=?, record_url=? WHERE job_id=? AND rule_id=? AND record_identifier=?";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setString(1, t.getStatus());
        stmt.setBoolean(2, t.getSuccess());
        stmt.setString(3, t.getStarted());
        stmt.setString(4, t.getEnded());
        stmt.setString(5, t.getRecordUrl());
        stmt.setInt(6, Integer.parseInt(t.getJobId()));
        stmt.setInt(7, Integer.parseInt(t.getRuleId()));
        stmt.setString(8, t.getRecordIdentifier());
        return stmt;
    }

    @Override
    protected PreparedStatement getInsertStatement(TaskStored t, Connection con) throws SQLException {
        String query = "INSERT INTO tasks(status, success, started, ended, job_id, rule_id, record_identifier, record_url) VALUES(?,?,?,?,?,?,?,?)";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setString(1, t.getStatus());
        stmt.setBoolean(2, t.getSuccess());
        stmt.setString(3, t.getStarted());
        stmt.setString(4, t.getEnded());
        stmt.setInt(5, Integer.parseInt(t.getJobId()));
        stmt.setInt(6, Integer.parseInt(t.getRuleId()));
        stmt.setString(7, t.getRecordIdentifier());
        stmt.setString(8, t.getRecordUrl());
        return stmt;
    }

    @Override
    protected PreparedStatement getDeleteStatement(String id, Connection con) throws SQLException {
        String query = "DELETE FROM tasks WHERE job_id=?";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setInt(1, Integer.parseInt(id));
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskStored> getTasksOfJob(String id) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        TaskStored retTask = null;
        ArrayList<TaskStored> retList = null;
        logger.debug((Object)"Accessing DB to get all Tasks of Job");
        try {
            con = this.getConnection();
            String query = "SELECT status, success, started, ended, rule_id, record_identifier, record_url FROM tasks WHERE job_id=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<TaskStored>();
                while (rs.next()) {
                    retTask = new TaskStored();
                    retTask.setStatus(rs.getString(1));
                    retTask.setSuccess(rs.getBoolean(2));
                    retTask.setStarted(rs.getString(3));
                    retTask.setEnded(rs.getString(4));
                    retTask.setRuleId(Integer.toString(rs.getInt(5)));
                    retTask.setRecordIdentifier(rs.getString(6));
                    retTask.setRecordUrl(rs.getString(7));
                    retTask.setJobId(id);
                    retList.add(retTask);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Accessing DB to get all Tasks of Job: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to get all Tasks of Job: " + e));
                }
            }
        }
        return retList;
    }

    @Override
    public TaskStored get(String id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getValidationErrors(String jobId, String ruleId) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        ArrayList<String> retList = null;
        logger.debug((Object)("Accessing DB to get Validation Errors of JobId " + jobId + " and RuleId " + ruleId));
        try {
            con = this.getConnection();
            String query = "SELECT record_identifier FROM tasks WHERE job_id=? AND rule_id=? AND success=? LIMIT 30";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(jobId));
            stmt.setInt(2, Integer.parseInt(ruleId));
            stmt.setBoolean(3, false);
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<String>();
                while (rs.next()) {
                    retList.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Accessing DB to get Validation Errors of a JobId and RuleId: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to get Validation Errors of a JobId and RuleId: " + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDistinctTasksOfJob(String jobId) {
        ArrayList<String> retList = null;
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to get Distinct Rule ids of Tasks");
        try {
            con = this.getConnection();
            String query = "SELECT distinct rule_id from tasks where job_id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(jobId));
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<String>();
                while (rs.next()) {
                    retList.add(Integer.toString(rs.getInt(1)));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Accessing DB to get Distinct Rule ids of Tasks: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to get Distinct Rule ids of Tasks: " + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskStored> getFinishedTasks(String jobId, String ruleId) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        TaskStored retTask = null;
        ArrayList<TaskStored> retList = null;
        logger.debug((Object)"Accessing DB to get Finished Tasks");
        try {
            con = this.getConnection();
            String query = "SELECT success, record_identifier FROM tasks WHERE job_id=? AND rule_id=? AND status=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(jobId));
            stmt.setInt(2, Integer.parseInt(ruleId));
            stmt.setString(3, "finished");
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<TaskStored>();
                while (rs.next()) {
                    retTask = new TaskStored();
                    retTask.setSuccess(rs.getBoolean(1));
                    retTask.setRecordIdentifier(rs.getString(2));
                    retList.add(retTask);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Accessing DB to get Finished Tasks: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to get Finished Tasks: " + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTasks(List<TaskStored> tasks, List<String> groupBy_values) {
        Connection con = null;
        Statement stmt = null;
        Statement stmt1 = null;
        logger.debug((Object)"Accessing DB to save batch of tasks");
        try {
            con = this.getConnection();
            String query = "INSERT INTO tasks(status, success, started, ended, job_id, rule_id, record_identifier, record_url) VALUES(?,?,?,?,?,?,?,?)";
            stmt = con.prepareStatement(query);
            stmt = con.prepareStatement(query);
            for (TaskStored t : tasks) {
                stmt.setString(1, t.getStatus());
                stmt.setBoolean(2, t.getSuccess());
                stmt.setString(3, t.getStarted());
                stmt.setString(4, t.getEnded());
                stmt.setInt(5, Integer.parseInt(t.getJobId()));
                stmt.setInt(6, Integer.parseInt(t.getRuleId()));
                stmt.setString(7, t.getRecordIdentifier());
                stmt.setString(8, t.getRecordUrl());
                stmt.addBatch();
            }
            stmt.executeBatch();
            logger.debug((Object)("Tasks inserted: " + tasks.size()));
            if (groupBy_values != null) {
                logger.debug((Object)"Inserting record's groupBy values..");
                query = "INSERT INTO record_groupby(record_id, groupby, job_id) VALUES(?,?,?)";
                stmt1 = con.prepareStatement(query);
                for (String value : groupBy_values) {
                    stmt1.setString(1, tasks.get(0).getRecordIdentifier());
                    stmt1.setString(2, value);
                    stmt1.setInt(3, Integer.parseInt(tasks.get(0).getJobId()));
                    stmt1.addBatch();
                }
                stmt1.executeBatch();
                logger.debug((Object)("groupBy values inserted: " + groupBy_values.size()));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error Accessing DB to save batch of tasks" + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to save batch of tasks" + e));
                }
            }
            if (stmt1 != null) {
                try {
                    stmt1.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to save batch of tasks" + e));
                }
            }
        }
    }

    @Override
    protected int getLastId() throws SQLException {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanTasks(int jobId) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete unneeded tasks");
        try {
            con = this.getConnection();
            String query = "DELETE FROM tasks WHERE job_id = ? AND success = ?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, jobId);
            stmt.setBoolean(2, true);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to delete unneeded tasks: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while Accessing DB to delete unneeded tasks: " + e));
                }
            }
        }
    }
}

