/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.dao;

import gr.uoa.di.validator.dao.AbstractDAO;
import gr.uoa.di.validator.dao.RulePair;
import gr.uoa.di.validator.dao.RuleStored;
import gr.uoa.di.validator.dao.RuleStoredDAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class RuleStoredDAOimpl
extends AbstractDAO<RuleStored>
implements RuleStoredDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer save(RuleStored t) {
        Connection con = null;
        Statement stmt = null;
        Integer retId = -1;
        logger.debug((Object)"Accessing DB to save/update Rule");
        try {
            logger.debug((Object)"Accessing DB to update Rule");
            con = this.getConnection();
            String query = "UPDATE rules SET name=?, description=?, type=?, mandatory=?, weight=?, provider_information=? WHERE id=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, t.getName());
            stmt.setString(2, t.getDescription());
            stmt.setString(3, t.getType());
            stmt.setString(4, t.getMandatory());
            stmt.setInt(5, Integer.parseInt(t.getWeight()));
            stmt.setString(6, t.getProvider_information());
            stmt.setInt(7, Integer.parseInt(t.getId()));
            if (stmt.executeUpdate() == 0) {
                stmt.close();
                logger.debug((Object)("Accessing DB to save Rule with name:" + t.getName() + ",desc:" + t.getDescription() + ",type:" + t.getType() + ",mand:" + t.getMandatory() + ",weight:" + t.getWeight() + ",pr_inf:" + t.getProvider_information() + ",jb_tp:" + t.getJob_type()));
                query = "INSERT INTO rules(name, description, type, mandatory, weight, provider_information, job_type) VALUES(?,?,?,?,?,?,?)";
                stmt = con.prepareStatement(query);
                stmt.setString(1, t.getName());
                stmt.setString(2, t.getDescription());
                stmt.setString(3, t.getType());
                stmt.setString(4, t.getMandatory());
                stmt.setInt(5, Integer.parseInt(t.getWeight()));
                stmt.setString(6, t.getProvider_information());
                stmt.setString(7, t.getJob_type());
                stmt.executeUpdate();
                retId = this.getLastId();
            } else {
                logger.debug((Object)"Accessing DB to update Rule-done");
                retId = Integer.parseInt(t.getId());
            }
            stmt.close();
            logger.debug((Object)"Accessing DB to delete Rule properties");
            query = "DELETE FROM rule_properties  WHERE rule_id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, retId);
            if (stmt.executeUpdate() == 0) {
                stmt.close();
            }
            logger.debug((Object)"Accessing DB to insert Rule properties");
            query = "INSERT INTO rule_properties(rule_id, property_name, property_value) VALUES(?,?,?)";
            stmt = con.prepareStatement(query);
            Properties pros = t.getConfiguration();
            Enumeration<?> e = pros.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                logger.debug((Object)("Accessing DB to add property:" + key + "-" + pros.getProperty(key)));
                stmt.setInt(1, retId);
                stmt.setString(2, key);
                stmt.setString(3, pros.getProperty(key));
                stmt.addBatch();
            }
            stmt.executeBatch();
            logger.debug((Object)"Rule + Properties inserted/updated");
        }
        catch (SQLException e) {
            logger.error((Object)("Error accessing DB to get save/update Rule" + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error accessing DB to get save/update Rule" + e));
                }
            }
        }
        return retId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String delete(String id) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete Rule");
        try {
            con = this.getConnection();
            String query = "DELETE FROM rules  WHERE id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(id));
            if (stmt.executeUpdate() == 0) {
                stmt.close();
            }
            query = "DELETE FROM rule_properties  WHERE rule_id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(id));
            if (stmt.executeUpdate() == 0) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error accessing DB to delete Rule" + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error accessing DB to delete Rule" + e));
                }
            }
        }
        return null;
    }

    @Override
    protected PreparedStatement getDeleteStatement(String id, Connection con) throws SQLException {
        String query = "DELETE FROM rules  WHERE id=?";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setInt(1, Integer.parseInt(id));
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RuleStored> getAllRulesByJobType(String jobType) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        RuleStored retRule = null;
        ArrayList<RuleStored> retList = null;
        logger.debug((Object)"Accessing DB to get All Rules by jobType");
        try {
            con = this.getConnection();
            String query = "SELECT name, description, type, mandatory, weight, provider_information, id FROM rules WHERE job_type=? ORDER BY name";
            stmt = con.prepareStatement(query);
            stmt.setString(1, jobType);
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<RuleStored>();
                while (rs.next()) {
                    retRule = new RuleStored();
                    retRule.setName(rs.getString(1));
                    retRule.setDescription(rs.getString(2));
                    retRule.setType(rs.getString(3));
                    retRule.setMandatory(rs.getString(4));
                    retRule.setWeight(Integer.toString(rs.getInt(5)));
                    retRule.setProvider_information(rs.getString(6));
                    retRule.setId(Integer.toString(rs.getInt(7)));
                    retRule.setJob_type(jobType);
                    retRule.setConfiguration(this.getProperties(rs.getString(7)));
                    retList.add(retRule);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error accessing DB to get All Rules by jobType" + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error accessing DB to get All Rules by jobType" + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RulePair> getAllRulesToRulePair() {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        RulePair retRule = null;
        ArrayList<RulePair> retList = null;
        logger.debug((Object)"Accessing DB to get All Rule-pairs");
        try {
            con = this.getConnection();
            String query = "SELECT id, name FROM rules ORDER BY name";
            stmt = con.prepareStatement(query);
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<RulePair>();
                while (rs.next()) {
                    retRule = new RulePair(Integer.toString(rs.getInt(1)), rs.getString(2));
                    retList.add(retRule);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error accessing DB to get All Rule-pairs" + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error accessing DB to get All Rule-pairs" + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties(String ruleId) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        Properties pros = null;
        try {
            con = this.getConnection();
            String query = "SELECT property_name, property_value FROM rule_properties WHERE rule_id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(ruleId));
            rs = stmt.executeQuery();
            if (rs != null) {
                pros = new Properties();
                while (rs.next()) {
                    pros.setProperty(rs.getString(1), rs.getString(2));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Accessing DB to get Rule Properties: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to get Rule Properties: " + e));
                }
            }
        }
        return pros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleStored get(String id) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        RuleStored retRule = null;
        try {
            con = this.getConnection();
            String query = "SELECT name, description, type, mandatory, weight, provider_information, job_type FROM rules WHERE id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(id));
            rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                retRule = new RuleStored();
                retRule.setName(rs.getString(1));
                retRule.setDescription(rs.getString(2));
                retRule.setType(rs.getString(3));
                retRule.setMandatory(rs.getString(4));
                retRule.setWeight(Integer.toString(rs.getInt(5)));
                retRule.setProvider_information(rs.getString(6));
                retRule.setJob_type(rs.getString(7));
                retRule.setId(id);
                retRule.setConfiguration(this.getProperties(id));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Accessing DB to get Rule: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to get Rule: " + e));
                }
            }
        }
        return retRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLastId() throws SQLException {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        int retId = -1;
        logger.debug((Object)"Accessing DB to get Rule's next available id");
        try {
            con = this.getConnection();
            String query = "SELECT currval(pg_get_serial_sequence(?,?)) FROM rules";
            stmt = con.prepareStatement(query);
            stmt.setString(1, "rules");
            stmt.setString(2, "id");
            rs = stmt.executeQuery();
            if (rs != null) {
                rs.next();
                retId = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to get Rule's next available id: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to get Rule's next available id: " + e));
                }
            }
        }
        return retId;
    }

    @Override
    protected PreparedStatement getUpdateStatement(RuleStored t, Connection con) throws SQLException {
        return null;
    }

    @Override
    protected PreparedStatement getInsertStatement(RuleStored t, Connection con) throws SQLException {
        return null;
    }
}

