/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.dao;

import gr.uoa.di.validator.dao.AbstractDAO;
import gr.uoa.di.validator.dao.RuleSet;
import gr.uoa.di.validator.dao.RuleSetDAO;
import gr.uoa.di.validator.dao.Utilities;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RuleSetDAOimpl
extends AbstractDAO<RuleSet>
implements RuleSetDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleSet get(String id) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        RuleSet retSet = null;
        logger.debug((Object)"Accessing DB to get RuleSet");
        try {
            con = this.getConnection();
            String query = "SELECT name, description, content_rules, usage_rules FROM rulesets WHERE id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(id));
            rs = stmt.executeQuery();
            if (rs != null) {
                retSet = new RuleSet();
                while (rs.next()) {
                    retSet.setName(rs.getString(1));
                    retSet.setDescription(rs.getString(2));
                    retSet.setRuleIdsContent(Utilities.convertStringToList(rs.getString(3)));
                    retSet.setRuleIdsUsage(Utilities.convertStringToList(rs.getString(4)));
                    retSet.setId(Integer.parseInt(id));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Accessing DB to get RuleSet: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to get RuleSets: " + e));
                }
            }
        }
        return retSet;
    }

    @Override
    public String getRuleSetName(String id) {
        return this.get(id).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RuleSet> getRuleSetIdNames() {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        ArrayList<RuleSet> retList = new ArrayList<RuleSet>();
        RuleSet retSet = null;
        logger.debug((Object)"Accessing DB to get all RuleSets");
        try {
            con = this.getConnection();
            String query = "SELECT name, description, content_rules, usage_rules, id FROM rulesets";
            stmt = con.prepareStatement(query);
            rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    retSet = new RuleSet();
                    retSet.setName(rs.getString(1));
                    retSet.setDescription(rs.getString(2));
                    retSet.setRuleIdsContent(Utilities.convertStringToList(rs.getString(3)));
                    retSet.setRuleIdsUsage(Utilities.convertStringToList(rs.getString(4)));
                    retSet.setId(rs.getInt(5));
                    retList.add(retSet);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Accessing DB to get all RuleSets: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Accessing DB to get all RuleSets: " + e));
                }
            }
        }
        return retList;
    }

    @Override
    public List<String> getRuleSetRuleIdsByJobType(String id, String jobType) {
        RuleSet tempSet = this.get(id);
        if (jobType.equals("usage")) {
            return tempSet.getRuleIdsUsage();
        }
        return tempSet.getRuleIdsContent();
    }

    @Override
    protected PreparedStatement getUpdateStatement(RuleSet t, Connection con) throws SQLException {
        String query = "UPDATE rulesets SET name=?, description=?, content_rules=?,usage_rules=? WHERE id=?";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setString(1, t.getName());
        stmt.setString(2, t.getDescription());
        stmt.setString(3, Utilities.convertListToString(t.getRuleIdsContent()));
        stmt.setString(4, Utilities.convertListToString(t.getRuleIdsUsage()));
        stmt.setInt(5, t.getId());
        return stmt;
    }

    @Override
    protected PreparedStatement getInsertStatement(RuleSet t, Connection con) throws SQLException {
        String query = "INSERT INTO rulesets(name,description,content_rules,usage_rules) VALUES(?,?,?,?)";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setString(1, t.getName());
        stmt.setString(2, t.getDescription());
        stmt.setString(3, Utilities.convertListToString(t.getRuleIdsContent()));
        stmt.setString(4, Utilities.convertListToString(t.getRuleIdsUsage()));
        return stmt;
    }

    @Override
    protected PreparedStatement getDeleteStatement(String id, Connection con) throws SQLException {
        String query = "DELETE FROM rulesets WHERE id=?";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setInt(1, Integer.parseInt(id));
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLastId() throws SQLException {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        int retId = -1;
        logger.debug((Object)"Accessing DB to get RuleSet's next available id");
        try {
            con = this.getConnection();
            String query = "SELECT currval(pg_get_serial_sequence(?,?)) FROM rulesets";
            stmt = con.prepareStatement(query);
            stmt.setString(1, "rulesets");
            stmt.setString(2, "id");
            rs = stmt.executeQuery();
            if (rs != null) {
                rs.next();
                retId = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to get RuleSet's next available id: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to get RuleSet's next available id: " + e));
                }
            }
        }
        return retId;
    }
}

