/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.dao;

import gr.uoa.di.validator.dao.AbstractDAO;
import gr.uoa.di.validator.dao.Entry;
import gr.uoa.di.validator.dao.JobForRegistration;
import gr.uoa.di.validator.dao.JobSubmitted;
import gr.uoa.di.validator.dao.JobSubmittedDAO;
import gr.uoa.di.validator.dao.Utilities;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class JobSubmittedDAOImpl
extends AbstractDAO<JobSubmitted>
implements JobSubmittedDAO {
    @Override
    protected PreparedStatement getUpdateStatement(JobSubmitted t, Connection con) throws SQLException {
        logger.debug((Object)"getting submittedjob updateStatement");
        String query = "UPDATE jobs SET type=?,started=?, ruleset=?, status=?, repo=?, duration=? WHERE id=?";
        PreparedStatement stmt = con.prepareStatement(query);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        stmt.setString(1, t.getType());
        stmt.setString(2, sdf.format(cal.getTime()));
        stmt.setString(3, t.getRuleset());
        stmt.setString(4, t.getStatus());
        stmt.setString(5, t.getRepo());
        stmt.setString(6, t.getDuration());
        stmt.setInt(7, Integer.parseInt(t.getId()));
        return stmt;
    }

    @Override
    protected PreparedStatement getInsertStatement(JobSubmitted t, Connection con) throws SQLException {
        logger.debug((Object)"getting submittedjob insertStatement");
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String query = "INSERT INTO jobs(type,started,ruleset,\"user\",status, repo, duration, rules, records, set, groupby_xpath, metadata_prefix, activation_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setString(1, t.getType());
        stmt.setString(2, sdf.format(cal.getTime()));
        stmt.setString(3, t.getRuleset());
        stmt.setString(4, t.getUser());
        stmt.setString(5, t.getStatus());
        stmt.setString(6, t.getRepo());
        stmt.setString(7, t.getDuration());
        stmt.setString(8, Utilities.convertSetToString(t.getRules()));
        stmt.setString(9, t.getRecords());
        stmt.setString(10, t.getSet());
        stmt.setString(11, t.getGroupBy_xpath());
        stmt.setString(12, t.getMetadata_prefix());
        stmt.setString(13, t.getActivation_id());
        return stmt;
    }

    @Override
    protected PreparedStatement getDeleteStatement(String id, Connection con) throws SQLException {
        String query = "DELETE FROM jobs  WHERE id=?";
        PreparedStatement stmt = con.prepareStatement(query);
        stmt.setInt(1, Integer.parseInt(id));
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobSubmitted get(String id) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        JobSubmitted retJob = null;
        logger.debug((Object)"Accessing DB to get Submitted Job");
        try {
            con = this.getConnection();
            String query = "SELECT type, status, started, ended, score, \"user\", repo, duration, ruleset, error_information, groupby_xpath, set, records, metadata_prefix, activation_id FROM jobs WHERE id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(id));
            rs = stmt.executeQuery();
            if (rs != null) {
                retJob = new JobSubmitted();
                while (rs.next()) {
                    retJob.setType(rs.getString(1));
                    retJob.setStatus(rs.getString(2));
                    retJob.setStarted(rs.getString(3));
                    retJob.setEnded(rs.getString(4));
                    retJob.setScore(Integer.toString(rs.getInt(5)));
                    retJob.setUser(rs.getString(6));
                    retJob.setRepo(rs.getString(7));
                    retJob.setDuration(rs.getString(8));
                    retJob.setRuleset(rs.getString(9));
                    retJob.setError(rs.getString(10));
                    retJob.setGroupBy_xpath(rs.getString(11));
                    retJob.setSet(rs.getString(12));
                    retJob.setRecords(rs.getString(13));
                    retJob.setMetadata_prefix(rs.getString(14));
                    retJob.setActivation_id(rs.getString(15));
                    retJob.setId(id);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to get Submitted Job: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to get Submitted Job: " + e));
                }
            }
        }
        return retJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobSubmitted> getJobs() {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        JobSubmitted retJob = null;
        ArrayList<JobSubmitted> retList = null;
        logger.debug((Object)"Accessing DB to get all Submitted Jobs");
        try {
            con = this.getConnection();
            String query = "SELECT type, status, started, ended, score, \"user\", repo, duration, ruleset, id, error_information FROM jobs ORDER BY started DESC";
            stmt = con.prepareStatement(query);
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<JobSubmitted>();
                while (rs.next()) {
                    retJob = new JobSubmitted();
                    retJob.setType(rs.getString(1));
                    retJob.setStatus(rs.getString(2));
                    retJob.setStarted(rs.getString(3));
                    retJob.setEnded(rs.getString(4));
                    retJob.setScore(rs.getString(5));
                    retJob.setUser(rs.getString(6));
                    retJob.setRepo(rs.getString(7));
                    retJob.setDuration(rs.getString(8));
                    retJob.setRuleset(rs.getString(9));
                    retJob.setId(Integer.toString(rs.getInt(10)));
                    retJob.setError(rs.getString(11));
                    retList.add(retJob);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to get all Submitted Jobs: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to get all Submitted Jobs: " + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobSubmitted> getJobsOfUser(String userName) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        JobSubmitted retJob = null;
        ArrayList<JobSubmitted> retList = null;
        logger.debug((Object)("Accessing DB to get Submitted Jobs of user: " + userName));
        try {
            con = this.getConnection();
            String query = "SELECT type, status, started, ended, score, repo, duration, ruleset, id, error_information FROM jobs WHERE \"user\"=? ORDER BY started DESC";
            stmt = con.prepareStatement(query);
            stmt.setString(1, userName);
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<JobSubmitted>();
                while (rs.next()) {
                    retJob = new JobSubmitted();
                    retJob.setType(rs.getString(1));
                    retJob.setStatus(rs.getString(2));
                    retJob.setStarted(rs.getString(3));
                    retJob.setEnded(rs.getString(4));
                    retJob.setScore(rs.getString(5));
                    retJob.setRepo(rs.getString(6));
                    retJob.setDuration(rs.getString(7));
                    retJob.setRuleset(rs.getString(8));
                    retJob.setId(rs.getString(9));
                    retJob.setError(rs.getString(10));
                    retJob.setUser(userName);
                    retList.add(retJob);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to get Submitted Jobs of user: " + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date setJobFinished(String jobId, String error, Boolean failed) {
        Date date_ended = null;
        Connection con = null;
        Statement stmt = null;
        Statement stmt1 = null;
        Statement stmt2 = null;
        JobSubmitted job = this.get(jobId);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logger.debug((Object)("Accessing DB to set Submitted Job: " + jobId + " as finished"));
        try {
            Date ended;
            if (failed.booleanValue()) {
                error = "Server responded with error while issuing the request to retrieve the records.";
            }
            con = this.getConnection();
            String query = "UPDATE jobs SET status=?, ended=?, duration=?, error_information=? WHERE id=?";
            stmt = con.prepareStatement(query);
            String endedStr = sdf.format(cal.getTime());
            Date started = sdf.parse(job.getStarted());
            date_ended = ended = sdf.parse(endedStr);
            long diff = ended.getTime() - started.getTime();
            Calendar cDiff = Calendar.getInstance();
            cDiff.setTimeInMillis(diff);
            long mills = cDiff.getTimeInMillis();
            stmt.setString(1, "finished");
            stmt.setString(2, endedStr);
            stmt.setString(3, Utilities.formatTime(mills));
            if (error != null) {
                stmt.setString(4, error);
                logger.debug((Object)("error: " + error));
            } else {
                stmt.setString(4, "no errors");
            }
            stmt.setInt(5, Integer.parseInt(jobId));
            int res = stmt.executeUpdate();
            stmt.close();
            logger.debug((Object)("job lines updated: " + res));
            if (error == null) {
                logger.debug((Object)"Checking results per rule..");
                query = "select rule_id, count(*) as total, sum(case when success=true then 1 else 0 end) as successes, record_groupby.groupby as groupby_field from tasks join record_groupby on (tasks.record_identifier=record_groupby.record_id and tasks.job_id=record_groupby.job_id) where tasks.job_id=? group by rule_id, record_groupby.groupby";
                stmt = con.prepareStatement(query);
                stmt.setInt(1, Integer.parseInt(jobId));
                ResultSet rs = stmt.executeQuery();
                String query1 = "select rule_id, count(*) as total, sum(case when success=true then 1 else 0 end) as successes from tasks where tasks.job_id=? group by rule_id ";
                stmt1 = con.prepareStatement(query1);
                stmt1.setInt(1, Integer.parseInt(jobId));
                ResultSet rs1 = stmt1.executeQuery();
                String groupBy = null;
                if (rs != null || rs1 != null) {
                    logger.debug((Object)"Inserting job results..");
                    query = "INSERT INTO job_results(rule_id,job_id,total,successes,groupby) VALUES(?,?,?,?,?)";
                    stmt2 = con.prepareStatement(query);
                    while (rs.next()) {
                        stmt2.setInt(1, rs.getInt(1));
                        stmt2.setInt(2, Integer.parseInt(jobId));
                        stmt2.setInt(3, rs.getInt(2));
                        stmt2.setInt(4, rs.getInt(3));
                        stmt2.setString(5, rs.getString(4));
                        groupBy = rs.getString(4);
                        stmt2.addBatch();
                    }
                    if (!groupBy.equalsIgnoreCase("all")) {
                        while (rs1.next()) {
                            logger.debug((Object)("Inserting rule_id: " + rs1.getInt(1) + ",job_id: " + Integer.parseInt(jobId) + ",total: " + rs1.getInt(2) + ",successes: " + rs1.getInt(3) + ",groupby: " + "all"));
                            stmt2.setInt(1, rs1.getInt(1));
                            stmt2.setInt(2, Integer.parseInt(jobId));
                            stmt2.setInt(3, rs1.getInt(2));
                            stmt2.setInt(4, rs1.getInt(3));
                            stmt2.setString(5, "all");
                            stmt2.addBatch();
                        }
                    }
                    int result = stmt2.executeBatch().length;
                    logger.debug((Object)("job results inserted: " + result));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to : " + e));
        }
        catch (ParseException e) {
            logger.error((Object)("Error while parsing Date : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to set Submitted Job as finished: " + e));
                }
            }
            if (stmt1 != null) {
                try {
                    stmt1.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to set Submitted Job as finished: " + e));
                }
            }
            if (stmt2 != null) {
                try {
                    stmt2.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to set Submitted Job as finished: " + e));
                }
            }
        }
        return date_ended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getJobError(String jobId) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to see if a Submitted Job has an error: ");
        try {
            con = this.getConnection();
            String query = "SELECT error_information FROM jobs WHERE id=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(jobId));
            rs = stmt.executeQuery();
            rs.next();
            if (rs.getString(1) != null && rs.getString(1).equals("no errors")) {
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to see if a Submitted Job has an error: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to see if a Submitted Job has an error: " + e));
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLastId() throws SQLException {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        int retId = -1;
        logger.debug((Object)"Accessing DB to get Submitted Job's next available id");
        try {
            con = this.getConnection();
            String query = "SELECT currval(pg_get_serial_sequence(?,?)) FROM jobs";
            stmt = con.prepareStatement(query);
            stmt.setString(1, "jobs");
            stmt.setString(2, "id");
            rs = stmt.executeQuery();
            if (rs != null) {
                rs.next();
                retId = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to get Submitted Job's next available id: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to get Submitted Job's next available id: " + e));
                }
            }
        }
        return retId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOld(String date) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete olds Job and their tasks");
        try {
            con = this.getConnection();
            logger.debug((Object)"Deleting tasks..");
            String query = "DELETE FROM tasks WHERE job_id IN (SELECT id FROM jobs WHERE started<=?)";
            stmt = con.prepareStatement(query);
            stmt.setString(1, date);
            stmt.executeUpdate();
            stmt.close();
            logger.debug((Object)"Deleting jobs..");
            query = "DELETE FROM jobs WHERE started<=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, date);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to delete olds Job and their tasks: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while Accessing DB to delete olds Job and their tasks: " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOldCustomOnly(String date) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete olds Job and their tasks");
        try {
            con = this.getConnection();
            logger.debug((Object)"Deleting tasks..");
            String query = "DELETE FROM tasks WHERE job_id IN (SELECT id FROM jobs WHERE started<=? AND ruleset = ?)";
            stmt = con.prepareStatement(query);
            stmt.setString(1, date);
            stmt.setString(2, "Custom");
            stmt.executeUpdate();
            stmt.close();
            logger.debug((Object)"Deleting jobs..");
            query = "DELETE FROM jobs WHERE started<=? AND ruleset = ?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, date);
            stmt.setString(2, "Custom");
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to delete olds Job and their tasks: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while Accessing DB to delete olds Job and their tasks: " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setScore(String jobId, String error, String groupBy) {
        Connection con = null;
        Statement stmt = null;
        Statement stmt1 = null;
        ResultSet rs = null;
        double score = 0.0;
        int calcScore = 0;
        logger.debug((Object)"Accessing DB to set Submitted Job score");
        try {
            con = this.getConnection();
            String query = null;
            logger.debug((Object)"Updating main score..");
            if (error == null) {
                query = "SELECT sum(weight::float * success/total)/sum(weight) from (select mandatory, count(*) as total, sum(case when success=true then 1 else 0 end) as success, rules.weight as weight from rules join tasks on tasks.rule_id=rules.id where tasks.job_id=? and mandatory='true' group by rules.id ) as ss";
                stmt = con.prepareStatement(query);
                stmt.setInt(1, Integer.parseInt(jobId));
                rs = stmt.executeQuery();
                logger.debug((Object)"executed query for score calculation..");
                if (rs.next()) {
                    String sum = rs.getString(1);
                    if (sum == null) {
                        logger.debug((Object)"score not calculated..");
                        calcScore = 0;
                    } else {
                        score = Double.parseDouble(sum);
                        calcScore = (int)Math.ceil(score * 100.0);
                    }
                } else {
                    logger.debug((Object)"score not calculated..");
                    calcScore = 0;
                }
                logger.debug((Object)"out of score calculation..");
                stmt.close();
                query = "UPDATE jobs SET score=? WHERE id=?";
                stmt = con.prepareStatement(query);
                stmt.setString(1, Integer.toString((int)Math.ceil(score * 100.0)));
                stmt.setInt(2, Integer.parseInt(jobId));
                if (stmt.executeUpdate() > 0) {
                    logger.debug((Object)("Job scored successfully set with value: " + Integer.toString((int)Math.ceil(score * 100.0))));
                } else {
                    logger.debug((Object)"error while setting score");
                }
                stmt.close();
                if (groupBy != null) {
                    String query1 = "SELECT SUM(weight::float * success/total)/sum(weight) , ss.groupby_field  FROM (SELECT mandatory, count(*) as total, sum(case when success=true then 1 else 0 end) as success, rules.weight as weight, record_groupby.groupby as groupby_field FROM rules JOIN (tasks JOIN record_groupby ON (tasks.record_identifier=record_groupby.record_id and tasks.job_id=record_groupby.job_id)) ON tasks.rule_id=rules.id WHERE tasks.job_id=? AND mandatory='true' group by rules.id,record_groupby.groupby ) as ss group by ss.groupby_field";
                    logger.debug((Object)"Inserting filtered scores..");
                    stmt = con.prepareStatement(query1);
                    stmt.setInt(1, Integer.parseInt(jobId));
                    rs = stmt.executeQuery();
                    if (rs != null) {
                        query = "INSERT INTO jobs_filtered_scores(job_id,groupby,score) VALUES(?,?,?)";
                        stmt1 = con.prepareStatement(query);
                        while (rs.next()) {
                            String sum = rs.getString(1);
                            score = Double.parseDouble(sum);
                            stmt1.setInt(1, Integer.parseInt(jobId));
                            stmt1.setString(2, rs.getString(2));
                            stmt1.setInt(3, (int)Math.ceil(score * 100.0));
                            stmt1.addBatch();
                        }
                        stmt1.executeBatch();
                        logger.debug((Object)"filtered scores inserted");
                    }
                }
            } else {
                query = "UPDATE jobs SET score=? WHERE id=?";
                stmt = con.prepareStatement(query);
                stmt.setString(1, "0");
                stmt.setInt(2, Integer.parseInt(jobId));
                stmt.executeUpdate();
                stmt.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to set Submitted Job score: " + e));
        }
        catch (Exception e) {
            logger.error((Object)("Error while accessing DB to set Submitted Job score: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to set Submitted Job score: " + e));
                }
            }
            if (stmt1 != null) {
                try {
                    stmt1.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to set Submitted Job score: " + e));
                }
            }
        }
        return calcScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(String jobId, String status) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to set Submitted Job status");
        try {
            con = this.getConnection();
            String query = "UPDATE jobs SET status=? WHERE id=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, status);
            stmt.setInt(2, Integer.parseInt(jobId));
            if (stmt.executeUpdate() == 0) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to set Submitted Job status: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to set Submitted Job status: " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Entry> getJobSummary(String jobId, String groupby) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        ArrayList<Entry> retList = null;
        logger.debug((Object)("Accessing DB to get all Jobs entries with jobId:" + jobId + " and groupBy:" + groupby));
        try {
            con = this.getConnection();
            String query = "select rules.name, rules.description, rules.weight, rules.mandatory, total, successes, rules.id from job_results join rules on job_results.rule_id = rules.id where (job_results.job_id=? AND job_results.groupby=?) order by rules.name";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(jobId));
            stmt.setString(2, groupby);
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<Entry>();
                while (rs.next()) {
                    Entry retEntry = new Entry();
                    retEntry = new Entry();
                    retEntry.setName(rs.getString(1));
                    retEntry.setDescription(rs.getString(2));
                    retEntry.setWeight(rs.getInt(3));
                    retEntry.setMandatory(rs.getBoolean(4));
                    retEntry.setRuleId(rs.getInt(7));
                    int total = rs.getInt(5);
                    int successes = rs.getInt(6);
                    if (rs.getInt(5) > 0) {
                        retEntry.setSuccesses(successes + "/" + total);
                    } else {
                        retEntry.setSuccesses("--");
                    }
                    if (successes < total) {
                        retEntry.setHasErrors(true);
                    } else {
                        retEntry.setHasErrors(false);
                    }
                    retList.add(retEntry);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to get all Jobs entries: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while Accessing DB to get all Jobs entries: " + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobSubmitted> getUncompletedJobs() {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        JobSubmitted retJob = null;
        ArrayList<JobSubmitted> retList = null;
        logger.debug((Object)"Accessing DB to get uncompleted jobs");
        try {
            con = this.getConnection();
            String query = "SELECT type, status, started, ended, score, repo, duration, ruleset, id, error_information, \"user\", rules, records, set, metadata_prefix, activation_id  FROM jobs WHERE status<>?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, "finished");
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<JobSubmitted>();
                while (rs.next()) {
                    retJob = new JobSubmitted();
                    retJob.setType(rs.getString(1));
                    retJob.setStatus(rs.getString(2));
                    retJob.setStarted(rs.getString(3));
                    retJob.setEnded(rs.getString(4));
                    retJob.setScore(rs.getString(5));
                    retJob.setRepo(rs.getString(6));
                    retJob.setDuration(rs.getString(7));
                    retJob.setRuleset(rs.getString(8));
                    retJob.setId(rs.getString(9));
                    retJob.setError(rs.getString(10));
                    retJob.setUser(rs.getString(11));
                    retJob.setRules(Utilities.convertStringToSet(rs.getString(12)));
                    retJob.setRecords(rs.getString(13));
                    retJob.setSet(rs.getString(14));
                    retJob.setMetadata_prefix(rs.getString(15));
                    retJob.setActivation_id(rs.getString(16));
                    retList.add(retJob);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB get uncompleted jobs : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to get uncompleted jobs: " + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUncompletedJobs() {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete uncompleted Jobs and their tasks");
        try {
            con = this.getConnection();
            logger.debug((Object)"Deleting jobs..");
            String query = "DELETE FROM jobs WHERE status<>?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, "finished");
            stmt.executeUpdate();
            logger.debug((Object)"Finish Deleting jobs..");
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to delete uncompleted Jobs and their tasks: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while Accessing DB to delete uncompleted Jobs and their tasks: " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSemiCompletedRegistrationJobs(String activationId) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete uncompleted Jobs and their tasks");
        try {
            con = this.getConnection();
            logger.debug((Object)"Deleting Semi Completed Registration Jobs..");
            String query = "DELETE FROM jobs WHERE activation_id=?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, activationId);
            stmt.executeUpdate();
            logger.debug((Object)"Finish Deleting jobs..");
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to delete uncompleted Jobs and their tasks: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while Accessing DB to delete uncompleted Jobs and their tasks: " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDistinctGroupByValues(String jobId) {
        ArrayList<String> retList = null;
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)("Accessing DB to get distinct groupBy values for job: " + jobId));
        try {
            con = this.getConnection();
            String query = "SELECT DISTINCT groupby from job_results WHERE job_id=? ORDER BY groupby";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(jobId));
            rs = stmt.executeQuery();
            if (rs != null) {
                retList = new ArrayList<String>();
                while (rs.next()) {
                    retList.add(rs.getString(1));
                }
            }
            logger.debug((Object)"Finish getting distinct groupBy values for job..");
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to get distinct groupBy values for job: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while Accessing DB to get distinct groupBy values for job: " + e));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFilteredScore(String jobId, String groupBy) {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        String score = null;
        logger.debug((Object)("Accessing DB to get filtered score for jobId:" + jobId + " and groupBy:" + groupBy));
        try {
            con = this.getConnection();
            String query = "SELECT score FROM jobs_filtered_scores WHERE job_id=? AND groupby=?";
            stmt = con.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(jobId));
            stmt.setString(2, groupBy);
            rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    score = Integer.toString(rs.getInt(1));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to get filtered score : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while Accessing DB to get filtered score : " + e));
                }
            }
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJobForRegistration(String baseUrl, String officialName, String activationId, String user, String admin_emails, String validationSet, String datasourceId) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to store job values for Registration");
        try {
            con = this.getConnection();
            String query = "INSERT INTO jobs_for_registration (activation_id,official_name,baseurl,\"user\",admin_emails,validation_set,datasource_id) VALUES (?,?,?,?,?,?,?)";
            stmt = con.prepareStatement(query);
            stmt.setString(1, activationId);
            stmt.setString(2, officialName);
            stmt.setString(3, baseUrl);
            stmt.setString(4, user);
            stmt.setString(5, admin_emails);
            stmt.setString(6, validationSet);
            stmt.setString(7, datasourceId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to store job values for Registration : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error Accessing DB to store job values for Registration : " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJobForRegistration(String baseUrl, String officialName, String activationId, String user, String admin_emails, String validationSet, String desiredCompatibility, String datasourceId, String interfaceId) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to store job values for Registration");
        try {
            con = this.getConnection();
            String query = "INSERT INTO jobs_for_registration (activation_id,official_name,baseurl,\"user\",admin_emails,validation_set,datasource_id,interface_id,desired_compatiblity_level) VALUES (?,?,?,?,?,?,?,?,?)";
            stmt = con.prepareStatement(query);
            stmt.setString(1, activationId);
            stmt.setString(2, officialName);
            stmt.setString(3, baseUrl);
            stmt.setString(4, user);
            stmt.setString(5, admin_emails);
            stmt.setString(6, validationSet);
            stmt.setString(7, datasourceId);
            stmt.setString(8, interfaceId);
            stmt.setString(9, desiredCompatibility);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to store job values for Registration : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error Accessing DB to store job values for Registration : " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getJobForRegistration(String activationId) {
        ArrayList<String> results = null;
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to get job values for Registration");
        try {
            con = this.getConnection();
            String query = "SELECT * FROM jobs_for_registration WHERE activation_id = ?";
            stmt = con.prepareStatement(query);
            stmt.setString(1, activationId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                results = new ArrayList<String>();
                results.add(activationId);
                results.add(rs.getString("official_name"));
                results.add(rs.getString("baseurl"));
                results.add(rs.getString("user"));
                results.add(rs.getString("admin_emails"));
                results.add(rs.getString("validation_set"));
                results.add(rs.getString("datasource_id"));
                results.add(rs.getString("interface_id"));
                results.add(rs.getString("desired_compatiblity_level"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to get job values for Registration : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error Accessing DB to get job values for Registration : " + e));
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteJobForRegistration(String activationId) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete job values for Registration");
        try {
            con = this.getConnection();
            String query = "DELETE FROM jobs_for_registration WHERE activation_id = ? ";
            stmt = con.prepareStatement(query);
            stmt.setString(1, activationId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to delete job values for Registration : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error Accessing DB to delete job values for Registration : " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteJobsForRegistration() {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete jobs for Registration");
        try {
            con = this.getConnection();
            String query = "DELETE FROM jobs_for_registration";
            stmt = con.prepareStatement(query);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to delete jobs for Registration : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error Accessing DB to delete jobs for Registration : " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobForRegistration> getJobsForRegistration() {
        ArrayList<JobForRegistration> retList = new ArrayList<JobForRegistration>();
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to get jobs for Registration");
        try {
            con = this.getConnection();
            String query = "SELECT * FROM jobs_for_registration";
            stmt = con.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                JobForRegistration job = new JobForRegistration();
                job.setAdmin_emails(rs.getString("admin_emails"));
                job.setBaseurl(rs.getString("baseurl"));
                job.setDatasource_id(rs.getString("datasource_id"));
                job.setInterface_id(rs.getString("interface_id"));
                job.setOfficial_name("official_name");
                job.setUser(rs.getString("user"));
                job.setValidation_set(rs.getString("validation_set"));
                job.setDesired_compatiblity_level(rs.getString("desired_compatiblity_level"));
                job.setActivation_id(rs.getString("activation_id"));
                retList.add(job);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while Accessing DB to get jobs for Registration : " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error Accessing DB to get jobs for Registration : " + e));
                }
            }
        }
        return retList;
    }
}

