/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.validator.dao;

import gr.uoa.di.validator.dao.DAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.datasource.DataSourceUtils;

public abstract class AbstractDAO<T>
implements DAO<T> {
    protected DataSource datasource = null;
    protected static Logger logger = Logger.getLogger(AbstractDAO.class);

    protected abstract PreparedStatement getUpdateStatement(T var1, Connection var2) throws SQLException;

    protected abstract PreparedStatement getInsertStatement(T var1, Connection var2) throws SQLException;

    protected abstract PreparedStatement getDeleteStatement(String var1, Connection var2) throws SQLException;

    protected abstract int getLastId() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer save(T t) {
        Connection con = null;
        Statement stmt = null;
        Integer retId = -1;
        logger.debug((Object)"Accessing DB to save/update ");
        try {
            con = this.getConnection();
            stmt = this.getUpdateStatement(t, con);
            if (stmt.executeUpdate() == 0) {
                stmt.close();
                stmt = this.getInsertStatement(t, con);
                stmt.executeUpdate();
                retId = this.getLastId();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to save/update: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to save/update: " + e));
                }
            }
        }
        return retId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String delete(String id) {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete ");
        try {
            con = this.getConnection();
            stmt = this.getDeleteStatement(id, con);
            if (stmt.executeUpdate() == 0) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error while accessing DB to delete: " + e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error while accessing DB to delete: " + e));
                }
            }
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = DataSourceUtils.getConnection((DataSource)this.datasource);
        return conn;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }
}

