/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils.hibernate;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;

public class HibernateUtil {
    private String host;
    private String catalog;
    private String username;
    private String password;
    private SessionFactory sessionFactory;
    private Logger logger = Logger.getLogger(this.getClass());

    public HibernateUtil() {
    }

    public HibernateUtil(String host, String catalog, String username, String password) {
        this.host = host;
        this.catalog = catalog;
        this.username = username;
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Session getSession() {
        if (this.sessionFactory == null || this.sessionFactory.isClosed()) {
            this.configure();
        }
        return this.sessionFactory.getCurrentSession();
    }

    private void configure() {
        AnnotationConfiguration configuration = new AnnotationConfiguration().configure();
        String url = "jdbc:mysql://" + this.host + "/" + this.catalog + "?characterEncoding=UTF-8";
        configuration.setProperty("hibernate.connection.url", url);
        configuration.setProperty("hibernate.connection.username", this.username);
        configuration.setProperty("hibernate.connection.password", this.password);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting to url " + url + ", username: " + this.username + ", password: " + this.password));
        }
        this.sessionFactory = configuration.buildSessionFactory();
    }

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory == null || this.sessionFactory.isClosed()) {
            this.configure();
        }
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

