/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils.cql;

import eu.dnetlib.utils.cql.CqlBoolean;
import eu.dnetlib.utils.cql.CqlClause;
import eu.dnetlib.utils.cql.CqlRelation;
import eu.dnetlib.utils.cql.CqlTerm;
import java.util.ArrayList;
import java.util.List;

public class CqlQuery {
    CqlClause root = null;

    CqlQuery() {
        this(null);
    }

    CqlQuery(CqlClause root) {
        this.root = root;
    }

    public CqlClause getRoot() {
        return this.root;
    }

    public void setRoot(CqlClause root) {
        this.root = root;
    }

    public String toString() {
        return this.root == null ? "null" : this.root.toCqlString();
    }

    public boolean contains(CqlQuery query) {
        return this.contains(this.root, query.getRoot());
    }

    private boolean contains(CqlClause big, CqlClause small) {
        if (big.type == CqlClause.CqlClauseType.BOOLEAN && small.type == CqlClause.CqlClauseType.BOOLEAN) {
            return this.containsBooleans((CqlBoolean)big, (CqlBoolean)small);
        }
        if (big.type == CqlClause.CqlClauseType.BOOLEAN) {
            return this.containsBooleanTerm((CqlBoolean)big, small);
        }
        if (small.type == CqlClause.CqlClauseType.BOOLEAN) {
            return this.containsTermBoolean(big, (CqlBoolean)small);
        }
        if (big.type == CqlClause.CqlClauseType.RELATION && small.type == CqlClause.CqlClauseType.RELATION) {
            CqlRelation bigRelation = (CqlRelation)big;
            CqlRelation smallRelation = (CqlRelation)small;
            return bigRelation.index.equals(smallRelation.index) && bigRelation.operator.equals(smallRelation.operator) && bigRelation.value.equals(smallRelation.value);
        }
        if (big.type == CqlClause.CqlClauseType.TERM && small.type == CqlClause.CqlClauseType.TERM) {
            return ((CqlTerm)big).term.equals(((CqlTerm)small).term);
        }
        return false;
    }

    private boolean containsBooleans(CqlBoolean a, CqlBoolean b) {
        if (a.getOperator().equalsIgnoreCase(b.getOperator())) {
            ArrayList<CqlClause> aList = this.unfold(a);
            ArrayList<CqlClause> bList = this.unfold(b);
            if (a.operator.equalsIgnoreCase("and")) {
                return this.subset(aList, bList);
            }
            if (a.operator.equalsIgnoreCase("or")) {
                return this.superset(bList, aList);
            }
            throw new IllegalArgumentException("Unsupported operator: " + a.operator);
        }
        return this.contains(a, b.getLeft()) && this.contains(a, b.getRight());
    }

    public ArrayList<CqlClause> unfold(CqlBoolean bool) {
        String op = bool.operator;
        ArrayList<CqlClause> siblings = new ArrayList<CqlClause>();
        if (bool.left.type == CqlClause.CqlClauseType.BOOLEAN && ((CqlBoolean)bool.left).operator.equalsIgnoreCase(op)) {
            siblings.addAll(this.unfold((CqlBoolean)bool.left));
        } else {
            siblings.add(bool.left);
        }
        if (bool.right.type == CqlClause.CqlClauseType.BOOLEAN && ((CqlBoolean)bool.right).operator.equalsIgnoreCase(op)) {
            siblings.addAll(this.unfold((CqlBoolean)bool.right));
        } else {
            siblings.add(bool.right);
        }
        return siblings;
    }

    private boolean superset(List<CqlClause> superset, List<CqlClause> subset) {
        if (subset.size() > superset.size()) {
            return false;
        }
        for (CqlClause sub : subset) {
            boolean found = false;
            for (CqlClause sup : superset) {
                if (!this.contains(sup, sub)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean subset(List<CqlClause> subset, List<CqlClause> superset) {
        if (subset.size() > superset.size()) {
            return false;
        }
        for (CqlClause sub : subset) {
            boolean found = false;
            for (CqlClause sup : superset) {
                if (!this.contains(sub, sup)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean containsBooleanTerm(CqlBoolean bool, CqlClause clause) {
        if (bool.getOperator().equalsIgnoreCase("and")) {
            return false;
        }
        return this.contains(bool.getLeft(), clause) || this.contains(bool.getRight(), clause);
    }

    private boolean containsTermBoolean(CqlClause clause, CqlBoolean bool) {
        if (bool.getOperator().equalsIgnoreCase("or")) {
            return false;
        }
        return this.contains(clause, bool.getLeft()) || this.contains(clause, bool.getRight());
    }
}

