<?xml version="1.0" encoding="UTF-8"?>

<!--  eternal gratitude to stefania -->

<xsl:stylesheet version="2.0"
	
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 

	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
	xmlns:skos="http://www.w3.org/2004/02/skos/core#" 
	xmlns:espas="http://ontology.espas-fp7.eu/espasdefinitions#" 
	xmlns:dc="http://purl.org/dc/elements/1.1/" 
	xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" 
	xmlns:owlxml="http://www.w3.org/2006/12/owl2-xml#">

	<xsl:template match="/*">

		<xsl:choose>
			<xsl:when test="count(./*) = 0">
				<ROWS/>
			</xsl:when>
			<xsl:otherwise>
				<ROWS>
				<xsl:variable name="ontologyType" select="normalize-space(//skos:ConceptScheme/@rdf:about)"/>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/computationType'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="computationTypeId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="computationTypeName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="computationTypeShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="computationTypeDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="computationTypeParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />

							<ROW table="computationType">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$computationTypeId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$computationTypeId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$computationTypeName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$computationTypeShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$computationTypeDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$computationTypeParent" /></FIELD>
							</ROW>
					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/crs'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="crsId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="crsName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="crsShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="crsDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="crs">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$crsId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$crsId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$crsName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$crsShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$crsDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/verticalCrs'">

					<xsl:for-each select="//skos:member">
						<xsl:variable name="crsId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="crsName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="crsShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="crsDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="verticalcrs">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$crsId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$crsId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$crsName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$crsShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$crsDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/dimensionalityInstance'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="dimensionalityInstanceId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="dimensionalityInstanceName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="dimensionalityInstanceShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="dimensionalityInstanceDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="dimensionalityInstanceParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />

							<ROW table="dimensionality_instance">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$dimensionalityInstanceId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$dimensionalityInstanceId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$dimensionalityInstanceName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$dimensionalityInstanceShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$dimensionalityInstanceDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$dimensionalityInstanceParent" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>
		
				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/dimensionalityTimeline'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="dimensionalityTimelineId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="dimensionalityTimelineName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="dimensionalityTimelineShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="dimensionalityTimelineDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="dimensionalityTimelineParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />
	
							<ROW table="dimensionality_timeline">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$dimensionalityTimelineId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$dimensionalityTimelineId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$dimensionalityTimelineName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$dimensionalityTimelineShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$dimensionalityTimelineDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$dimensionalityTimelineParent" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/featureOfInterest'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="featureOfInterestId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="featureOfInterestName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="featureOfInterestShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="featureOfInterestDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="featureOfInterestParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />
	
							<ROW table="regionOfSpace">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$featureOfInterestId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$featureOfInterestId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$featureOfInterestName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$featureOfInterestShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$featureOfInterestDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$featureOfInterestParent" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/platformType'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="platformTypeId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="platformTypeName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="platformTypeShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="platformTypeDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="platformType">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$platformTypeId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$platformTypeId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$platformTypeName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$platformTypeShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$platformTypeDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/relatedObservationRole'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="relatedObservationRoleId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="relatedObservationRoleName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="relatedObservationRoleShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="relatedObservationRoleDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="relatedObservationRole">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$relatedObservationRoleId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$relatedObservationRoleId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$relatedObservationRoleName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$relatedObservationRoleShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$relatedObservationRoleDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/relatedPartyRole'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="relatedPartyRoleId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="relatedPartyRoleName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="relatedPartyRoleShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="relatedPartyRoleDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="relatedPartyRole">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$relatedPartyRoleId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$relatedPartyRoleId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$relatedPartyRoleName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$relatedPartyRoleShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$relatedPartyRoleDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/resultAccumulation'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="resultAccumulationId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="resultAccumulationName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="resultAccumulationShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="resultAccumulationDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="resultAccumulation">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$resultAccumulationId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$resultAccumulationId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$resultAccumulationName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$resultAccumulationShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$resultAccumulationDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/resultDataFormat'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="resultDataFormatId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="resultDataFormatName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="resultDataFormatShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="resultDataFormatDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="resultDataFormat">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$resultDataFormatId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$resultDataFormatId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$resultDataFormatName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$resultDataFormatShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$resultDataFormatDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/status'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="statusId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="statusName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="statusShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="statusDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="status">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$statusId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$statusId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$statusName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$statusShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$statusDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/unit'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="unitId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="unitName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="unitShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="unitDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="unit">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$unitId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$unitId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$unitName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$unitShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$unitDescription" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/qualifier'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="qualifierId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="qualifierName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="qualifierShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="qualifierDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="qualifierParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />

							<ROW table="qualifier">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$qualifierId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$qualifierId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$qualifierName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$qualifierShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$qualifierDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$qualifierParent" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/measurand'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="measurandId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="measurandName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="measurandShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="measurandDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="measurandParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />

							<ROW table="measurand">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$measurandId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$measurandId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$measurandName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$measurandShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$measurandDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$measurandParent" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/phenomenon'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="phenomenonId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="phenomenonName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="phenomenonShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="phenomenonDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="phenomenonParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />

							<ROW table="phenomenon">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$phenomenonId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$phenomenonId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$phenomenonName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$phenomenonShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$phenomenonDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$phenomenonParent" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>
			
				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/instrumentType'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="instrumentTypeId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="instrumentTypeName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="instrumentTypeShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="instrumentTypeDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="instrumentTypeParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />

							<ROW table="instrumenttype">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$instrumentTypeId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$instrumentTypeId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$instrumentTypeName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$instrumentTypeShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$instrumentTypeDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$instrumentTypeParent" /></FIELD>
							</ROW>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/serviceFunction'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="serviceTypeId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="serviceTypeName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="serviceTypeShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="serviceTypeDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="serviceTypeParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />

                                                <ROW table="servicefunction">
                                                        <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$serviceTypeId" /></FIELD>
                                                        <FIELD name="id"><xsl:value-of select="$serviceTypeId" /></FIELD>
                                                        <FIELD name="title"><xsl:value-of select="$serviceTypeName" /></FIELD>
                                                        <FIELD name="shortlabel"><xsl:value-of select="$serviceTypeShortName" /></FIELD>
                                                        <FIELD name="definition"><xsl:value-of select="$serviceTypeDescription" /></FIELD>
                                                        <FIELD name="parent"><xsl:value-of select="$serviceTypeParent" /></FIELD>
                                                </ROW>

					</xsl:for-each>
				</xsl:if>
                        			
				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/compositeObservedProperty'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="compositeObservedPropertyId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="compositeObservedPropertyName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="compositeObservedPropertyShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="compositeObservedPropertyDescription" select="normalize-space(./skos:Concept/skos:definition)" />

							<ROW table="observedProperty">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$compositeObservedPropertyId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$compositeObservedPropertyId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$compositeObservedPropertyName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$compositeObservedPropertyShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$compositeObservedPropertyDescription" /></FIELD>
							</ROW>

							<ROW table="compositeObservedProperty">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$compositeObservedPropertyId" /></FIELD>
								<FIELD name="property"><xsl:value-of select="$compositeObservedPropertyId" /></FIELD>
							</ROW>

							<xsl:for-each select="./skos:Concept/espas:observedProperty">
								<xsl:variable name="observedPropertyId" select="./@rdf:resource" />
								<ROW table="compositeproperty_subproperties">
									<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($compositeObservedPropertyId, '_', $observedPropertyId)" /></FIELD>
									<FIELD name="composite"><xsl:value-of select="$compositeObservedPropertyId" /></FIELD>
									<FIELD name="simpleproperty"><xsl:value-of select="$observedPropertyId" /></FIELD>
								</ROW>
							</xsl:for-each>

					</xsl:for-each>
				</xsl:if>

				<xsl:if test="$ontologyType = 'http://ontology.espas-fp7.eu/observedProperty'">
					<xsl:for-each select="//skos:member">
						<xsl:variable name="observedPropertyId" select="normalize-space(./skos:Concept/@rdf:about)" />
						<xsl:variable name="observedPropertyName" select="normalize-space(./skos:Concept/skos:prefLabel)" />
						<xsl:variable name="observedPropertyShortName" select="normalize-space(./skos:Concept/skos:altLabel)" />
						<xsl:variable name="observedPropertyDescription" select="normalize-space(./skos:Concept/skos:definition)" />
						<xsl:variable name="observedPropertyParent" select="normalize-space(./skos:Concept/skos:broader/@rdf:resource)" />
						<xsl:variable name="observedPropertyCrs" select="normalize-space(./skos:Concept/espas:crs/@rdf:resource)" />


							<ROW table="observedProperty">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$observedPropertyId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$observedPropertyId" /></FIELD>
								<FIELD name="title"><xsl:value-of select="$observedPropertyName" /></FIELD>
								<FIELD name="shortlabel"><xsl:value-of select="$observedPropertyShortName" /></FIELD>
								<FIELD name="definition"><xsl:value-of select="$observedPropertyDescription" /></FIELD>
								<FIELD name="parent"><xsl:value-of select="$observedPropertyParent" /></FIELD>
								<!-- <FIELD name="crs"><xsl:value-of select="$observedPropertyCrs" /></FIELD> -->
							</ROW>

							<ROW table="simpleobservedProperty">
								<FIELD name="property"><xsl:value-of select="$observedPropertyId" /></FIELD>
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$observedPropertyId" /></FIELD>
							</ROW>

							<xsl:for-each select="./skos:Concept/espas:phenomenon">
								<xsl:variable name="phenomenonId" select="./@rdf:resource" />
								<ROW table="observedproperty_phenomenon">
									<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($observedPropertyId, '_', $phenomenonId)" /></FIELD>
									<FIELD name="observedProperty"><xsl:value-of select="$observedPropertyId" /></FIELD>
									<FIELD name="phenomenon"><xsl:value-of select="$phenomenonId" /></FIELD>
								</ROW>
							</xsl:for-each>

							<xsl:for-each select="./skos:Concept/espas:measurand">
								<xsl:variable name="measurandId" select="./@rdf:resource" />
								<ROW table="observedproperty_measurand">
									<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($observedPropertyId, '_', $measurandId)" /></FIELD>
									<FIELD name="observedProperty"><xsl:value-of select="$observedPropertyId" /></FIELD>
									<FIELD name="measurand"><xsl:value-of select="$measurandId" /></FIELD>
								</ROW>
							</xsl:for-each>

							<xsl:for-each select="./skos:Concept/espas:qualifier">
								<xsl:variable name="qualifierId" select="./@rdf:resource" />
								<ROW table="observedproperty_qualifier">
									<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($observedPropertyId, '_', $qualifierId)" /></FIELD>
									<FIELD name="observedProperty"><xsl:value-of select="$observedPropertyId" /></FIELD>
									<FIELD name="qualifier"><xsl:value-of select="$qualifierId" /></FIELD>
								</ROW>
							</xsl:for-each>

					</xsl:for-each>
				</xsl:if>

				</ROWS>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
