SELECT
	ac.acquisitionId AS dri_objidentifier,
	to_char(timezone('zulu', to_timestamp(date_part('epoch', ac.time))),'YYYY-MM-DDThh24:MI:SSZ') AS esf_acquisitiondate,
	espas_timestamp_to_secs_without_timezone(ac.time) AS esf_acquisitiontime,
	espas_timestamp_to_secs_without_timezone(ac.time) AS esf_acquisitionlocaltime,
	to_char(timezone('zulu', to_timestamp(date_part('epoch', ac.time))),'YYYY') AS esf_acquisitionyear,
	ins.instrumentId AS esf_instrumentId,
	ins.name AS esf_instrumentName,
	it.instrumentTypeId AS esf_instrumentTypeId,
	it.value AS esf_instrumentType,
	array_agg(dp.dataProductId) AS esf_dataproductid,
	array_agg(dp.title) AS esf_dataproducttitle,
	array_agg(dp.link) AS esf_dataproductlink,
	array_agg(dpt.name) AS esf_dataproducttype,
	dats.datasetId AS esf_datasetId,
	dats.title AS esf_datasetTitle,
	dats.description AS esf_datasetDescription,
	to_char(sf.longitude, 'MI000.00000') AS esf_longitude,
	to_char(sf.latitude, 'MI000.00000') AS esf_latitude,
	to_char(sf.altitude, '00000.000') AS esf_altitude,
	to_char(timezone('zulu', to_timestamp(date_part('epoch', dats.startDate))),'YYYY-MM-DDThh24:MI:SSZ') AS esf_datasetstartdate,
	to_char(timezone('zulu', to_timestamp(date_part('epoch', dats.endDate))),'YYYY-MM-DDThh24:MI:SSZ') AS esf_datasetenddate,
	org.organizationId AS esf_organisationid,
	org.name AS esf_organisationname,
	org.acronym AS esf_organisationacronym,
	obs.observatoryId AS esf_observatoryid,
	obs.name AS esf_observatoryName,
	obs.description AS esf_observatoryDescription,
	pro.programId AS esf_programId,
	pro.name AS esf_programName,
   dc.esf_characteristicId AS esf_characteristicId,				
   dc.esf_characteristicname AS esf_characteristicname,
   espas_discard_nulls(dc.esf_regionofspace) AS esf_characteristicregionofspace,
   espas_discard_nulls(dc.esf_characteristicproperty) AS esf_characteristicproperty,
   espas_discard_nulls(dc.esf_characteristicclass) AS esf_characteristicclass
	FROM acquisition AS ac
	JOIN samplingfeature AS sf on ac.samplingfeature = sf.samplingfeatureid
	INNER JOIN instrument AS ins ON ins.instrumentId = ac.instrument
	INNER JOIN instrumentType AS it ON it.instrumentTypeId = ins.instrumentType
	LEFT JOIN dataProduct_acquisition AS dpa ON dpa.acquisition = ac.acquisitionId
	LEFT JOIN dataProduct AS dp ON dp.dataProductId = dpa.dataProduct
	INNER JOIN dataproducttype AS dpt ON dp.dataproducttype = dpt.dataproducttypeid
   INNER JOIN dataset_instrument AS di ON di.instrument = ins.instrumentId
   INNER JOIN dataset AS dats ON dats.datasetId = di.dataset
	INNER JOIN program AS pro ON pro.programId = dats.primaryProgram
	INNER JOIN organization AS org ON org.organizationId = pro.organization
	INNER JOIN observatory AS obs ON obs.observatoryId = ins.observatory
   LEFT JOIN   (
	SELECT dataset,
		array_agg(ch.characteristicId) AS esf_characteristicid,
		array_agg(ch.name) AS esf_characteristicname,
		array_agg(srv.value) AS esf_regionofspace,
		array_agg(cp.value) AS esf_characteristicproperty, 
		array_agg(cc.value) AS esf_characteristicclass
      FROM dataset_characteristic AS dc
      INNER JOIN characteristic AS ch ON ch.characteristicId = dc.characteristic
      LEFT JOIN characteristicclass AS cc ON ch.characteristicclass = cc.characteristicClassId
      LEFT JOIN characteristicproperty AS cp ON ch.characteristicProperty = cp.characteristicPropertyId
      LEFT JOIN spaceregionvalue AS srv ON ch.spaceregionvalue = srv.spaceregionvalueid
      GROUP BY dc.dataset
   ) AS dc ON dc.dataset = dats.datasetId
	GROUP BY ac.acquisitionId, ac.time, ins.instrumentId, ins.name, it.instrumentTypeId,
	         it.value, dats.datasetId, dats.title, dats.description, sf.longitude,
	         sf.latitude, sf.altitude, dats.startDate, dats.endDate, org.organizationId,
	         org.name, org.acronym, obs.observatoryId, obs.name, obs.description, pro.programId,
	         pro.name,
            dc.esf_characteristicId, dc.esf_characteristicname,
            dc.esf_regionofspace, dc.esf_characteristicproperty, dc.esf_characteristicclass
   ORDER BY ac.acquisitionId desc;
