-- delete stuff that are not associated with observations
delete from shadow.instrument si where not exists (select 1 from shadow.observation_instrument soi where soi.instrument=si.id);
delete from shadow.computation sc where not exists (select 1 from shadow.observation_computation soc where soc.computation=sc.id);
delete from shadow.observedproperty sop where not exists (select 1 from shadow.observation_observedproperty soop where soop.observedproperty=sop.id);
delete from shadow.observationcollection soc where not exists (select 1 from shadow.observation_observationcollection sooc where sooc.observationcollection=soc.id);

delete from shadow.instrumenttype sit where not exists (select 1 from shadow.instrument si where si.instrumenttypeids @> array[sit.id]::text[]);
delete from shadow.computationtype sct where not exists (select 1 from shadow.computation sc where sc.computationtypeids @> array[sct.id]::text[]);
delete from shadow.platform sp where not exists (select 1 from shadow.instrument si where si.platformids @> array[sp.id]::text[] union select 1 from shadow.computation sc where sc.platformids @> array[sp.id]::text[]);
delete from shadow.project sp where not exists (select 1 from shadow.instrument si where si.projectids @> array[sp.id]::text[] union select 1 from shadow.computation sc where sc.projectids @> array[sp.id]::text[]);

delete from shadow.phenomenon sp where not exists (select 1 from shadow.observedproperty sop where sop.phenomenonids @> array[sp.id]::text[]);
delete from shadow.measurand sm where not exists (select 1 from shadow.observedproperty sop where sop.measurandids @> array[sm.id]::text[]);
delete from shadow.qualifier sq where not exists (select 1 from shadow.observedproperty sop where sop.qualifierids @> array[sq.id]::text[]);

delete from shadow.regionofspace srs where not exists (select 1 from shadow.observationcollection soc where soc.regionofspaceids @> array[srs.id]::text[]);
delete from shadow.dimensionalityinstance sdi where not exists (select 1 from shadow.observationcollection soc where soc.dimensionalityinstanceids @> array[sdi.id]::text[]);
delete from shadow.dimensionalitytimeline sdt where not exists (select 1 from shadow.observationcollection soc where soc.dimensionalitytimelineids @> array[sdt.id]::text[]);

-- create indexes
create index observation_instrument_instrument on shadow.observation_instrument(instrument);
create index observation_instrument_observation on shadow.observation_instrument(observation);

create index observation_computation_computation on shadow.observation_computation(computation);
create index observation_computation_observation on shadow.observation_computation(observation);

create index observation_regionofspace_regionofspace on shadow.observation_regionofspace(regionofspace);
create index observation_regionofspace_observation on shadow.observation_regionofspace(observation);

create index observation_platform_platform on shadow.observation_platform(platform);
create index observation_platform_observation on shadow.observation_platform(observation);

create index observation_observedproperty_observedproperty on shadow.observation_observedproperty(observedproperty);
create index observation_observedproperty_observation on shadow.observation_observedproperty(observation);

create index observation_dimensionalityinstance_dimensionalityinstance on shadow.observation_dimensionalityinstance(dimensionalityinstance);
create index observation_dimensionalityinstance_observation on shadow.observation_dimensionalityinstance(observation);

create index observation_dimensionalitytimeline_dimensionalitytimeline on shadow.observation_dimensionalitytimeline(dimensionalitytimeline);
create index observation_dimensionalitytimeline_observation on shadow.observation_dimensionalitytimeline(observation);

create index observation_year_year on shadow.observation_year(year);
create index observation_year_observation on shadow.observation_year(observation);

create index observation_project_project on shadow.observation_project(project);
create index observation_project_observation on shadow.observation_project(observation);

create index observation_observationcollection_observationcollection on shadow.observation_observationcollection(observationcollection);
create index observation_observationcollection_observation on shadow.observation_observationcollection(observation);

create index resource_id on shadow.resource(id);
create index resource_name on shadow.resource(name);

DROP SCHEMA views CASCADE;
ALTER SCHEMA shadow RENAME TO views;