<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" 
	xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:esf="http://schemas.espas-fp7.eu"
	xmlns:dc="http://purl.org/dc/elements/1.1/">

	<xsl:template match="//ROW">
		<record>
			<header>
				<dri:objIdentifier>
					<xsl:value-of select="./FIELD[@name='dri_objidentifier']" />
				</dri:objIdentifier>
			</header>
			<metadata>
				<oaf:oaf>
					<xsl:for-each select="./FIELD[@name != 'dri_objidentifier']">
						<xsl:variable name="fieldNS" select="substring-before(@name, '_')" />
						<xsl:variable name="fieldName" select="substring-after(@name, '_')" />

						<xsl:choose>
							<xsl:when test="count(./ITEM)=0">
								<xsl:element name="{$fieldNS}:{$fieldName}">
									<xsl:value-of select="normalize-space(.)" />
								</xsl:element>
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="./ITEM">
									<xsl:sort select="normalize-space(.)" />
									<xsl:variable name="val" select="normalize-space(.)" />
									<xsl:element name="{$fieldNS}:{$fieldName}">
										<xsl:choose>
											<xsl:when test="contains($val,'§§§')">
												<xsl:value-of select="normalize-space(substring-after($val,'§§§'))" />
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$val" />
											</xsl:otherwise>
										</xsl:choose>
									</xsl:element>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</oaf:oaf>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
