/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.util;

import eu.dnetlib.enabling.manager.msro.espas.wf.util.OntologyMemberResource;
import eu.dnetlib.enabling.manager.msro.espas.wf.util.SimpleNamespaceContext;
import eu.dnetlib.enabling.manager.msro.espas.wf.util.Tree;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OntologyUtil {
    private static Log logger = LogFactory.getLog(OntologyUtil.class);

    public static String reorderConcepts(InputStream is) {
        try {
            Tree<OntologyMemberResource> tree = new Tree<OntologyMemberResource>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document document = dbf.newDocumentBuilder().parse(is);
            List<OntologyMemberResource> resources = OntologyUtil.splitXml(document);
            NodeList conceptSchemeList = document.getElementsByTagName("skos:ConceptScheme");
            Node conceptSchemeNode = conceptSchemeList.item(0);
            for (OntologyMemberResource resource : resources) {
                tree.addElement(resource.getParentId(), resource);
            }
            List reorderedResources = tree.traverse(Tree.TraversalOrder.BREADTH_FIRST_TRAVERSAL);
            for (OntologyMemberResource resource : reorderedResources) {
                Node node = document.importNode(resource.getNode(), true);
                conceptSchemeNode.appendChild(node);
            }
            return OntologyUtil.printDocument(document);
        }
        catch (Exception e) {
            logger.warn((Object)"Error reordering", (Throwable)e);
            return null;
        }
    }

    private static String printDocument(Document document) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    private static List<OntologyMemberResource> splitXml(Document doc) throws XPathExpressionException, SAXException, IOException, ParserConfigurationException, URISyntaxException, TransformerException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        HashMap<String, String> namespacesMap = new HashMap<String, String>();
        namespacesMap.put("skos", "http://www.w3.org/2004/02/skos/core#");
        namespacesMap.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        SimpleNamespaceContext namespaces = new SimpleNamespaceContext(namespacesMap);
        xpath.setNamespaceContext(namespaces);
        NodeList nodes = (NodeList)xpath.evaluate("//skos:member", doc, XPathConstants.NODESET);
        ArrayList<OntologyMemberResource> ontologyResources = new ArrayList<OntologyMemberResource>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String id = xpath.evaluate("./skos:Concept/@rdf:about", node);
            String parentId = xpath.evaluate("./skos:Concept/skos:broader/@rdf:resource", node);
            OntologyMemberResource ontologyMemberResource = new OntologyMemberResource(id, parentId, node);
            ontologyResources.add(ontologyMemberResource);
            node.getParentNode().removeChild(node);
        }
        return ontologyResources;
    }
}

