/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.dm;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;

public class UpdateProcess {
    private final String originalProcessModel;
    private Logger log = Logger.getLogger(this.getClass());
    private String updatedProcessModel = "";

    public UpdateProcess(Resource originalGraph) throws IOException {
        InputStream processStream = originalGraph.getInputStream();
        this.updatedProcessModel = this.originalProcessModel = this.serializeProcessDefinitionFile(processStream);
        this.log.error((Object)("updatedProcessModel: " + this.updatedProcessModel));
    }

    public UpdateProcess(InputStream originalGraph) throws IOException {
        InputStream processStream = originalGraph;
        this.updatedProcessModel = this.originalProcessModel = this.serializeProcessDefinitionFile(processStream);
        this.log.error((Object)("updatedProcessModel: " + this.updatedProcessModel));
    }

    public String getUpdatedProcess() {
        return this.updatedProcessModel;
    }

    public void insertParallelDownloadThreads(int numberOfThreads) {
        this.replicateArc(numberOfThreads);
        this.replicateNodeThreadNodes(numberOfThreads);
    }

    private void replicateNodeThreadNodes(int numberOfThreads) {
        int nodeStartIndex = this.originalProcessModel.indexOf("<node name=\"startLocalDownloadJob_1\"");
        int nodeEndIndex = this.originalProcessModel.indexOf("<!-- multi-threaded workflow pattern end -->") - 1;
        String replicationText = this.originalProcessModel.substring(nodeStartIndex, nodeEndIndex);
        String[] processParts = this.updatedProcessModel.split("<!-- multi-threaded workflow pattern end -->");
        String appendedText = "";
        for (int i = 2; i < numberOfThreads + 2; ++i) {
            appendedText = appendedText + replicationText.replaceAll("_1", "_" + i) + "\n";
        }
        this.updatedProcessModel = processParts[0] + "\n<!-- multi-threaded workflow pattern end-->\n" + appendedText + processParts[1];
    }

    private void replicateArc(int numberOfThreads) {
        String replicationText = "<arc to=\"startLocalDownloadJob_1\" />";
        String[] processParts = this.updatedProcessModel.split("<arc to=\"startLocalDownloadJob_1\" />");
        String appendedText = "";
        for (int i = 2; i < numberOfThreads + 2; ++i) {
            appendedText = appendedText + replicationText.replaceAll("_1", "_" + i) + "\n";
        }
        this.updatedProcessModel = processParts[0] + "\n<arc to=\"startLocalDownloadJob_1\" />\n" + appendedText + processParts[1];
    }

    private String serializeProcessDefinitionFile(InputStream processFileStream) {
        String outcome = null;
        StringWriter sw = new StringWriter();
        try {
            IOUtils.copy((InputStream)processFileStream, (Writer)sw);
            outcome = sw.toString();
        }
        catch (Exception e) {
            this.log.error((Object)"Error reading graph template", (Throwable)e);
        }
        return outcome;
    }
}

