/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.dm;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadDBUtils;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadRequestListHolder;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorReportJob
extends AbstractJobNode {
    private static final Log _logger = LogFactory.getLog(ErrorReportJob.class);
    private DownloadDBUtils downloadDBUtils;

    public void execute(Engine engine, NodeToken token) {
        super.execute(engine, token);
        String nodeName = this.getName();
        int threadIndex = Integer.parseInt(nodeName.substring(nodeName.lastIndexOf("_") + 1)) - 1;
        DownloadRequestListHolder jobListHolder = (DownloadRequestListHolder)token.getProcess().getEnv().getTransientAttribute("DownloadRequest_Var");
        String providerId = jobListHolder.popProviderJob(threadIndex);
        try {
            long jobId = this.getJobId(token);
            this.downloadDBUtils.updateProviderDetails(jobId, providerId, "FAILED", "Failed to call local download service of provider :" + providerId, null);
        }
        catch (Exception e) {
            _logger.error((Object)("Error while updating provider [" + providerId + "] status for jod "), (Throwable)e);
        }
        engine.complete(token, Arc.DEFAULT_ARC);
    }

    private long getJobId(NodeToken token) {
        return Long.parseLong(token.getFullEnv().getAttribute("DownloadJobId_Var"));
    }

    private String getResourceProfileConfiguration(NodeToken token) {
        return token.getFullEnv().getAttribute("resourceProfile");
    }

    public DownloadDBUtils getDownloadDBUtils() {
        return this.downloadDBUtils;
    }

    public void setDownloadDBUtils(DownloadDBUtils downloadDBUtils) {
        this.downloadDBUtils = downloadDBUtils;
    }
}

