/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.data.information.DataSinkSourceException;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.EPRDataSourceResolverImpl;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreRecordsJob
extends AbstractJobNode {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private DataSinkResolver dataSinkResolver = null;
    private DataSourceResolver dataSourceResolver = null;

    public void execute(Engine engine, NodeToken token) {
        try {
            String dataSource = this.getRSIdentifier(token);
            String dataSink = this.getMDStoreIdentifier(token);
            this.logger.info((Object)("Copying from " + dataSource + " to " + dataSink));
            token.getEnv().setAttribute("dataSource", dataSource);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error copying records", (Throwable)e);
            engine.complete(token, "failed");
        }
        engine.complete(token, Arc.DEFAULT_ARC);
    }

    private String getRSIdentifier(NodeToken token) {
        return "dnet://EPR/" + token.getFullEnv().getAttribute("RESULT-SET-EPR");
    }

    private String getMDStoreIdentifier(NodeToken token) {
        return token.getFullEnv().getAttribute("dataSink");
    }

    public DataSinkResolver getDataSinkResolver() {
        return this.dataSinkResolver;
    }

    public void setDataSinkResolver(DataSinkResolver dataSinkResolver) {
        this.dataSinkResolver = dataSinkResolver;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public static void main(String[] args) throws DataSinkSourceException {
        System.out.println(new EPRDataSourceResolverImpl().resolve("dnet://EPR/%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%20standalone%3D%22yes%22%3F%3E%3CEndpointReference%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2005%2F08%2Faddressing%22%3E%3CAddress%3Ehttp%3A%2F%2F88.197.53.114%3A8280%2Fis%2Fservices%2FresultSet%3C%2FAddress%3E%3CReferenceParameters%3E%3CResourceIdentifier%3AResourceIdentifier%20xmlns%3D%22http%3A%2F%2Fwww.driver.org%22%20xmlns%3Awsa%3D%22http%3A%2F%2Fwww.w3.org%2F2005%2F08%2Faddressing%22%20xmlns%3AResourceIdentifier%3D%22http%3A%2F%2Fwww.driver.org%22%3Ers-ec773b53-8b5d-4716-b4a1-c35d00bb590b%3C%2FResourceIdentifier%3AResourceIdentifier%3E%3C%2FReferenceParameters%3E%3CMetadata%3E%3Cwsaw%3AServiceName%20xmlns%3Ans2%3D%22http%3A%2F%2Fwww.driver.org%22%20xmlns%3Awsa%3D%22http%3A%2F%2Fwww.w3.org%2F2005%2F08%2Faddressing%22%20xmlns%3Awsaw%3D%22http%3A%2F%2Fwww.w3.org%2F2006%2F05%2Faddressing%2Fwsdl%22%3Ens2%3AserviceName%3C%2Fwsaw%3AServiceName%3E%3C%2FMetadata%3E%3C%2FEndpointReference%3E").retrieve().toString());
        System.out.println(new EPRDataSourceResolverImpl().resolve("dnet://EPR/%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%20standalone%3D%22yes%22%3F%3E%3CEndpointReference%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2005%2F08%2Faddressing%22%3E%3CAddress%3Ehttp%3A%2F%2F88.197.53.114%3A8280%2Fis%2Fservices%2FresultSet%3C%2FAddress%3E%3CReferenceParameters%3E%3CResourceIdentifier%3AResourceIdentifier%20xmlns%3D%22http%3A%2F%2Fwww.driver.org%22%20xmlns%3Awsa%3D%22http%3A%2F%2Fwww.w3.org%2F2005%2F08%2Faddressing%22%20xmlns%3AResourceIdentifier%3D%22http%3A%2F%2Fwww.driver.org%22%3Ers-f581ce2a-deb4-4583-a8f4-a10de1cef37a%3C%2FResourceIdentifier%3AResourceIdentifier%3E%3C%2FReferenceParameters%3E%3CMetadata%3E%3Cwsaw%3AServiceName%20xmlns%3Ans2%3D%22http%3A%2F%2Fwww.driver.org%22%20xmlns%3Awsa%3D%22http%3A%2F%2Fwww.w3.org%2F2005%2F08%2Faddressing%22%20xmlns%3Awsaw%3D%22http%3A%2F%2Fwww.w3.org%2F2006%2F05%2Faddressing%2Fwsdl%22%3Ens2%3AserviceName%3C%2Fwsaw%3AServiceName%3E%3C%2FMetadata%3E%3C%2FEndpointReference%3E").retrieve().toString());
    }
}

