/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class StartCSWHarvestJob
extends BlackboardJobNode {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServiceLocator<ISLookUpService> lookupLocator;

    protected String locateService(NodeToken token) {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'CSHarvesterServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'CSHarvesterServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
        super.prepareJob(job, token);
        try {
            String cswHarvestId = token.getProcess().getEnv().getAttribute("cswHarvestId");
            String cswhBody = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(cswHarvestId);
            XPath xpath = XPathFactory.newInstance().newXPath();
            Document doc = new StringOpaqueResource(cswhBody).asDom();
            String cswId = xpath.evaluate("//CSW_IDENTIFIER", doc);
            String fromDate = xpath.evaluate("//DATE_FROM", doc);
            String toDate = xpath.evaluate("//DATE_TO", doc);
            String type = xpath.evaluate("//OBJECT_TYPE", doc);
            String cswBody = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(cswId);
            Document cswDoc = new StringOpaqueResource(cswBody).asDom();
            String url = xpath.evaluate("//INTERFACE[ACCESS_PROTOCOL/text()='CSW']/BASE_URL/text()", cswDoc);
            String dataSink = xpath.evaluate("//DATA_SINK/text()", cswDoc);
            job.setAction("START-HARVESTING");
            job.getParameters().put("URL", url);
            job.getParameters().put("FROM-DATE", fromDate);
            job.getParameters().put("TO-DATE", toDate);
            job.getParameters().put("RECORD-TYPE", type);
            job.getParameters().put("NEXT-RECORD", "0");
            job.getParameters().put("MAX-RECORDS", "100");
            job.getParameters().put("cswId", cswId);
            job.getParameters().put("dataSink", dataSink);
        }
        catch (Exception e) {
            this.logger.error((Object)"Job preparation FAILED", (Throwable)e);
            throw new RuntimeException("Job preparation FAILED", e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

