/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;
import eu.dnetlib.enabling.manager.msro.ResourceToWorkflowMapper;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.io.IOException;
import javax.annotation.Resource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.Endpoint;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

public class CSWNotificationHandler
extends AbstractSubscriptionAction {
    private static final Log log = LogFactory.getLog(CSWNotificationHandler.class);
    @Resource
    private transient Engine engine;
    private ResourceToWorkflowMapper workflowMapper;
    @Resource(name="jaxwsEndpointReferenceBuilder")
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private Endpoint endpoint;
    private GraphProcessRegistry processRegistry;

    public void notified(String subscrId, String topic, String rsId, String profile) {
        log.info((Object)("CSW notification: " + topic + "(" + (Object)((Object)this) + ")"));
        if (!topic.startsWith(this.getTopicPrefix())) {
            return;
        }
        log.info((Object)("CSW notification matched, processing " + topic));
        try {
            StringOpaqueResource resource = new StringOpaqueResource(profile);
            for (Graph graph : this.workflowMapper.getWorkflowsForResource((OpaqueResource)resource)) {
                GraphProcess process = this.engine.getFactory().newProcess(graph);
                this.processRegistry.associateProcessWithResource(process, rsId);
                Env env = process.getEnv();
                env.setAttribute("msroUri", this.eprBuilder.getAddress((Object)this.endpoint));
                env.setAttribute("cswId", rsId);
                this.engine.startProcess(process);
            }
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Required
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public GraphProcessRegistry getProcessRegistry() {
        return this.processRegistry;
    }

    public void setProcessRegistry(GraphProcessRegistry processRegistry) {
        this.processRegistry = processRegistry;
    }

    public ResourceToWorkflowMapper getWorkflowMapper() {
        return this.workflowMapper;
    }

    public void setWorkflowMapper(ResourceToWorkflowMapper workflowMapper) {
        this.workflowMapper = workflowMapper;
    }
}

