package eu.dnetlib.espas.gui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;

@SuppressWarnings("serial")
public class UserAccessException extends Exception implements IsSerializable {

	public enum ErrorCode implements IsSerializable {
		USER_ALREADY_EXISTS,
		SQL_ERROR,
		INVALID_USERNAME,
		INVALID_PASSWORD,
		NOT_ACTIVATED,
		ACTIVATION_ERROR,
		INCORRECT_CAPTCHA
	}
	
	private ErrorCode errorCode = null;
	
	public UserAccessException() {
	}
	
	public UserAccessException(ErrorCode errorCode) {
		this.errorCode = errorCode;
	}

	public UserAccessException(String message, Throwable cause, ErrorCode errorCode) {
		super(message, cause);
		
		this.errorCode = errorCode;
	}

	public UserAccessException(String message, ErrorCode errorCode) {
		super(message);
		
		this.errorCode = errorCode;
	}

	public UserAccessException(Throwable cause, ErrorCode errorCode) {
		super(cause);
		
		this.errorCode = errorCode;
	}

	public ErrorCode getErrorCode() {
		return errorCode;
	}
}