package eu.dnetlib.espas.gui.client.user;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

import eu.dnetlib.espas.gui.shared.DataProvider;
import eu.dnetlib.espas.gui.shared.DataProviderStatus;
import eu.dnetlib.espas.gui.shared.UserAccessException;

@RemoteServiceRelativePath("dataProviderAccess")
public interface DataProviderAccessService extends RemoteService {

	public List<DataProvider> getDataProvidersByUser(String userId) throws UserAccessException;
	
	public void saveDataProvider(DataProvider dataProvider) throws UserAccessException;
	
	public void updateDataProvider(DataProvider dataProvider) throws UserAccessException;
	
	public void deleteDataProvider(DataProvider dataProvider) throws UserAccessException;
	
	public DataProvider getDataProviderByNamespace(String namespace) throws UserAccessException;
	
	public List<DataProvider> getDataProviders() throws UserAccessException;

    public List<DataProviderStatus> getAllDataProviderStatuses() throws UserAccessException;

    public List<DataProviderStatus> getDataProviderStatuses(List<String> namespaces) throws UserAccessException;

    public Map<String, Integer> getEntriesCount(String dataProviderId) throws UserAccessException;

    public void deleteDataProvider(String dataProviderId) throws UserAccessException;
}
