package eu.dnetlib.espas.gui.client;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

import eu.dnetlib.espas.gui.shared.User;
import eu.dnetlib.espas.gui.shared.UserAccessException;

@RemoteServiceRelativePath("userAccess")
public interface UserService extends RemoteService {
	
	public void insertUser(User user, String challenge, String response) throws UserAccessException;
	
	public User getUserById(String userEmail, String password) throws UserAccessException;
	
	public User getUserById(String userEmail) throws UserAccessException;
	
	public void updateUser(User user)  throws UserAccessException;
	
	public User activateUser(User user) throws UserAccessException;
	
	public void resetPassword(User user, String challenge, String response) throws UserAccessException;
	
	public String getPublicCaptchaKey();
	
	public void updateUserPassword(String userEmail, String password) throws UserAccessException;
	
	public List<User> getUsers() throws UserAccessException;
	
	public void activateUsers(List<String> emails) throws UserAccessException;
	
	public void deactivateUsers(List<String> emails) throws UserAccessException;
	
	public void deleteUsers(List<String> emails) throws UserAccessException;
	
	public void addRoleToUser(String email, String role) throws UserAccessException;
	
	public void removeRoleFromUser(String email, String role) throws UserAccessException;
	
	public void denyDataProviderRoleToUser(String email) throws UserAccessException;
	
	public List<String> getDataProviderUsersEmails() throws UserAccessException;

    public List<User> getDataProviderUsers();
}
