package eu.dnetlib.espas.gui.client;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.ControlLabel;
import com.github.gwtbootstrap.client.ui.Controls;
import com.github.gwtbootstrap.client.ui.Fieldset;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * Created by stefania on 10/2/14.
 */
public class FormFieldSet implements IsWidget {

    private Fieldset fieldset = new Fieldset();

    private ControlGroup controlGroup = new ControlGroup();
    private ControlLabel controlLabel = new ControlLabel();
    private Controls controls = new Controls();

    public FormFieldSet(String label, Widget... widgets) {

        for(Widget widget : widgets)
            controls.add(widget);

        if(label!=null)
            controlLabel.add(new Label(label));

        controlGroup.add(controlLabel);
        controlGroup.add(controls);

        fieldset.add(controlGroup);
    }

    @Override
    public Widget asWidget() {
        return fieldset;
    }

    public void setControlGroupType(ControlGroupType controlGroupType) {
        controlGroup.setType(controlGroupType);
    }

}
