package gr.uoa.di.driver.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

import javax.xml.bind.JAXBException;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.DisplayType;
import eu.dnetlib.domain.functionality.DocumentDescription;
import eu.dnetlib.domain.functionality.DocumentExternalUrlDisplayType;
import eu.dnetlib.domain.functionality.DocumentField;
import eu.dnetlib.domain.functionality.DocumentField.Cutpoint;
import eu.dnetlib.domain.functionality.ExternalUrlDisplayType;
import eu.dnetlib.domain.functionality.InternalUrlDisplayType;
import eu.dnetlib.domain.functionality.PlainTextDisplayType;
import eu.dnetlib.domain.functionality.SearchDisplayType;
import eu.dnetlib.domain.functionality.Searchable;
import eu.dnetlib.domain.functionality.Searchable.Type;
import eu.dnetlib.domain.functionality.SearchableDate;
import eu.dnetlib.domain.functionality.SwitchDocumentField;
import eu.dnetlib.domain.functionality.WebInterfaceLayout;
import eu.dnetlib.domain.functionality.WebInterfaceSearchCriteria;
import gr.uoa.di.driver.xml.webinterfacelayout.CutpointType;
import gr.uoa.di.driver.xml.webinterfacelayout.DisplayListType;
import gr.uoa.di.driver.xml.webinterfacelayout.DisplayTypeType;
import gr.uoa.di.driver.xml.webinterfacelayout.DocumentDescriptionType;
import gr.uoa.di.driver.xml.webinterfacelayout.DocumentFieldListType;
import gr.uoa.di.driver.xml.webinterfacelayout.DocumentFieldType;
import gr.uoa.di.driver.xml.webinterfacelayout.MapEntryType;
import gr.uoa.di.driver.xml.webinterfacelayout.MapMapEntryType;
import gr.uoa.di.driver.xml.webinterfacelayout.MapType;
import gr.uoa.di.driver.xml.webinterfacelayout.ObjectFactory;
import gr.uoa.di.driver.xml.webinterfacelayout.RESOURCEPROFILE;
import gr.uoa.di.driver.xml.webinterfacelayout.SEARCHABLEType;
import gr.uoa.di.driver.xml.webinterfacelayout.SUPPORTEDLOCALEType;
import gr.uoa.di.driver.xml.webinterfacelayout.SearchableTypeType;
import gr.uoa.di.driver.xml.webinterfacelayout.SwitchType;

public class WebInterfaceLayoutXmlConverter extends AbstractConverter<WebInterfaceLayout> implements
		ResourceToXmlConverter<WebInterfaceLayout> {

	static Logger logger = Logger
			.getLogger(WebInterfaceLayoutXmlConverter.class);
	private ObjectFactory of = new ObjectFactory();

	public WebInterfaceLayoutXmlConverter() throws JAXBException {
		super(RESOURCEPROFILE.class, DocumentDescriptionType.class);
	}

	public String ObjectToXml(WebInterfaceLayout layout) throws JAXBException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		RESOURCEPROFILE profile = of.createRESOURCEPROFILE();

		profile.setHEADER(of.createHEADERType());
		profile.setBODY(of.createBODYType());
		profile.getBODY().setCONFIGURATION(of.createCONFIGURATIONType());

		profile.getHEADER().setRESOURCEIDENTIFIER(
				of.createRESOURCEIDENTIFIERType());
		profile.getHEADER().setRESOURCEKIND(of.createRESOURCEKINDType());
		profile.getHEADER().setRESOURCETYPE(of.createRESOURCETYPEType());
		profile.getHEADER().setRESOURCEURI(of.createRESOURCEURIType());
		profile.getHEADER().setDATEOFCREATION(of.createDATEOFCREATIONType());

		this.setXmlHeader(profile, layout);
		this.setXmlBody(layout, profile);

		this.getMarshaller().marshal(profile, baos);
		return baos.toString();
	}

	private void setXmlBody(WebInterfaceLayout layout, RESOURCEPROFILE profile) {
		profile.getBODY().getCONFIGURATION().setNAME(layout.getName());
		profile.getBODY().getCONFIGURATION().setMDFORMATNAME(
				layout.getMdFormatName());
		profile.getBODY().getCONFIGURATION().setINDEXLAYOUTNAME(
				layout.getIndexLayoutName());

		profile.getBODY().setCSSFILE(layout.getCssFile());

		
		profile.getBODY().setSUPPORTEDLOCALES(of.createSuportedLocalesListType());

		Locale defaultLocale  = layout.getDefaultLocale();
		SUPPORTEDLOCALEType sltype = of.createSUPPORTEDLOCALEType();
		sltype.setDEFAULT(true);
		sltype.setLOCALE(defaultLocale.getLanguage()+"_"+ defaultLocale.getCountry());
		profile.getBODY().getSUPPORTEDLOCALES().getSUPPORTEDLOCALE().add(sltype);

		for(Locale slocale : layout.getSupportedLocales()) {
			sltype = of.createSUPPORTEDLOCALEType();
			sltype.setDEFAULT(false);
			sltype.setLOCALE(slocale.getLanguage()+"_"+ slocale.getCountry());
			profile.getBODY().getSUPPORTEDLOCALES().getSUPPORTEDLOCALE().add(sltype);
		}
		
		profile.getBODY().setSEARCHABLES(of.createSEARCHABLESType());

		for (Searchable s : layout.getSearchFields()) {
			SEARCHABLEType stype = new SEARCHABLEType();

			// name
			stype.setNAME(s.getName());
			stype.setHidden(s.isHidden());

			// type
			if (s instanceof SearchableDate) {
				stype.setTYPE(SearchableTypeType.DATE);

				Integer fromYear = ((SearchableDate) s).getFromYear();

				if (fromYear != null) {
					stype.setFROMYEAR(((SearchableDate) s).getFromYear());
					Integer toYear = ((SearchableDate) s).getToYear();
					stype.setTOYEAR(toYear);

				} else {
					stype.setFROMYEAR(-1);
					stype.setTOYEAR(-1);

				}

				stype.setPERIODBACKMAP(of.createMapMapType());

				for (Integer key : ((SearchableDate) s).getPeriodBackMap()
						.keySet()) {					

					MapMapEntryType mapEntry = of.createMapMapEntryType();

					mapEntry.setKey(key);
					
					Map<Locale, String> value = ((SearchableDate) s).getPeriodBackMap().get(key);
					
					for(Locale locale:value.keySet()){
						MapEntryType entry = of.createMapEntryType();					
						entry.setKey(locale.getLanguage()+"_"+ locale.getCountry());
						entry.setValue(value.get(locale));
						mapEntry.getValue().add(entry);
					}
					
					stype.getPERIODBACKMAP().getMapEntry().add(mapEntry);

				}

			} else {
				stype.setTYPE(SearchableTypeType.PLAIN);

			}

			// index
			stype.setINDEXTYPE(s.getIndexType());

			// description
			stype.setDESCRIPTIONMAP(of.createMapType());
			Map<Locale, String> descriptionMap = ((Searchable) s).getDescriptionMap();
			List<MapEntryType> entrylist = stype.getDESCRIPTIONMAP().getEntry();
			setLocaleDescriptionMapType(entrylist, descriptionMap);
				

			// short description
			stype.setSHORTDESCRIPTIONMAP(of.createMapType());
			Map<Locale, String> shortDescriptionMap = ((Searchable) s).getShortDescriptionMap();
			List<MapEntryType> entryList = stype.getSHORTDESCRIPTIONMAP().getEntry();
			setLocaleDescriptionMapType(entryList, shortDescriptionMap);
			

			// in search, browse, refine
			stype.setINSEARCH(s.isInSearch());
			stype.setINREFINE(s.isInRefine());
			stype.setINBROWSE(s.isInBrowse());

			// rank search, browse, refine
			stype.setSEARCHRANK(s.getSearchRank());
			stype.setBROWSERANK(s.getBrowseRank());
			stype.setREFINERANK(s.getRefineRank());

			// search, browse vocabulary
			stype.setSEARCHVOCABULARY(s.getSearchVocabulary());
			stype.setBROWSEVOCABULARY(s.getBrowseVocabulary());

			profile.getBODY().getSEARCHABLES().getSEARCHABLE().add(stype);
		}

		// create Map for document description
		profile.getBODY().setDOCUMENTDESCRIPTIONS(of.createMapType());

		// document description list
		for (String key : layout.getDocumentDescriptions().keySet()) {
			DocumentDescription documentDescription = layout
					.getDocumentDescriptions().get(key);
			DocumentDescriptionType ddtype = new DocumentDescriptionType();
			ddtype.setView(key);

			DocumentFieldListType documentFieldListType = of
					.createDocumentFieldListType();
			ddtype.setDocumentFields(documentFieldListType);

			// fill this map
			for (DocumentField field : documentDescription.getDocumentFields()) {
				DocumentFieldType fieldType = createDocumentFieldXml(ddtype,
						documentFieldListType, field);
				ddtype.getDocumentFields().getDocumentField().add(fieldType);
			}

			MapEntryType entry = of.createMapEntryType();
			entry.setKey(ddtype.getView());
			entry.setValue(ddtype);

			profile.getBODY().getDOCUMENTDESCRIPTIONS().getEntry().add(entry);

		}

		for (String collectionId : layout.getBaseCollections()) {
			profile.getBODY().getBASECOLLECTIONS().add(collectionId);
		}

		profile.getBODY().setVIEWCOMMUNITIES(layout.isViewCommunities());
		profile.getBODY().setVIEWCOLLECTIONS(layout.isViewCollections());
		profile.getBODY().setVIEWREPOSITORIES(layout.isViewRepositories());
		profile.getBODY().setVIEWANNOUNCEMENTS(layout.isViewAnnouncements());
		profile.getBODY().setVIEWUSERPROFILE(layout.isViewUserProfile());
		profile.getBODY().setVIEWSIMILARDOCUMENTS(layout.isViewSimilarDocuments());
		profile.getBODY().setVIEWEPUBLICATIONS(layout.isViewEPublications());

	}

	private void setLocaleDescriptionMapType(List<MapEntryType> entryList,
			Map<Locale, String> descriptionMap) {
		for (Locale locale : descriptionMap.keySet()) {
			String description = descriptionMap.get(locale);
			
			MapEntryType entry = of.createMapEntryType();
			entry.setKey(locale.getLanguage()+"_"+locale.getCountry());
			entry.setValue(description);
			
			entryList.add(entry);
		}
	}

	private DocumentFieldType createDocumentFieldXml(
			DocumentDescriptionType ddtype,
			DocumentFieldListType documentFieldListType, DocumentField field) {

		DocumentFieldType fieldType = of.createDocumentFieldType();
		switch (field.getCutpoint()) {
		case LINE:
			fieldType.setCutpoint(CutpointType.LINE);
			break;
		case PART:
			fieldType.setCutpoint(CutpointType.PART);
			break;
		case VALUE:
			fieldType.setCutpoint(CutpointType.VALUE);
		}

		fieldType.setCssClass(field.getCssClass());

		if (field instanceof SwitchDocumentField) {
			SwitchType switchType = of.createSwitchType();
			fieldType.setSwitch(switchType);
			switchType.setConditionField(((SwitchDocumentField) field)
					.getConditionField());

			MapType documentFieldMapType = of.createMapType();
			for (String conditionFieldValue : ((SwitchDocumentField) field)
					.getDocumentFieldMap().keySet()) {
				MapEntryType entry = of.createMapEntryType();
				entry.setKey(conditionFieldValue);
				DocumentField switcheField = ((SwitchDocumentField) field)
						.getDocumentFieldMap().get(conditionFieldValue);
				DocumentFieldListType switchedDocumentFieldListType = of
						.createDocumentFieldListType();
				entry.setValue(createDocumentFieldXml(ddtype,
						switchedDocumentFieldListType, switcheField));

				documentFieldMapType.getEntry().add(entry);
			}

			switchType.setDocumentFieldMap(documentFieldMapType);
			fieldType.getSwitch().setDocumentFieldMap(documentFieldMapType);

		} else {

			fieldType.setName(field.getName());
			
			//field description
			fieldType.setDescriptionMap(of.createMapType());
			Map<Locale, String> descriptionMap = field.getDescriptionMap();
			List<MapEntryType> entryList = fieldType.getDescriptionMap().getEntry();
			setLocaleDescriptionMapType(entryList, descriptionMap);
			
			fieldType.setForceDescription(field.getForceDescription());
			
			//secondary link
			if(field.getSecondaryLinkMap()!=null) {
				fieldType.setMultipleValuesDescriptionMap(of.createMapType());
				Map<Locale, String> multipleValuesDescriptionMap = field.getSecondaryLinkMap();
				entryList = fieldType.getMultipleValuesDescriptionMap().getEntry();
				setLocaleDescriptionMapType(entryList, multipleValuesDescriptionMap);
			}
			fieldType.setVocabulary(field.getVocabulary());
			fieldType.setMaxCharacters(field.getMaxCharacters());

			DisplayListType displayListType = of.createDisplayListType();
			for (DisplayType display : field.getDisplays()) {

				gr.uoa.di.driver.xml.webinterfacelayout.DisplayType displayType = of
						.createDisplayType();

				//display description
				displayType.setDescriptionMap(of.createMapType());
				Map<Locale, String> displayDescriptionMap = display.getDescriptionMap();
				if (displayDescriptionMap != null) {
					List<MapEntryType> displayEntryList = displayType.getDescriptionMap().getEntry();
					setLocaleDescriptionMapType(displayEntryList, displayDescriptionMap);
				}
				
				createXmlDisplayType(display, displayType);
				displayListType.getDisplay().add(displayType);

				fieldType.setDisplays(displayListType);
			}

		}

		return fieldType;
	}

	private void createXmlDisplayType(DisplayType display,
			gr.uoa.di.driver.xml.webinterfacelayout.DisplayType displayType) {

		if (display instanceof SearchDisplayType) {
			String label = ((SearchDisplayType) display).getLabel();
			displayType.setLabel(label);
			displayType.setDisplayType(DisplayTypeType.SEARCH);

		} else if (display instanceof InternalUrlDisplayType) {
			String action = ((InternalUrlDisplayType) display).getAction();
			if (action != null) {
				displayType.setAction(action);
			}

			String parameter = ((InternalUrlDisplayType) display)
					.getParameter();
			if (parameter != null) {
				displayType.setParameter(parameter);
			}

			displayType.setDisplayType(DisplayTypeType.INTERNAL_URL);

		} else if (display instanceof DocumentExternalUrlDisplayType) {
			displayType.setDisplayType(DisplayTypeType.DOCUMENT_EXTERNAL_URL);

		} else if (display instanceof ExternalUrlDisplayType) {
			displayType.setDisplayType(DisplayTypeType.EXTERNAL_URL);

		} else if (display instanceof PlainTextDisplayType) {
			displayType.setDisplayType(DisplayTypeType.PLAIN);

		}
	}

	private RESOURCEPROFILE setXmlHeader(RESOURCEPROFILE profile,
			WebInterfaceLayout layout) {
		profile.getHEADER().getRESOURCEKIND().setValue(layout.getResourceKind());
		profile.getHEADER().getRESOURCETYPE().setValue(layout.getResourceType());

		if (layout.getDateOfCreation() != null)
			profile.getHEADER().getDATEOFCREATION().setValue(
					ConversionUtils.toXMLGregorianCalendar(layout.getDateOfCreation()));
		else
			profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.toXMLGregorianCalendar(new Date()));

		if (layout.getResourceId() != null)
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue(
					layout.getResourceId());
		else
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
		
		if (layout.getResourceUri() != null)
			profile.getHEADER().getRESOURCEURI().setValue(
					layout.getResourceUri());
		else
			profile.getHEADER().getRESOURCEURI().setValue("");

		return profile;
	}

	public WebInterfaceLayout XmlToObject(String xml) throws JAXBException {
		WebInterfaceLayout layout = new WebInterfaceLayout(null, null, null);

		RESOURCEPROFILE profile = setObjectHeader(xml, layout);
		setObjectBody(layout, profile);
		
		return layout;
	}

	private RESOURCEPROFILE setObjectHeader(String xml,
			WebInterfaceLayout layout) throws JAXBException {

		RESOURCEPROFILE profile = (RESOURCEPROFILE) this.getUnmarshaller()
				.unmarshal(new ByteArrayInputStream(xml.getBytes()));

		layout.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
		// layout.setDateOfCreation(ConversionUtils.toDate((profile.getHEADER()
		// .getDATEOFCREATION().getValue())));
		layout.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());		
		layout.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());

		return profile;
	}

	private void setObjectBody(WebInterfaceLayout layout,
			RESOURCEPROFILE profile) {

		layout.setName(profile.getBODY().getCONFIGURATION().getNAME());
		layout.setMdFormatName(profile.getBODY().getCONFIGURATION()
				.getMDFORMATNAME());
		layout.setIndexLayoutName(profile.getBODY().getCONFIGURATION()
				.getINDEXLAYOUTNAME());

		layout.setCssFile(profile.getBODY().getCSSFILE());

		layout.setViewCommunities(profile.getBODY().isVIEWCOMMUNITIES());
		layout.setViewCollections(profile.getBODY().isVIEWCOLLECTIONS());
		layout.setViewRepositories(profile.getBODY().isVIEWREPOSITORIES());
		layout.setViewAnnouncements(profile.getBODY().isVIEWANNOUNCEMENTS());
		layout.setViewUserProfile(profile.getBODY().isVIEWUSERPROFILE());
		layout.setViewSimilarDocuments(profile.getBODY().isVIEWSIMILARDOCUMENTS());
		layout.setViewEPublications(profile.getBODY().isVIEWEPUBLICATIONS());

		for (SUPPORTEDLOCALEType sltype: profile.getBODY().getSUPPORTEDLOCALES().getSUPPORTEDLOCALE()){
			if (sltype.isDEFAULT()){
				layout.setDefaultLocale(retrieveLocale(sltype)); 
			} else {
				layout.getSupportedLocales().add(retrieveLocale(sltype));
			}
			
			
		}
		
		for (String collectionId : profile.getBODY().getBASECOLLECTIONS()) {
			layout.getBaseCollections().add(collectionId);
		}

		for (SEARCHABLEType searchable : profile.getBODY().getSEARCHABLES()
				.getSEARCHABLE()) {
			Searchable s = null;
			
			switch (searchable.getTYPE()) {
			case DATE:
				s = new SearchableDate();

				int fromYear = searchable.getFROMYEAR();
				int toYear = searchable.getTOYEAR();

				if (fromYear != -1) {
					if (toYear == -1) {
						Date date = new Date();
						Calendar calendar = new GregorianCalendar();
						calendar.setTime(date);

						toYear = calendar.get(Calendar.YEAR);
					}

					if (toYear <= fromYear) {
						throw new RuntimeException(
								"Wrong configuration! $toYear should be greater than $fromYear");
					}

					((SearchableDate) s).setFromYear(fromYear);
					((SearchableDate) s).setToYear(toYear);

				}


				TreeMap<Integer, Map<Locale, String>> periodBack = new TreeMap<Integer, Map<Locale, String>>();				
				for (MapMapEntryType mapEntry:searchable.getPERIODBACKMAP().getMapEntry()) {					
					periodBack.put((Integer)mapEntry.getKey(), new HashMap<Locale, String>());
					for (MapEntryType entry : mapEntry.getValue()) {
						String[] localeParts = ((String) entry.getKey()).split("_");
						Locale locale = new Locale(localeParts[0], localeParts[1]);
						String description = (String) entry.getValue();
						periodBack.get(mapEntry.getKey()).put(locale, description);
					}
				}
				((SearchableDate) s).setPeriodBackMap(periodBack);

			/*	if (fromYear != -1) {
					periodBack.put(0, "in the specified date range");
				}
			*/	
				break;

			case PLAIN:
				s = new Searchable(Type.PLAIN);
				break;
			}

			s.setName(searchable.getNAME());
			s.setHidden(searchable.isHidden());
			s.setIndexType(searchable.getINDEXTYPE());

			//description map
			List<MapEntryType> entryList = searchable.getDESCRIPTIONMAP().getEntry();
			Map<Locale, String> descriptionMap = new HashMap<Locale, String>();
			setLocaleDescriptionMap(entryList, descriptionMap);
			((Searchable)s).setDescriptionMap(descriptionMap);
			
			//short description map
			entryList = searchable.getSHORTDESCRIPTIONMAP().getEntry();
			Map<Locale, String> shortDescriptionMap = new HashMap<Locale, String>();
			setLocaleDescriptionMap(entryList, shortDescriptionMap);
			((Searchable)s).setShortDescriptionMap(shortDescriptionMap);

			s.setInSearch(searchable.isINSEARCH());
			s.setInRefine(searchable.isINREFINE());
			s.setInBrowse(searchable.isINBROWSE());

			s.setSearchRank(searchable.getSEARCHRANK());
			s.setBrowseRank(searchable.getBROWSERANK());
			s.setRefineRank(searchable.getREFINERANK());

			s.setSearchVocabulary(searchable.getSEARCHVOCABULARY());
			s.setBrowseVocabulary(searchable.getBROWSEVOCABULARY());

			layout.getSearchFields().add(s);
		}

		for (MapEntryType entry : profile.getBODY().getDOCUMENTDESCRIPTIONS()
				.getEntry()) {
			DocumentDescription docDescription = new DocumentDescription((String) entry.getKey());
			DocumentDescriptionType documentDescrType = (DocumentDescriptionType) entry
					.getValue();

			for (DocumentFieldType fieldType : documentDescrType.getDocumentFields().getDocumentField()) {
				docDescription.getDocumentFields().add(createDocumentFieldObject(fieldType));
				layout.getDocumentDescriptions().put(docDescription.getView(),
						docDescription);
			}
		
		}

	}

	private Locale retrieveLocale(SUPPORTEDLOCALEType sltype) {
		String localeDescr = sltype.getLOCALE();
		String[] locale_details = localeDescr.split("_");
		return new Locale(locale_details[0],locale_details[1]);		
	}

	private void setLocaleDescriptionMap(List<MapEntryType> entryList,
			Map<Locale, String> descriptionMap) {
		for(MapEntryType entry: entryList) {
			String[] localeParts = ((String)entry.getKey()).split("_");
			Locale locale = new Locale(localeParts[0], localeParts[1]);
			String description = (String) entry.getValue();				
			descriptionMap.put(locale, description);				
		}
	}

	private DocumentField createDocumentFieldObject(DocumentFieldType fieldType) {

		DocumentField field = null;

		if (fieldType.getSwitch() != null) {
			String conditionField = fieldType.getSwitch().getConditionField();
			field = new SwitchDocumentField(conditionField);
			
			for (MapEntryType switchEntry : fieldType.getSwitch().getDocumentFieldMap().getEntry()) {
				
				String conditionFieldValue = (String) switchEntry.getKey();
				DocumentFieldType switchFieldType = (DocumentFieldType) switchEntry.getValue();
				
				DocumentField documentField = createDocumentFieldObject(switchFieldType);
				
				List<MapEntryType> entryList = ((DocumentFieldType) switchEntry.getValue()).getDescriptionMap().getEntry();
				Map<Locale, String> descriptionMap = new HashMap<Locale, String>();
				setLocaleDescriptionMap(entryList, descriptionMap);
				((SwitchDocumentField) field).setDescriptionMap(descriptionMap);
				((SwitchDocumentField) field).addSwitchDisplayField(conditionFieldValue, documentField);
			}
			
		} else {
			String name = fieldType.getName();
			
			List<MapEntryType> entryList = fieldType.getDescriptionMap().getEntry();
			Map<Locale, String> descriptionMap = new HashMap<Locale, String>();
			setLocaleDescriptionMap(entryList, descriptionMap);
			
			String cssClass = fieldType.getCssClass();
			String vocabulary = fieldType.getVocabulary();
			CutpointType cutpointType = fieldType.getCutpoint();
			Cutpoint cutpoint = null;
			switch (cutpointType) {
			case LINE:
				cutpoint = Cutpoint.LINE;
				break;
			case PART:
				cutpoint = Cutpoint.PART;
				break;
			case VALUE:
				cutpoint = Cutpoint.VALUE;
				break;
			}

			Integer maxCharacters = fieldType.getMaxCharacters();

			List<DisplayType> displays = new ArrayList<DisplayType>();
			for (gr.uoa.di.driver.xml.webinterfacelayout.DisplayType displayType : fieldType
					.getDisplays().getDisplay()) {
				DisplayType display = createObjectDisplayType(displayType);
				displays.add(display);
			}

			if (cutpoint != null) {
				field = new DocumentField(name, descriptionMap, vocabulary,
						displays, cssClass, cutpoint, maxCharacters);

			} else if (maxCharacters != null) {
				field = new DocumentField(name, descriptionMap, vocabulary,
						displays, cssClass, maxCharacters);

			} else {
				field = new DocumentField(name, descriptionMap, vocabulary,
						displays, cssClass);
			}

			if (fieldType.isForceDescription() != null) {
				field.setForceDescription(fieldType.isForceDescription());

			} else {
				field.setForceDescription(false);

			}
			
			if (fieldType.getMultipleValuesDescriptionMap() != null) {
				entryList = fieldType.getMultipleValuesDescriptionMap().getEntry();
				Map<Locale, String> secondaryLinkMap = new HashMap<Locale, String>();
				setLocaleDescriptionMapType(entryList,secondaryLinkMap);
				field.setSecondaryLinkMap(secondaryLinkMap);
			}
			
		}
		
		return field;
	}

	private DisplayType createObjectDisplayType(
			gr.uoa.di.driver.xml.webinterfacelayout.DisplayType displayType) {

		DisplayType display = null;
		
		List<MapEntryType> entryList = displayType.getDescriptionMap().getEntry();
		Map<Locale, String> descriptionMap = new HashMap<Locale, String>();
		setLocaleDescriptionMap(entryList, descriptionMap);
		
		String field = displayType.getField();

		switch (displayType.getDisplayType()) {
		case PLAIN:
			display = new PlainTextDisplayType(field, descriptionMap);
			break;

		case SEARCH:
			String label = displayType.getLabel();
			if (label == null) {
				throw new RuntimeException("In case of "
						+ "SearchDisplayType field label cannot be null");
			}
			display = new SearchDisplayType(field, label, descriptionMap);
			break;

		case DOCUMENT_EXTERNAL_URL:
			display = new DocumentExternalUrlDisplayType(field, descriptionMap);
			break;

		case EXTERNAL_URL:
			display = new ExternalUrlDisplayType(field, descriptionMap);
			break;

		case INTERNAL_URL:
			String action = displayType.getAction();
			String parameter = displayType.getParameter();
			display = new InternalUrlDisplayType(field, descriptionMap, action,
					parameter);
		}
		return display;
	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((WebInterfaceSearchCriteria) criteria);
	}

	public String toXQueryString(WebInterfaceSearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);
		
		String xQuery = null;

		List<String> predicates = new ArrayList<String>();

		xQuery = "for $x in collection( \"/db/DRIVER/WebInterfaceLayoutResources/WebInterfaceLayoutResourceType\" )";

		if (criteria.getLayoutName() != null) {
			predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[.= \""
					+ criteria.getLayoutName() + "\"]");

		}

		for (int i = 0; i < predicates.size(); i++) {
			String predicate = predicates.get(i);

			if (i > 0) {
				xQuery += " and ";
			} else {
				xQuery += " where ";
			}
			xQuery += predicate;
		}
		xQuery += " return $x";
		logger.debug(xQuery);
		return xQuery;
	}

	@Deprecated
	public String toXQueryString(WebInterfaceLayout exampleInstance) {
		String xQuery = "for $x in collection( \"/db/DRIVER/WebInterfaceLayoutResources/WebInterfaceLayoutResourceType\" )";
		List<String> predicates = new ArrayList<String>();

		if (exampleInstance != null) {
			if (exampleInstance.getName() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[.=\""
								+ exampleInstance.getName() + "\"]");
			}

			for (int i = 0; i < predicates.size(); i++) {
				String predicate = predicates.get(i);

				if (i > 0) {
					xQuery += " and ";
				} else {
					xQuery += " where ";
				}
				xQuery += predicate;
			}
		}

		xQuery += " return $x";
		logger.debug(xQuery);
		return xQuery;
	}

	public static void main(String[] args) throws JAXBException {

		WebInterfaceLayoutXmlConverter converter = new WebInterfaceLayoutXmlConverter();
		WebInterfaceLayout layout = new WebInterfaceLayout("i18n_demo", "DMF", "index");

		layout.setCssFile("driver_search_es.css");
		
		layout.setDefaultLocale(new Locale("en", "GB"));
		List<Locale> supportedLocales = new ArrayList<Locale>();
		supportedLocales.add(new Locale("es", "ES"));
//		supportedLocales.add(new Locale("el","GR"));
//		supportedLocales.add(new Locale("zh","CN"));
		layout.setSupportedLocales(supportedLocales);
		
		layout.setViewCollections(false);
		layout.setViewCommunities(false);
		layout.setViewRepositories(true);
		layout.setViewAnnouncements(true);
		layout.setViewUserProfile(true);
		layout.setViewSimilarDocuments(false);
		layout.setViewEPublications(false);

		Searchable sable = new Searchable(Type.PLAIN);
		Map<Locale, String> descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Author");
		descriprionMap.put(new Locale("es", "ES"), "Creador");
//		descriprionMap.put(new Locale("el", "GR"), "Συγγραφέας");
//		descriprionMap.put(new Locale("zh", "CN"), "作者");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "author");
		descriprionMap.put(new Locale("es", "ES"), "creador");
//		descriprionMap.put(new Locale("el", "GR"), "συγγραφέας");
//		descriprionMap.put(new Locale("zh", "CN"), "作者");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("author");
		sable.setIndexType("creator");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(1);
		sable.setRefineRank(1);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Title");
		descriprionMap.put(new Locale("es", "ES"), "Título");
//		descriprionMap.put(new Locale("el", "GR"), "Τίτλος");
//		descriprionMap.put(new Locale("zh", "CN"), "标题");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "title");
		descriprionMap.put(new Locale("es", "ES"), "título");
//		descriprionMap.put(new Locale("el", "GR"), "τίτλος");
//		descriprionMap.put(new Locale("zh", "CN"), "标题");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("title");
		sable.setIndexType("title");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(2);
		sable.setRefineRank(2);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Subject");
		descriprionMap.put(new Locale("es", "ES"), "Materia");
//		descriprionMap.put(new Locale("el", "GR"), "Θέμα");
//		descriprionMap.put(new Locale("zh", "CN"), "主题");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "subject");
		descriprionMap.put(new Locale("es", "ES"), "materia");
//		descriprionMap.put(new Locale("el", "GR"), "θέμα");
//		descriprionMap.put(new Locale("zh", "CN"), "主题");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("subject");
		sable.setIndexType("subject");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(false);
		sable.setSearchRank(3);
		sable.setRefineRank(3);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Contributor");
		descriprionMap.put(new Locale("es", "ES"), "Contribuidor");
//		descriprionMap.put(new Locale("el", "GR"), "Συνεισφέρων");
//		descriprionMap.put(new Locale("zh", "CN"),"责任者");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "contributor");
		descriprionMap.put(new Locale("es", "ES"), "contribuidor");
//		descriprionMap.put(new Locale("el", "GR"), "συνεισφέρων");
//		descriprionMap.put(new Locale("zh", "CN"),"责任者");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("contributor");
		sable.setIndexType("contributor");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(false);
		sable.setSearchRank(4);
		sable.setRefineRank(4);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publisher");
		descriprionMap.put(new Locale("es", "ES"), "Editor");
//		descriprionMap.put(new Locale("el", "GR"), "Εκδότης");
//		descriprionMap.put(new Locale("zh", "CN"),"出版者");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "publisher");
		descriprionMap.put(new Locale("es", "ES"), "editor");
//		descriprionMap.put(new Locale("el", "GR"), "εκδότης");
//		descriprionMap.put(new Locale("zh", "CN"),"出版者");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("publisher");
		sable.setIndexType("publisher");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(false);
		sable.setSearchRank(5);
		sable.setRefineRank(5);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Source");
		descriprionMap.put(new Locale("es", "ES"), "Fuente");
//		descriprionMap.put(new Locale("el", "GR"), "Πηγή");
//		descriprionMap.put(new Locale("zh", "CN"),"来源");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "source");
		descriprionMap.put(new Locale("es", "ES"), "fuente");
//		descriprionMap.put(new Locale("el", "GR"), "πηγή");
//		descriprionMap.put(new Locale("zh", "CN"),"来源");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("source");
		sable.setIndexType("source");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(false);
		sable.setSearchRank(6);
		sable.setRefineRank(6);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);

		layout.getSearchFields().add(sable);
		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Relation");
		descriprionMap.put(new Locale("es", "ES"), "Relación");
		descriprionMap.put(new Locale("es", "ES"), "Relación");
	//	descriprionMap.put(new Locale("el", "GR"), "Σχέση");
	//	descriprionMap.put(new Locale("zh", "CN"),"关系");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "relation");
		descriprionMap.put(new Locale("es", "ES"), "relación");
	//	descriprionMap.put(new Locale("el", "GR"), "σχέση");
	//	descriprionMap.put(new Locale("zh", "CN"),"关系");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("relation");
		sable.setIndexType("relation");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(7);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new SearchableDate();
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publication Date");
		descriprionMap.put(new Locale("es", "ES"), "Fecha de Publicación");
//		descriprionMap.put(new Locale("el", "GR"), "Ημερομηνία Έκδοσης");
//		descriprionMap.put(new Locale("zh", "CN"),"发表时间");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "published");
		descriprionMap.put(new Locale("es", "ES"), "publicado");
//		descriprionMap.put(new Locale("el", "GR"), "εκδόθηκε");
//		descriprionMap.put(new Locale("zh", "CN"),"发表时间");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("dateAccept");
		sable.setIndexType("dateAccepted");
		sable.setInSearch(true);
		sable.setSearchRank(8);
		((SearchableDate) sable).setFromYear(1980);
	
		TreeMap<Integer, Map<Locale, String>> tm = new TreeMap<Integer, Map<Locale,String>>();
	
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the specified date range");
		descriprionMap.put(new Locale("es", "ES"), "de la fecha especificada gama");
//		descriprionMap.put(new Locale("el", "GR"), "στο χρονικό διάστημα");
//		descriprionMap.put(new Locale("zh", "CN"),"指定的日期范围");
		tm.put(new Integer(0), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last one month");
		descriprionMap.put(new Locale("es", "ES"), "en el último mes");
//		descriprionMap.put(new Locale("el", "GR"), "τον τελευταίο μήνα");
//		descriprionMap.put(new Locale("zh", "CN"),"前一个月");
		tm.put(new Integer(1), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 2 months");
		descriprionMap.put(new Locale("es", "ES"), "en los últimos 2 meses");
//		descriprionMap.put(new Locale("el", "GR"), "το τελευταίο δίμηνο");
//		descriprionMap.put(new Locale("zh", "CN"),"前两个月");
		tm.put(new Integer(2), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 3 months");
		descriprionMap.put(new Locale("es", "ES"), "en los últimos 3 meses");
//		descriprionMap.put(new Locale("el", "GR"), "το τελευταίο τρίμηνο");
//		descriprionMap.put(new Locale("zh", "CN"),"前三个月");
		tm.put(new Integer(3), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 6 months");
		descriprionMap.put(new Locale("es", "ES"), "en los últimos 6 meses");
//		descriprionMap.put(new Locale("el", "GR"), "το τελευταίο εξάμηνο");
//		descriprionMap.put(new Locale("zh", "CN"),"前六个月");
		tm.put(new Integer(6), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 12 months");
		descriprionMap.put(new Locale("es", "ES"), "en los últimos 12 meses");
//		descriprionMap.put(new Locale("el", "GR"), "τον τελευταίο χρόνο");
//		descriprionMap.put(new Locale("zh", "CN"),"前一年");
		tm.put(new Integer(12), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 2 years");
		descriprionMap.put(new Locale("es", "ES"), "en los últimos 2 años");
	//	descriprionMap.put(new Locale("el", "GR"), "τα τελευταία 2 χρόνια");
	//	descriprionMap.put(new Locale("zh", "CN"),"前两年");
		tm.put(new Integer(24), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 3 years");
		descriprionMap.put(new Locale("es", "ES"), "en los últimos 3 años");
//		descriprionMap.put(new Locale("el", "GR"), "τα τελευταία 3 χρόνια");
//		descriprionMap.put(new Locale("zh", "CN"),"前三年");
		tm.put(new Integer(36), descriprionMap);

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 5 years");
		descriprionMap.put(new Locale("es", "ES"), "en los últimos 5 años");
//		descriprionMap.put(new Locale("el", "GR"), "τα τελευταία 5 χρόνια");
//		descriprionMap.put(new Locale("zh", "CN"),"前五年");
		tm.put(new Integer(60), descriprionMap);

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 10 years");
		descriprionMap.put(new Locale("es", "ES"), "en los últimos 10 años");
//		descriprionMap.put(new Locale("el", "GR"), "τα τελευταία 10 χρόνια");
//		descriprionMap.put(new Locale("zh", "CN"),"前十年");
		tm.put(new Integer(120), descriprionMap);
		((SearchableDate) sable).getPeriodBackMap().putAll(tm);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Document Language");
		descriprionMap.put(new Locale("es", "ES"), "Idioma del Documento");
//		descriprionMap.put(new Locale("el", "GR"), "Γλώσσα Κειμένου");
//		descriprionMap.put(new Locale("zh", "CN"),"文档语种");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "language");
		descriprionMap.put(new Locale("es", "ES"), "idioma");
//		descriprionMap.put(new Locale("el", "GR"), "γλώσσα");
//		descriprionMap.put(new Locale("zh", "CN"),"语种");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("lang");
		sable.setIndexType("language");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(true);
		sable.setSearchRank(9);
		sable.setRefineRank(7);
		sable.setBrowseRank(1);
		sable.setSearchVocabulary("Short list of language names");
		sable.setBrowseVocabulary("Names of languages");
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Document Type");
		descriprionMap.put(new Locale("es", "ES"), "Tipo de Documento");
//		descriprionMap.put(new Locale("el", "GR"), "Είδος Κειμένου");
//		descriprionMap.put(new Locale("zh", "CN"),"文档类型");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "category");
		descriprionMap.put(new Locale("es", "ES"), "categoría");
//		descriprionMap.put(new Locale("el", "GR"), "είδος");
//		descriprionMap.put(new Locale("zh", "CN"),"类型");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("category");
		sable.setIndexType("CobjCategory");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(true);
		sable.setSearchRank(10);
		sable.setRefineRank(8);
		sable.setBrowseRank(2);
		sable.setSearchVocabulary("Names of Text Object Typologies");
		sable.setBrowseVocabulary("Names of Text Object Typologies");
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Repositories");
		descriprionMap.put(new Locale("es", "ES"), "Repositorios");
//		descriprionMap.put(new Locale("el", "GR"), "Αποθετήριο");
//		descriprionMap.put(new Locale("zh", "CN"),"仓储");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "repositories");
		descriprionMap.put(new Locale("es", "ES"), "repositorios");
//		descriprionMap.put(new Locale("el", "GR"), "αποθετήριο");
//		descriprionMap.put(new Locale("zh", "CN"),"仓储");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("repName");
		sable.setIndexType("repositoryName");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(true);
		sable.setSearchRank(11);
		sable.setRefineRank(9);
		sable.setBrowseRank(3);
		sable.setSearchVocabulary("Names of Repositories");
		layout.getSearchFields().add(sable);

		Map<String, DocumentDescription> documentDescriptions = new HashMap<String, DocumentDescription>();
		DocumentDescription dd = new DocumentDescription("summaryView");
		List<DocumentField> fields = new ArrayList<DocumentField>();
		List<DisplayType> displays = new ArrayList<DisplayType>();

		SwitchDocumentField switchField = new SwitchDocumentField("CobjTypology");

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		descriprionMap.put(new Locale("es", "ES"), "${title}");
		descriprionMap.put(new Locale("el", "GR"), "${title}");
		descriprionMap.put(new Locale("zh", "CN"),"${title}");		
		DisplayType type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
		displays.add(type);
		
		DocumentField field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		descriprionMap.put(new Locale("es", "ES"), "también se puede visitar");		
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε επίσης");
//		descriprionMap.put(new Locale("zh", "CN"),"您也可以访问");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Textual", field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		descriprionMap.put(new Locale("es", "ES"), "${title}");
		descriprionMap.put(new Locale("el", "GR"), "${title}");
		descriprionMap.put(new Locale("zh", "CN"),"${title}");
		displays = new ArrayList<DisplayType>();
		type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
		displays.add(type);
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		descriprionMap.put(new Locale("es", "ES"), "también se puede visitar");		
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε επίσης");
//		descriprionMap.put(new Locale("zh", "CN"),"您也可以访问");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Compound Object", field);
	
		dd.putDocumentField(switchField);
			
		type = new SearchDisplayType("creator", "author");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Author(s)");
		descriprionMap.put(new Locale("es", "ES"), "Creador(s)");
//		descriprionMap.put(new Locale("el", "GR"), "Συγγραφείς");
//		descriprionMap.put(new Locale("zh", "CN"),"作者");
		field = new DocumentField("creator", descriprionMap, null, displays,
				"resultsField", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("description");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Description");
		descriprionMap.put(new Locale("es", "ES"), "Descripción");
//		descriprionMap.put(new Locale("el", "GR"), "Περιγραφή");
//		descriprionMap.put(new Locale("zh", "CN"),"描述");
		field = new DocumentField("description", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${repositoryName}");
		descriprionMap.put(new Locale("es", "ES"), "${repositoryName}");
//		descriprionMap.put(new Locale("el", "GR"), "${repositoryName}");
//		descriprionMap.put(new Locale("zh", "CN"), "${repositoryName}");
		type = new InternalUrlDisplayType("repositoryName",descriprionMap, "showRepository", "name");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "View repository documents");
		descriprionMap.put(new Locale("es", "ES"), "Ver documentos del repositorio");
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε τα κείμενα του αποθετηρίου");
//		descriprionMap.put(new Locale("zh", "CN"),"查看仓储名称");
		type = new SearchDisplayType("repositoryName", "repName",
				descriprionMap);
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Repository");
		descriprionMap.put(new Locale("es", "ES"), "Repositorio");
//		descriprionMap.put(new Locale("el", "GR"), "Αποθετήριο");
//		descriprionMap.put(new Locale("zh", "CN"), "仓储");
		field = new DocumentField("repositoryName", descriprionMap, "Names of Repositories",displays, "resultsField", Cutpoint.LINE, 300);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("language");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Language(s)");
		descriprionMap.put(new Locale("es", "ES"), "Idioma(s)");
//		descriprionMap.put(new Locale("el", "GR"), "Γλώσσες");
//		descriprionMap.put(new Locale("zh", "CN"), "语种");
		field = new DocumentField("language", descriprionMap,
				"Names of Languages", displays, "resultsField", Cutpoint.VALUE,
				100);
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);

		dd = new DocumentDescription("detailedView");
		fields = new ArrayList<DocumentField>();
		displays = new ArrayList<DisplayType>();

		switchField = new SwitchDocumentField("CobjTypology");

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		descriprionMap.put(new Locale("es", "ES"), "${title}");
//		descriprionMap.put(new Locale("el", "GR"), "${title}");
//		descriprionMap.put(new Locale("zh", "CN"),"${title}");		
		type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
		displays.add(type);
		
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		descriprionMap.put(new Locale("es", "ES"), "también se puede visitar");		
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε επίσης");
//		descriprionMap.put(new Locale("zh", "CN"),"您也可以访问");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Textual", field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		descriprionMap.put(new Locale("es", "ES"), "${title}");
//		descriprionMap.put(new Locale("el", "GR"), "${title}");
//		descriprionMap.put(new Locale("zh", "CN"),"${title}");
		displays = new ArrayList<DisplayType>();
		type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
		displays.add(type);
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		descriprionMap.put(new Locale("es", "ES"), "también se puede visitar");		
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε επίσης");
//		descriprionMap.put(new Locale("zh", "CN"),"您也可以访问");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Compound Object", field);
	
		dd.putDocumentField(switchField);
				
		type = new SearchDisplayType("creator", "author");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Author(s)");
		descriprionMap.put(new Locale("es", "ES"), "Creador(s)");
//		descriprionMap.put(new Locale("el", "GR"), "Συγγραφείς");
//		descriprionMap.put(new Locale("zh", "CN"), "作者");
		field = new DocumentField("creator", descriprionMap, null, displays,
				"resultsField", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);
		
		type = new PlainTextDisplayType("description");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Description");
		descriprionMap.put(new Locale("es", "ES"), "Descripción");
//		descriprionMap.put(new Locale("el", "GR"), "Περιγραφή");
//		descriprionMap.put(new Locale("zh", "CN"), "描述");
		field = new DocumentField("description", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${repositoryName}");
		descriprionMap.put(new Locale("es", "ES"), "${repositoryName}");
//		descriprionMap.put(new Locale("el", "GR"), "${repositoryName}");
//		descriprionMap.put(new Locale("zh", "CN"), "${repositoryName}");
		type = new InternalUrlDisplayType("repositoryName",descriprionMap, "showRepository", "name");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "View repository documents");
		descriprionMap.put(new Locale("es", "ES"), "Ver documentos del repositorio");
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε τα κείμενα του αποθετηρίου");
//		descriprionMap.put(new Locale("zh", "CN"),"查看仓储名称");
		type = new SearchDisplayType("repositoryName", "repName",
				descriprionMap);
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Repository");
		descriprionMap.put(new Locale("es", "ES"), "Repositorio");
//		descriprionMap.put(new Locale("el", "GR"), "Αποθετήριο");
//		descriprionMap.put(new Locale("zh", "CN"), "仓储");
		field = new DocumentField("repositoryName", descriprionMap, "Names of Repositories",displays, "resultsField", Cutpoint.LINE, 300);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("language");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Language(s)");
		descriprionMap.put(new Locale("es", "ES"), "Idioma(s)");
///		descriprionMap.put(new Locale("el", "GR"), "Γλώσσες");
	//	descriprionMap.put(new Locale("zh", "CN"), "语种");
		field = new DocumentField("language", descriprionMap,
				"Names of Languages", displays, "resultsField", Cutpoint.VALUE,
				100);
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);

		type = new PlainTextDisplayType("subject");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Subject(s)");
		descriprionMap.put(new Locale("es", "ES"), "Materia(s)");
	//	descriprionMap.put(new Locale("el", "GR"), "Θέματα");
	//	descriprionMap.put(new Locale("zh", "CN"), "主题词");
		field = new DocumentField("subject", descriprionMap, null, displays,"resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("publisher");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publisher(s)");
		descriprionMap.put(new Locale("es", "ES"), "Editor(es)");
//		descriprionMap.put(new Locale("el", "GR"), "Εκδότες");
//		descriprionMap.put(new Locale("zh", "CN"), "出版者");
		field = new DocumentField("publisher", descriprionMap, null, displays, "resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("contributor");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Contributor(s)");
		descriprionMap.put(new Locale("es", "ES"), "Contribuidor(es)");
//		descriprionMap.put(new Locale("el", "GR"), "Συνεισφέροντες");
//		descriprionMap.put(new Locale("zh", "CN"), "责任者");
		field = new DocumentField("source", descriprionMap, null, displays,
				"resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("source");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Source(s)");
		descriprionMap.put(new Locale("es", "ES"), "Fuente(s)");
//		descriprionMap.put(new Locale("el", "GR"), "Πηγές");
//		descriprionMap.put(new Locale("zh", "CN"), "来源");		
		field = new DocumentField("source", descriprionMap, null, displays,"resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("dateAccepted");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publication Date(s)");
		descriprionMap.put(new Locale("es", "ES"), "Fecha(s) de Publicación");
//		descriprionMap.put(new Locale("el", "GR"), "Ημερομηνίες Έκδοσης");
//		descriprionMap.put(new Locale("zh", "CN"), "发表日期");	
		field = new DocumentField("dateAccepted", descriprionMap, null, displays, "resultsField");
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);
		
		/*****************************************************************************************************/
		dd = new DocumentDescription("communityView");
		fields = new ArrayList<DocumentField>();
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "identifier");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("identifier");
		displays.add(type);
		field = new DocumentField("identifier", descriprionMap, null, displays, "", Cutpoint.VALUE, 1);
		dd.putDocumentField(field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "id");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("id");
		displays.add(type);
		field = new DocumentField("id", descriprionMap, null, displays, "", Cutpoint.VALUE, 1);
		dd.putDocumentField(field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "title");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("title");
		displays.add(type);
		field = new DocumentField("title", descriprionMap, null, displays, "", Cutpoint.VALUE, 1);
		dd.putDocumentField(field);
			
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "creator");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("creator");
		displays.add(type);
		field = new DocumentField("creator", descriprionMap, null, displays, "", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("description");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "description");;
		field = new DocumentField("description", descriprionMap, null, displays,"", Cutpoint.PART, 300);
		dd.putDocumentField(field);


		type = new PlainTextDisplayType("dateAccept");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "dateAccept");
		field = new DocumentField("dateAccept", descriprionMap, null, displays, "resultsField", Cutpoint.VALUE, 100);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);

		/*************************************** detailed ************************************************************/
		dd = new DocumentDescription("detailedView");
		fields = new ArrayList<DocumentField>();
		displays = new ArrayList<DisplayType>();

		switchField = new SwitchDocumentField("CobjTypology");

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		descriprionMap.put(new Locale("es", "ES"), "${title}");
//		descriprionMap.put(new Locale("el", "GR"), "${title}");
//		descriprionMap.put(new Locale("zh", "CN"),"${title}");		
		type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
		displays.add(type);
		
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		descriprionMap.put(new Locale("es", "ES"), "también se puede visitar");		
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε επίσης");
//		descriprionMap.put(new Locale("zh", "CN"),"您也可以访问");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Textual", field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		descriprionMap.put(new Locale("es", "ES"), "${title}");
//		descriprionMap.put(new Locale("el", "GR"), "${title}");
//		descriprionMap.put(new Locale("zh", "CN"),"${title}");
		displays = new ArrayList<DisplayType>();
		type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
		displays.add(type);
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		descriprionMap.put(new Locale("es", "ES"), "también se puede visitar");		
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε επίσης");
//		descriprionMap.put(new Locale("zh", "CN"),"您也可以访问");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Compound Object", field);
	
		dd.putDocumentField(switchField);
				
		type = new SearchDisplayType("creator", "author");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Author(s)");
		descriprionMap.put(new Locale("es", "ES"), "Creador(s)");
//		descriprionMap.put(new Locale("el", "GR"), "Συγγραφείς");
//		descriprionMap.put(new Locale("zh", "CN"), "作者");
		field = new DocumentField("creator", descriprionMap, null, displays,
				"resultsField", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);
		
		type = new PlainTextDisplayType("description");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Description");
		descriprionMap.put(new Locale("es", "ES"), "Descripción");
//		descriprionMap.put(new Locale("el", "GR"), "Περιγραφή");
//		descriprionMap.put(new Locale("zh", "CN"), "描述");
		field = new DocumentField("description", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${repositoryName}");
		descriprionMap.put(new Locale("es", "ES"), "${repositoryName}");
//		descriprionMap.put(new Locale("el", "GR"), "${repositoryName}");
//		descriprionMap.put(new Locale("zh", "CN"), "${repositoryName}");
		type = new InternalUrlDisplayType("repositoryName",descriprionMap, "showRepository", "name");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "View repository documents");
		descriprionMap.put(new Locale("es", "ES"), "Ver documentos del repositorio");
//		descriprionMap.put(new Locale("el", "GR"), "Δείτε τα κείμενα του αποθετηρίου");
//		descriprionMap.put(new Locale("zh", "CN"),"查看仓储名称");
		type = new SearchDisplayType("repositoryName", "repName",
				descriprionMap);
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Repository");
		descriprionMap.put(new Locale("es", "ES"), "Repositorio");
	//	descriprionMap.put(new Locale("el", "GR"), "Αποθετήριο");
	//	descriprionMap.put(new Locale("zh", "CN"), "仓储");
		field = new DocumentField("repositoryName", descriprionMap, "Names of Repositories",displays, "resultsField", Cutpoint.LINE, 300);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("language");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Language(s)");
		descriprionMap.put(new Locale("es", "ES"), "Idioma(s)");
//		descriprionMap.put(new Locale("el", "GR"), "Γλώσσες");
//		descriprionMap.put(new Locale("zh", "CN"), "语种");
		field = new DocumentField("language", descriprionMap,
				"Names of Languages", displays, "resultsField", Cutpoint.VALUE,
				100);
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);

		type = new PlainTextDisplayType("subject");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Subject(s)");
		descriprionMap.put(new Locale("es", "ES"), "Materia(s)");
//		descriprionMap.put(new Locale("el", "GR"), "Θέματα");
//		descriprionMap.put(new Locale("zh", "CN"), "主题词");
		field = new DocumentField("subject", descriprionMap, null, displays,"resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("publisher");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publisher(s)");
		descriprionMap.put(new Locale("es", "ES"), "Editor(es)");
		descriprionMap.put(new Locale("el", "GR"), "Εκδότες");
		descriprionMap.put(new Locale("zh", "CN"), "出版者");
		field = new DocumentField("publisher", descriprionMap, null, displays, "resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("contributor");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Contributor(s)");
		descriprionMap.put(new Locale("es", "ES"), "Contribuidor(es)");
//		descriprionMap.put(new Locale("el", "GR"), "Συνεισφέροντες");
//		descriprionMap.put(new Locale("zh", "CN"), "责任者");
		field = new DocumentField("source", descriprionMap, null, displays,
				"resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("source");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Source(s)");
		descriprionMap.put(new Locale("es", "ES"), "Fuente(s)");
//		descriprionMap.put(new Locale("el", "GR"), "Πηγές");
//		descriprionMap.put(new Locale("zh", "CN"), "来源");		
		field = new DocumentField("source", descriprionMap, null, displays,"resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("dateAccepted");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publication Date(s)");
		descriprionMap.put(new Locale("es", "ES"), "Fecha(s) de Publicación");
//		descriprionMap.put(new Locale("el", "GR"), "Ημερομηνίες Έκδοσης");
//		descriprionMap.put(new Locale("zh", "CN"), "发表日期");	
		field = new DocumentField("dateAccepted", descriprionMap, null, displays, "resultsField");
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);
		
		dd = new DocumentDescription("bibtex");
		fields = new ArrayList<DocumentField>();
		displays = new ArrayList<DisplayType>();

		switchField = new SwitchDocumentField("CobjCategory");

/*		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");	
		type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
		displays.add(type);		
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Textual", field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		displays = new ArrayList<DisplayType>();
		type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
		displays.add(type);
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Compound Object", field);
	
		dd.putDocumentField(switchField);
*/		
		dd = new DocumentDescription("bibtex");
		fields = new ArrayList<DocumentField>();
		displays = new ArrayList<DisplayType>();

		type = new PlainTextDisplayType("creator");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "author");
		field = new DocumentField("creator", descriprionMap, null, displays,
				"resultsField", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("title");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "title");
		field = new DocumentField("projectname", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);
		
		type = new PlainTextDisplayType("publicationyear");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "year");
		field = new DocumentField("description", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);
		
	
		documentDescriptions.put(dd.getView(), dd);
		
		
	/*	dd = new DocumentDescription("summaryEPView");
		fields = new ArrayList<DocumentField>();
		displays = new ArrayList<DisplayType>();

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		descriprionMap.put(new Locale("es", "ES"), "${title}");
		descriprionMap.put(new Locale("el", "GR"), "${title}");
		descriprionMap.put(new Locale("zh", "CN"),"${title}");								  
		type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		descriprionMap.put(new Locale("es", "ES"), "también se puede visitar");		
		descriprionMap.put(new Locale("el", "GR"), "Δείτε επίσης");
		descriprionMap.put(new Locale("zh", "CN"),"您也可以访问");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", Cutpoint.VALUE, 1);
		
		dd.putDocumentField(field);
			
		type = new SearchDisplayType("creator", "author");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Author(s)");
		descriprionMap.put(new Locale("es", "ES"), "Creador(s)");
		descriprionMap.put(new Locale("el", "GR"), "Συγγραφείς");
		descriprionMap.put(new Locale("zh", "CN"),"作者");
		field = new DocumentField("creator", descriprionMap, null, displays,
				"resultsField", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("subject");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Subject(s)");
		descriprionMap.put(new Locale("es", "ES"), "Materia(s)");
		descriprionMap.put(new Locale("el", "GR"), "Θέματα");
		descriprionMap.put(new Locale("zh", "CN"), "主题词");
		field = new DocumentField("subject", descriprionMap, null, displays,"resultsField");
		fields.add(field);
		dd.putDocumentField(field);
		
		type = new PlainTextDisplayType("description");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Description");
		descriprionMap.put(new Locale("es", "ES"), "Descripción");
		descriprionMap.put(new Locale("el", "GR"), "Περιγραφή");
		descriprionMap.put(new Locale("zh", "CN"),"描述");
		field = new DocumentField("description", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${repositoryName}");
		descriprionMap.put(new Locale("es", "ES"), "${repositoryName}");	
		descriprionMap.put(new Locale("el", "GR"), "${repositoryName}");
		descriprionMap.put(new Locale("zh", "CN"), "${repositoryName}");
		type = new PlainTextDisplayType("repositoryName",descriprionMap);
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Repository");
		descriprionMap.put(new Locale("es", "ES"), "Repositorio");
		descriprionMap.put(new Locale("el", "GR"), "Αποθετήριο");
		descriprionMap.put(new Locale("zh", "CN"), "仓储");
		field = new DocumentField("repositoryName", descriprionMap, "Names of Repositories",displays, "resultsField", Cutpoint.LINE, 300);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("language");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Language(s)");
		descriprionMap.put(new Locale("es", "ES"), "Idioma(s)");
		descriprionMap.put(new Locale("el", "GR"), "Γλώσσες");
		descriprionMap.put(new Locale("zh", "CN"), "语种");
		field = new DocumentField("language", descriprionMap,
				"Names of Languages", displays, "resultsField", Cutpoint.VALUE,
				100);
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);
		*/
		
		
		
		layout.setDocumentDescriptions(documentDescriptions);
		
//		String xml = converter.ObjectToXml(layout);
//		System.out.println(xml);
		createXML(converter);
//		System.out.println(xml.replace("\"", "\\\""));
		
//		WebInterfaceLayout layout2 = converter.XmlToObject(xml);
//		System.out.println(layout2.getSupportedLocales());
		
//		createXML(converter);
//		SwitchDocumentField swiField = (SwitchDocumentField) layout2.getDocumentDescriptions().get("summaryView").getDocumentFields().get(0);
//		System.out.println(swiField.getDocumentField("Textual").getName());
/*		System.out.println(swiField.getDocumentField("Textual").getDescriptionMap().values());
		System.out.println(swiField.getDocumentField("Compound Object").getForceDescription());
		System.out.println(swiField.getDocumentField("Compound Object").getDescriptionMap().values());
//		System.out.println(((SwitchDocumentField)layout2.getDocumentDescriptions().get(View.DETAILED_VIEW).getDocumentFields().get(0)).getDocumentField("Textual"));
		//System.out.println(layout2.getSupportedLocales());
//		System.out.println(layout2.getDocumentDescriptions().get(View.DETAILED_VIEW).getDocumentFields());*/
		// System.out.println(layout2.getDocumentDescriptions().get(View.DETAILED_VIEW).getTitleField().getDescription());
		// System.out.println(layout2.getDocumentDescriptions().get(View.SUMMARY_VIEW).getTitleField().getForceDescription());
	}
	
	
	private static void createXML(WebInterfaceLayoutXmlConverter converter) throws JAXBException{
		WebInterfaceLayout layout = new WebInterfaceLayout("testing", "DMF", "index");
		layout.setCssFile("driver_search.css");
		
		layout.setDefaultLocale(new Locale("en", "GB"));
		List<Locale> supportedLocales = new ArrayList<Locale>();
		layout.setSupportedLocales(supportedLocales);
		
		layout.setViewCollections(false);
		layout.setViewCommunities(false);
		layout.setViewRepositories(true);
		layout.setViewAnnouncements(true);
		layout.setViewUserProfile(true);
		layout.setViewSimilarDocuments(false);
		layout.setViewEPublications(false);

		Searchable sable = new Searchable(Type.PLAIN);
		Map<Locale, String> descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Author");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "author");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("author");
		sable.setIndexType("creator");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(1);
		sable.setRefineRank(1);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Title");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "title");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("title");
		sable.setIndexType("title");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(2);
		sable.setRefineRank(2);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Subject");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "subject");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("subject");
		sable.setIndexType("subject");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(3);
		sable.setRefineRank(3);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publisher");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "publisher");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("publisher");
		sable.setIndexType("publisher");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(5);
		sable.setRefineRank(5);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new SearchableDate();
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publication Date");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "published");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("dateAccept");
		sable.setIndexType("publicationdate");
		sable.setInSearch(true);
		sable.setSearchRank(8);
		((SearchableDate) sable).setFromYear(1980);
	
		TreeMap<Integer, Map<Locale, String>> tm = new TreeMap<Integer, Map<Locale,String>>();
	
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the specified date range");
		tm.put(new Integer(0), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last one month");
		tm.put(new Integer(1), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 2 months");
		tm.put(new Integer(2), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 3 months");
		tm.put(new Integer(3), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 6 months");
		tm.put(new Integer(6), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 12 months");;
		tm.put(new Integer(12), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 2 years");
		tm.put(new Integer(24), descriprionMap);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 3 years");
		tm.put(new Integer(36), descriprionMap);

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 5 years");
		tm.put(new Integer(60), descriprionMap);

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "in the last 10 years");
		tm.put(new Integer(120), descriprionMap);
		((SearchableDate) sable).getPeriodBackMap().putAll(tm);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Document Language");;
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "language");
		sable.setShortDescriptionMap(descriprionMap);	
		sable.setName("lang");
		sable.setIndexType("language");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(true);
		sable.setSearchRank(9);
		sable.setRefineRank(7);
		sable.setBrowseRank(1);
		sable.setSearchVocabulary("Short list of language names");
		sable.setBrowseVocabulary("Names of languages");
		layout.getSearchFields().add(sable);
		
		sable = new Searchable(Type.PLAIN);
		sable.setHidden(true);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Project");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "project");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("project");
		sable.setIndexType("projectname");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(true);
		sable.setSearchRank(1);
		sable.setRefineRank(1);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);
		
		
		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Scientific Areas");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "area");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("areaid");
		sable.setIndexType("subdivisionid");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(true);
		sable.setSearchRank(11);
		sable.setRefineRank(9);
		sable.setBrowseRank(3);
		sable.setSearchVocabulary("subdivisionNames");
		sable.setBrowseVocabulary("subdivisionNames");
		layout.getSearchFields().add(sable);
		
		sable = new Searchable(Type.PLAIN);
		sable.setHidden(true);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Scientific Area");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "area");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("area");
		sable.setIndexType("subdivisionname");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(1);
		sable.setRefineRank(1);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);
		
		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Country");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "country");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("country");
		sable.setIndexType("countryaffiliation");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(true);
		sable.setSearchRank(1);
		sable.setRefineRank(1);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary("Names of Countries");
		sable.setSearchVocabulary("Names of Countries");
		layout.getSearchFields().add(sable);
		
		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Programmes");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "programmes");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("programmeid");
		sable.setIndexType("specificprogrammeid");
		sable.setInSearch(true);
		sable.setInRefine(true);
		sable.setInBrowse(true);
		sable.setSearchRank(11);
		sable.setRefineRank(9);
		sable.setBrowseRank(3);
		sable.setSearchVocabulary("programmeNames");
		sable.setBrowseVocabulary("programmeNames");
		layout.getSearchFields().add(sable);
		
		sable = new Searchable(Type.PLAIN);
		sable.setHidden(true);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Programmes");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "programmes");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("programme");
		sable.setIndexType("specificprogrammename");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(1);
		sable.setRefineRank(1);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);

		sable = new Searchable(Type.PLAIN);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Repositories");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "repositories");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("repName");
		sable.setIndexType("datasourcename");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(11);
		sable.setRefineRank(9);
		sable.setBrowseRank(3);
		sable.setSearchVocabulary("datasourcesNames");
		layout.getSearchFields().add(sable);
		
		sable = new Searchable(Type.PLAIN);
		sable.setHidden(true);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publication Year");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "year");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("year");
		sable.setIndexType("publicationyear");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(true);
		sable.setSearchRank(11);
		sable.setRefineRank(9);
		sable.setBrowseRank(3);
		layout.getSearchFields().add(sable);
		
		sable = new Searchable(Type.PLAIN);
		sable.setHidden(true);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Access Mode");
		sable.setDescriptionMap(descriprionMap);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "access");
		sable.setShortDescriptionMap(descriprionMap);
		sable.setName("accessmode");
		sable.setIndexType("accessmode");
		sable.setInSearch(true);
		sable.setInRefine(false);
		sable.setInBrowse(false);
		sable.setSearchRank(1);
		sable.setRefineRank(1);
		sable.setSearchVocabulary(null);
		sable.setBrowseVocabulary(null);
		layout.getSearchFields().add(sable);
		
		Map<String, DocumentDescription> documentDescriptions = new HashMap<String, DocumentDescription>();
		DocumentDescription dd = new DocumentDescription("summaryView");
		List<DocumentField> fields = new ArrayList<DocumentField>();
		List<DisplayType> displays = new ArrayList<DisplayType>();

		SwitchDocumentField switchField = new SwitchDocumentField("CobjTypology");

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");	
		DisplayType type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
		displays.add(type);
		
		DocumentField field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Textual", field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		displays = new ArrayList<DisplayType>();
		type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
		displays.add(type);
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Compound Object", field);
	
		dd.putDocumentField(switchField);
			
		type = new SearchDisplayType("creator", "author");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Author(s)");
		field = new DocumentField("creator", descriprionMap, null, displays,
				"resultsField", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("projectname");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Project(s)");
		field = new DocumentField("projectname", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);
		
		documentDescriptions.put(dd.getView(), dd);
		
		/************** detailed view *********************************/
		
		dd = new DocumentDescription("detailedView");
		fields = new ArrayList<DocumentField>();
		displays = new ArrayList<DisplayType>();

		switchField = new SwitchDocumentField("CobjTypology");

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");	
		type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
		displays.add(type);		
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Textual", field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${title}");
		displays = new ArrayList<DisplayType>();
		type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
		displays.add(type);
		field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", Cutpoint.VALUE, 1);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
		field.setSecondaryLinkMap(descriprionMap);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("Compound Object", field);
	
		dd.putDocumentField(switchField);
				
		type = new SearchDisplayType("creator","author");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Author(s)");
		field = new DocumentField("creator", descriprionMap, null, displays,
				"resultsField", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("projectname");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Project(s)");
		field = new DocumentField("projectname", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);
		
		type = new PlainTextDisplayType("description");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Description");
		field = new DocumentField("description", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);
		
		type = new PlainTextDisplayType("specificprogrammedescription");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Programme(s)");
		field = new DocumentField("specificprogrammedescription", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("subdivisionname");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Scientific Area(s)");
		field = new DocumentField("subdivisionname", descriprionMap, null, displays,"resultsField");
		fields.add(field);
		dd.putDocumentField(field);
		
		type = new PlainTextDisplayType("subject");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Subject(s)");
		field = new DocumentField("subject", descriprionMap, null, displays,"resultsField");
		fields.add(field);
		dd.putDocumentField(field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "${datasourcename}");
		type = new PlainTextDisplayType("datasourcename");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Repository");
		field = new DocumentField("datasourcename", descriprionMap, null,displays, "resultsField", Cutpoint.LINE, 300);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("language");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Language(s)");
		field = new DocumentField("language", descriprionMap,
				"Names of Languages", displays, "resultsField", Cutpoint.VALUE,
				100);
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);

		type = new PlainTextDisplayType("publisher");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publisher(s)");
		field = new DocumentField("publisher", descriprionMap, null, displays, "resultsField");
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("publicationdate");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Publication Date(s)");	
		field = new DocumentField("publicationdate", descriprionMap, null, displays, "resultsField");
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);

		type = new PlainTextDisplayType("embargoenddate");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Embargo End Date");	
		field = new DocumentField("embargoenddate", descriprionMap, null, displays, "resultsField");
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);
		
		type = new PlainTextDisplayType("accessmode");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "Access Mode");	
		field = new DocumentField("accessmode", descriprionMap, null, displays, "resultsField");
		fields.add(field);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);
		
		
		/************** community view *****************/
		dd = new DocumentDescription("communityView");
		fields = new ArrayList<DocumentField>();
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "identifier");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("identifier");
		displays.add(type);
		field = new DocumentField("identifier", descriprionMap, null, displays, "", Cutpoint.VALUE, 1);
		dd.putDocumentField(field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "id");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("id");
		displays.add(type);
		field = new DocumentField("id", descriprionMap, null, displays, "", Cutpoint.VALUE, 1);
		dd.putDocumentField(field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "title");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("title");
		displays.add(type);
		field = new DocumentField("title", descriprionMap, null, displays, "", Cutpoint.VALUE, 1);
		dd.putDocumentField(field);
			
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "creator");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("creator");
		displays.add(type);
		field = new DocumentField("creator", descriprionMap, null, displays, "", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("description");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "description");;
		field = new DocumentField("description", descriprionMap, null, displays,"", Cutpoint.PART, 300);
		dd.putDocumentField(field);


		type = new PlainTextDisplayType("dateAccept");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "dateAccept");
		field = new DocumentField("dateAccept", descriprionMap, null, displays, "resultsField", Cutpoint.VALUE, 100);
		dd.putDocumentField(field);
		documentDescriptions.put(dd.getView(), dd);
		
		layout.setDocumentDescriptions(documentDescriptions);

		
/************** BibTeX view *********************************/
		
		dd = new DocumentDescription("bibtex");
		fields = new ArrayList<DocumentField>();
		displays = new ArrayList<DisplayType>();

		switchField = new SwitchDocumentField("CobjCategory");

		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "creator00");	
		type = new PlainTextDisplayType("creator", descriprionMap);
		displays.add(type);		
		field = new DocumentField("creator", descriprionMap, null, displays, "document_text", Cutpoint.VALUE, 1);
		field.setForceDescription(false);
		switchField.addSwitchDisplayField("0000", field);
		
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "craetor01");
		displays = new ArrayList<DisplayType>();
		type = new PlainTextDisplayType("creator", descriprionMap);
		displays.add(type);
		field = new DocumentField("creator", descriprionMap, null, displays, "document_ep", Cutpoint.VALUE, 1);
		field.setForceDescription(true);
		switchField.addSwitchDisplayField("0001", field);
	
		dd.putDocumentField(switchField);
				
		type = new PlainTextDisplayType("creator");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "author");
		field = new DocumentField("creator", descriprionMap, null, displays,
				"resultsField", Cutpoint.VALUE, 100);
		field.setDescriptionMap(descriprionMap);
		fields.add(field);
		dd.putDocumentField(field);

		type = new PlainTextDisplayType("title");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "title");
		field = new DocumentField("projectname", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);
		
		type = new PlainTextDisplayType("publicationyear");
		displays = new ArrayList<DisplayType>();
		displays.add(type);
		descriprionMap = new HashMap<Locale, String>();
		descriprionMap.put(new Locale("en", "GB"), "year");
		field = new DocumentField("description", descriprionMap, null, displays,"resultsField", Cutpoint.PART, 300);
		fields.add(field);
		dd.putDocumentField(field);
		
	
		documentDescriptions.put(dd.getView(), dd);
		layout.setDocumentDescriptions(documentDescriptions);
		
		String xml = converter.ObjectToXml(layout);
		System.out.println(xml);
	//	System.out.println(xml.replace("\"", "\\\""));
	//	WebInterfaceLayout layout2 = converter.XmlToObject(xml);
	//	System.out.println(layout2.getDocumentDescriptions().get("summaryView"));
		
	}
	
	
}
