package gr.uoa.di.driver.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;

import javax.xml.bind.JAXBException;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.xml.security.ObjectFactory;
import gr.uoa.di.driver.xml.security.RESOURCEPROFILE;
import gr.uoa.di.driver.xml.security.TypedString;

public class SecurityProfileXmlConverter extends AbstractConverter<SecurityProfile> implements
		ResourceToXmlConverter<SecurityProfile> {
	
	private ObjectFactory of = new ObjectFactory();

	public SecurityProfileXmlConverter() throws JAXBException {
		super(RESOURCEPROFILE.class);
	}

	public String ObjectToXml(SecurityProfile object) throws JAXBException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		RESOURCEPROFILE profile = of.createRESOURCEPROFILE();

		profile.setHEADER(of.createHEADERType());
		profile.setBODY(of.createBODYType());

		profile.getHEADER().setRESOURCEIDENTIFIER(of.createRESOURCEIDENTIFIERType());
		profile.getHEADER().setDATEOFCREATION(of.createDATEOFCREATIONType());
		profile.getHEADER().setRESOURCEKIND(of.createRESOURCEKINDType());
		profile.getHEADER().setRESOURCETYPE(of.createRESOURCETYPEType());
		profile.getHEADER().setRESOURCEURI(of.createRESOURCEURIType());

		profile.getHEADER().getRESOURCETYPE().setValue(object.getResourceType());
		profile.getHEADER().getRESOURCEKIND().setValue(object.getResourceKind());

		if (object.getDateOfCreation() != null)
			profile.getHEADER().getDATEOFCREATION().setValue(
					ConversionUtils
							.DateToString(object.getDateOfCreation()));
		else
			profile.getHEADER().getDATEOFCREATION().setValue("");

		if (object.getResourceId() != null)
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue(
					object.getResourceId());
		else
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
		
		if (object.getResourceUri() != null)
			profile.getHEADER().getRESOURCEURI().setValue(
					object.getResourceUri());
		else
			profile.getHEADER().getRESOURCEURI().setValue("");
		
		profile.getBODY().setCONFIGURATION(of.createCONFIGURATIONType());

		if (object.getDriverResourceId() != null)
			profile.getBODY().getCONFIGURATION().setResourceId(
					object.getDriverResourceId());
		else
			profile.getBODY().getCONFIGURATION().setResourceId(" ");

		for (String role : object.getIdentities()) {
			TypedString identity = new TypedString();

			identity.setType("driver.security.identity.role");
			identity.setText("driver.security.identity.role#" + role);

			profile.getBODY().getCONFIGURATION().getIdentities().add(identity);
		}

		// set password
		TypedString string = new TypedString();

		string.setText(object.getPassword());
		string.setType("password");

		profile.getBODY().getCONFIGURATION().getIdentities().add(string);

		this.getMarshaller().marshal(profile, baos);

		return baos.toString();
	}

	public SecurityProfile XmlToObject(String xml) throws JAXBException {
		SecurityProfile profile = new SecurityProfile();
		RESOURCEPROFILE resource = (RESOURCEPROFILE) this.getUnmarshaller()
				.unmarshal(new ByteArrayInputStream(xml.getBytes()));

		profile.setResourceId(resource.getHEADER().getRESOURCEIDENTIFIER()
				.getValue());
		profile
				.setResourceUri(resource.getHEADER().getRESOURCEURI()
						.getValue());
		profile.setResourceKind(resource.getHEADER().getRESOURCEKIND()
				.getValue());
		profile.setResourceType(resource.getHEADER().getRESOURCETYPE()
				.getValue());
		profile.setDateOfCreation(ConversionUtils.parseDate(resource.getHEADER()
				.getDATEOFCREATION().getValue()));

		profile.setDriverResourceId(resource.getBODY().getCONFIGURATION()
				.getResourceId());

		for (TypedString identity : resource.getBODY().getCONFIGURATION()
				.getIdentities()) {

			if (identity.getType().toLowerCase().equals(
					"driver.security.identity.role")) {
				profile.getIdentities().add(
						identity.getText().substring(
								"driver.security.identity.role".length() + 1));
			} else if (identity.getType().toLowerCase().equals("password")) {
				profile.setPassword(identity.getText());
			}
		}

		return profile;
	}

	public String toXQueryString(SecurityProfileSearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);
		String xQuery = "for $x in collection(\"/db/DRIVER/SecurityProfileDSResources/SecurityProfileDSResourceType\")";

		List<String> resourceIds = criteria.getDriverResourceIds();
		
		
		if (resourceIds != null && resourceIds.size() > 0) {
			xQuery += " where ";
			xQuery += " $x/RESOURCE_PROFILE/BODY/CONFIGURATION[";
			
			for (int i = 0; i < resourceIds.size(); i++) {
				String resourceId = resourceIds.get(i);
				
				if (i > 0)
					xQuery += " or ";
					
				xQuery += "resourceId = \"" + resourceId + "\"";
			}
			
			xQuery += "]";
		}

		xQuery += " return $x";

		return xQuery;

	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((SecurityProfileSearchCriteria) criteria);
	}
}
