package gr.uoa.di.driver.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBException;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositorySearchCriteria;
import gr.uoa.di.driver.xml.repository.RESOURCEPROFILE;

/**
 * This repository converter is modified in order to be able to also produce
 * xqueries for the pending data structures collections inside the IS
 * 
 * @author tsilochr
 * 
 */
public class RepositoryXmlConverter extends AbstractConverter<Repository> implements
		ResourceToXmlConverter<Repository> {
	
	public enum Collection {
		VALID("for $x in collection(\"/db/DRIVER/RepositoryServiceResources/" +
				"RepositoryServiceResourceType\") "), 
		PENDING("for $x in collection(\"/db/DRIVER/PendingRepositoryResources/" +
				"RepositoryServiceResourceType\") ");

		private final String collection;

		Collection(String collection) {
			this.collection = collection;
		}

		public String getCollection() {
			return collection;
		}
	}

//	private ObjectFactory of = new ObjectFactory();

	private final String collection;

	public RepositoryXmlConverter(Collection c) throws JAXBException {
		super(RESOURCEPROFILE.class);
		this.collection = c.getCollection();
	}

	public RepositoryXmlConverter() throws JAXBException {
		this(Collection.VALID);
	}

	public String ObjectToXml(Repository repository) throws JAXBException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
//		RESOURCEPROFILE profile = of.createRESOURCEPROFILE();
//
//		profile.setHEADER(of.createHEADERType());
//		profile.setBODY(of.createBODYType());
//		profile.getBODY().setCONFIGURATION(of.createCONFIGURATION());
//		profile.getBODY().getCONFIGURATION().setLOCATION(of.createLOCATION());
//		profile.getBODY().getCONFIGURATION().setINTERFACES(of.createINTERFACES());
//		profile.getBODY().setSTATUS(of.createSTATUS());
//		profile.getBODY().setQOS(of.createQOS());
//		profile.getBODY().setBLACKBOARD(of.createBLACKBOARD());
//
//		profile.getHEADER().setRESOURCEIDENTIFIER(of.createRESOURCEIDENTIFIERType());
//		profile.getHEADER().setRESOURCEKIND(of.createRESOURCEKINDType());
//		profile.getHEADER().setRESOURCETYPE(of.createRESOURCETYPEType());
//		profile.getHEADER().setRESOURCEURI(of.createRESOURCEURIType());
//		profile.getHEADER().setDATEOFCREATION(of.createDATEOFCREATIONType());
//
//		profile.getHEADER().getRESOURCEKIND().setValue(repository.getResourceKind());
//		profile.getHEADER().getRESOURCETYPE().setValue(repository.getResourceType());
//		
//		if (repository.getDateOfCreation() != null)
//			profile.getHEADER().getDATEOFCREATION().setValue(
//					ConversionUtils.toXMLGregorianCalendar(repository.getDateOfCreation()));
//		else
//			profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.toXMLGregorianCalendar(new Date()));
//
//		if (repository.getResourceId() != null)
//			profile.getHEADER().getRESOURCEIDENTIFIER().setValue(
//					repository.getResourceId());
//		else
//			profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
//		
//		if (repository.getResourceUri() != null)
//			profile.getHEADER().getRESOURCEURI().setValue(
//					repository.getResourceUri());
//		else
//			profile.getHEADER().getRESOURCEURI().setValue("");
//		
//		String protocol = filterNull(repository.getProtocol());
//		profile.getHEADER().setPROTOCOL(protocol);
//
//		CONFIGURATION c = profile.getBODY().getCONFIGURATION();
//		c.setCOUNTRY(repository.getCountry());
//		c.setOFFICIALNAME(repository.getOfficialName());
//		c.setENGLISHNAME(repository.getEnglishName());
//		c.setREPOSITORYWEBPAGE(repository.getEntryUrl());
//
//		ENVIRONMENTSType envType = of.createENVIRONMENTSType();
//		if (repository.getEnvironments() != null) {
//			envType.getENVIRONMENT().addAll(repository.getEnvironments());
//		}
//		c.setENVIRONMENTS(envType);
//		
//		if (repository.getDatasourceAggregated()!= null && 
//				repository.getDatasourceAggregated().booleanValue()) {
//			c.setDATASOURCEAGGREGATED("true");			
//		} else {
//			c.setDATASOURCEAGGREGATED("false");
//		}
//		
//		c.setDATASOURCETYPE(repository.getDatasourceType());
//		c.setDATASOURCEAGGREGATORID(repository.getDatasourceAggregatorId());
//		
//		c.setDATASOURCEORIGINALID(of.createDATASOURCEORIGINALIDType());
//		c.getDATASOURCEORIGINALID().setValue(repository.getDatasourceOriginalIdValue());
//		c.getDATASOURCEORIGINALID().setProvenance(repository.getDatasourceOriginalIdProvenance());
//		
//		c.setDATASOURCECOMPLIANCEDEGREE(of.createDATASOURCECOMPLIANCEDEGREEType());
//		c.getDATASOURCECOMPLIANCEDEGREE().setValue(repository.getDatasourceComplianceDegreeValue());
//		c.getDATASOURCECOMPLIANCEDEGREE().setEncoding(repository.getDatasourceComplianceDegreeEncoding());
//		
//		c.setDATACOLLS(of.createDATACOLLSType());
//		for (DataCollectionType dataCollectionType: repository.getDataCollectionTypes()) {
//			DATACOLLType datacollType = of.createDATACOLLType();
//			datacollType.setId(dataCollectionType.getId());
//			datacollType.setLabel(dataCollectionType.getLabel());
//			datacollType.setGroup(dataCollectionType.getGroup());
//			
//			DATACOLLINTERFACEType datacollInterType = of.createDATACOLLINTERFACEType();
//			if( dataCollectionType.getDataCollectionInterface() != null) {
//				datacollInterType.setBASEURL(dataCollectionType.getDataCollectionInterface().getBaseUrl());
//				datacollInterType.setFILTER(dataCollectionType.getDataCollectionInterface().getFilter());
//				datacollInterType.setFORMAT(dataCollectionType.getDataCollectionInterface().getFormat());			
//				
//				ACCESSPROTOCOLDATACOLLType accessprotdatacoll = of.createACCESSPROTOCOLDATACOLLType();
//				if (dataCollectionType.getDataCollectionInterface().getProtocol() != null) {
//					accessprotdatacoll.setPassword(dataCollectionType.getDataCollectionInterface().getProtocol().getPassword());
//					accessprotdatacoll.setUsername(dataCollectionType.getDataCollectionInterface().getProtocol().getUsername());
//					accessprotdatacoll.setValue(dataCollectionType.getDataCollectionInterface().getProtocol().getValue());
//				}
//				datacollInterType.setACCESSPROTOCOL(accessprotdatacoll);
//			}
//			datacollType.setINTERFACE(datacollInterType);
//
//			c.getDATACOLLS().getDATACOLL().add(datacollType);
//			
//		}
//		
//		EXTRAFIELDS extraFields = of.createEXTRAFIELDS();
//
//		if (repository.getExtraFields().size() == 0) {
//
//			FieldType fieldType = of.createFieldType();
//			fieldType.setKey("VERIFIED");
//			fieldType.setValue("YES");
//			extraFields.getFIELD().add(fieldType);
//
//		} else {
//			for (String key : repository.getExtraFields().keySet()) {
//
//				FieldType fieldType = of.createFieldType();
//				fieldType.setKey(key);
//				fieldType.setValue(repository.getExtraFields().get(key));
//				extraFields.getFIELD().add(fieldType);
//
//			}
//		}
//		c.setEXTRAFIELDS(extraFields);
//		c.setICONURI(filterNull(repository.getIconUrl()));
//
//		c.setTYPOLOGY(filterNull(repository.getTypology()));
//		c.setADMININFO(repository.getAdminEmail());
//		c.setREPOSITORYINSTITUTION(filterNull(repository
//				.getRepositoryInstitution()));
//
//		if (repository.getRegisteredBy() == null
//				|| repository.getRegisteredBy().isEmpty())
//			c.setREGISTEREDBY(repository.getAdminEmail());
//		else
//			c.setREGISTEREDBY(repository.getRegisteredBy());
//
//		c.setMAXSIZEOFDATASTRUCTURE(BigInteger.valueOf(repository.getMaxSizeOfDatastructure()));
//		
//		BigInteger availableDiskSpace = null;
//		if (repository.getAvailableDiskSpace() == null || repository.getAvailableDiskSpace().trim().isEmpty()) {
//			availableDiskSpace = new BigInteger("0");
//		} else {
//			availableDiskSpace = new BigInteger(repository.getAvailableDiskSpace());
//		}	
//		c.setAVAILABLEDISKSPACE(availableDiskSpace);
//		
//		c.setMAXNUMBEROFDATASTRUCTURE(BigInteger.valueOf(repository.getMaxNumberOfDataStructures()));
//		
//		profile.getBODY().getQOS().setAVAILABILITY(filterNull(repository.getAvailability()));
//		profile.getBODY().getQOS().setCAPACITY(filterNull(filterNull(repository.getCapacity())));
//		String responseTime = repository.getResponseTime() != null ? repository.getResponseTime().toString() : "";
//		profile.getBODY().getQOS().setRESPONSETIME(responseTime);		
//		profile.getBODY().getQOS().setTHROUGHPUT(repository.getThroughput());
//		profile.getBODY().setSECURITYPARAMETERS(filterNull(repository.getSecurityParameters()));
//
//		
//		//Interfaces
//		for (RepositoryInterface ri : repository.getInterfaces()) {
//			INTERFACE i = of.createINTERFACE();
//			
//			i.setFORMATS(of.createFORMATS());
//			i.setSETS(of.createINTERFACESETS());
//			
//			i.setACCESSPROTOCOL(of.createINTERFACEACCESSPROTOCOL());
//			if (ri.getAccessProtocol() != null) {
//				i.getACCESSPROTOCOL().setValue(ri.getAccessProtocol().getValue());
//				i.getACCESSPROTOCOL().setFilter(ri.getAccessProtocol().getFilter());
//				i.getACCESSPROTOCOL().setPassword(ri.getAccessProtocol().getPassword());
//				i.getACCESSPROTOCOL().setUsername(ri.getAccessProtocol().getUsername());			
//			}
//			
//			i.setBASEURL(ri.getAddress());
//
//			if (ri.getExposedFormats() != null)
//				i.getFORMATS().getFORMAT().addAll(ri.getExposedFormats());
//
//			if (ri.getExposedSets() != null)
//				i.getSETS().getSET().addAll(ri.getExposedSets());
//
//			c.getINTERFACES().getINTERFACE().add(i);
//		}
//
//		//Location
//		LOCATION l = c.getLOCATION();
//		l.setLATITUDE(repository.getLatitude());
//		l.setLONGITUDE(repository.getLongtitude());
//		l.setTIMEZONE(repository.getTimezone());
//
//		//Status
//		/* numberOfObjects? */
//		JAXBElement<BigInteger> numOfObj = this.of.
//			createSTATUSNUMBEROFOBJECTS(BigInteger.valueOf(repository.getNumberOfObjects()));		
//		profile.getBODY().getSTATUS().getContent().add(numOfObj);
//
//		/* handledDatastructure */
//		if (repository.getHandledDatastructure() != null) {
//			JAXBElement<BigInteger> element = this.of.
//				createSTATUSHANDLEDDATASTRUCTURE(BigInteger.valueOf(repository.getHandledDatastructure()));
//			profile.getBODY().getSTATUS().getContent().add(element);
//		}
//
//		/* usedDiskSpace */
//		if (repository.getUsedDiskspace() != null) {
//			JAXBElement<BigInteger> element = this.of.
//				createSTATUSUSEDDISKSPACE(BigInteger.valueOf(repository.getUsedDiskspace()));
//			profile.getBODY().getSTATUS().getContent().add(element);
//		}
//
//		/* last update */
//		if (repository.getLastUpdate() != null) {
//			LASTUPDATEType date = this.of.createLASTUPDATEType();
//			profile.getBODY().getSTATUS().getContent().add(this.of.createSTATUSLASTUPDATE(date));
//		}
//
//		// blackboard
//		if (repository.getBlackboard() != null) {
//			BLACKBOARD bl = profile.getBODY().getBLACKBOARD();
//			String lastRequest = repository.getBlackboard().getLastrequest();
//			lastRequest = lastRequest == null ? "" : lastRequest;
//
//			String lastResponse = repository.getBlackboard().getLastresponse();
//			lastResponse = lastResponse == null ? "" : lastResponse;
//
//			bl.setLASTREQUEST(lastRequest);
//			bl.setLASTRESPONSE(lastResponse);
//
//			// blackboard/messages
//			for (RepositoryBlackboardMessage msg : repository.getBlackboard()
//					.getMessages()) {
//				MESSAGE message = of.createMESSAGE();
//				message.setACTION(ACTION.fromValue(msg.getAction().getValue()));
//				message.setACTIONSTATUS(ACTIONSTATUS.fromValue(msg.getActionStatus().getValue()));
//				message.setId(msg.getId());
//
//				// blackboard/messages/parameters
//				for (String param : msg.getParameters()) {
//					PARAMETERS p = of.createPARAMETERS();
//					p.setName(param);
//					message.getPARAMETERS().add(p);
//				}
//				bl.getMESSAGE().add(message);
//			}
//		}		
//		
//		this.getMarshaller().marshal(profile, baos);

		return baos.toString();
	}

	public Repository XmlToObject(String xml) throws JAXBException {
		Repository rep = new Repository();
		RESOURCEPROFILE profile = (RESOURCEPROFILE) this.getUnmarshaller()
				.unmarshal(new ByteArrayInputStream(xml.getBytes()));

		// HeaderType
		rep.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER()
				.getValue());
		rep.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
		rep.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
		rep.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());
	/*	rep.setDateOfCreation(ConversionUtils.toDate((profile.getHEADER()
				.getDATEOFCREATION().getValue())));
*/
		rep.setProtocol(profile.getHEADER().getPROTOCOL());
//
//		// CONFIGURATION
//		rep.setOfficialName(profile.getBODY().getCONFIGURATION()
//				.getOFFICIALNAME());
//		rep.setEnglishName(profile.getBODY().getCONFIGURATION()
//				.getENGLISHNAME());
//		rep.setCountry(profile.getBODY().getCONFIGURATION().getCOUNTRY());
//		rep.setEntryUrl(profile.getBODY().getCONFIGURATION()
//				.getREPOSITORYWEBPAGE());
//		rep.setIconUrl(profile.getBODY().getCONFIGURATION().getICONURI());
//		rep.setRepositoryInstitution(profile.getBODY().getCONFIGURATION()
//				.getREPOSITORYINSTITUTION());
//		rep.setTypology(profile.getBODY().getCONFIGURATION().getTYPOLOGY());
//		rep.setAdminEmail(profile.getBODY().getCONFIGURATION().getADMININFO());
//		if (profile.getBODY().getCONFIGURATION().getREGISTEREDBY() != null)
//			rep.setRegisteredBy(profile.getBODY().getCONFIGURATION()
//					.getREGISTEREDBY());
//		rep.setMaxNumberOfDataStructures((profile.getBODY().getCONFIGURATION()
//				.getMAXNUMBEROFDATASTRUCTURE().intValue()));
//		rep.setMaxSizeOfDatastructure(profile.getBODY().getCONFIGURATION()
//				.getMAXSIZEOFDATASTRUCTURE().intValue());
//
//		// CONFIGURATION/LOCATION
//		rep.setLatitude(profile.getBODY().getCONFIGURATION().getLOCATION()
//				.getLATITUDE());
//		rep.setLongtitude(profile.getBODY().getCONFIGURATION().getLOCATION()
//				.getLONGITUDE());
//		rep.setTimezone((float) profile.getBODY().getCONFIGURATION()
//				.getLOCATION().getTIMEZONE());
//
//		if (profile.getBODY().getCONFIGURATION().getEXTRAFIELDS() != null) {
//			for (FieldType field : profile.getBODY().getCONFIGURATION()
//					.getEXTRAFIELDS().getFIELD()) {
//				rep.getExtraFields().put(field.getKey(), field.getValue());
//			}
//		}
//
//		// CONFIGURATION/INTERFACES
//		for (INTERFACE i : profile.getBODY().getCONFIGURATION().getINTERFACES()
//				.getINTERFACE()) {
//			RepositoryInterface inter = new RepositoryInterface();
//			List<String> sets = new ArrayList<String>();
//			List<String> formats = new ArrayList<String>();
//
//			for (String s : i.getFORMATS().getFORMAT())
//				formats.add(s);
//
//			if (i.getSETS().getSET().isEmpty())
//				sets.add("All sets");
//			else {
//				for (String s : i.getSETS().getSET())
//					sets.add(s);
//			}
//
//			inter.setExposedFormats(formats);
//			inter.setExposedSets(sets);
//			
//			if(i.getACCESSPROTOCOL() != null) {
//				RepositoryAccessProtocol accessProtocol = new RepositoryAccessProtocol();
//				accessProtocol.setFilter(i.getACCESSPROTOCOL().getFilter());
//				accessProtocol.setPassword(i.getACCESSPROTOCOL().getPassword());
//				accessProtocol.setUsername(i.getACCESSPROTOCOL().getUsername());
//				accessProtocol.setValue(i.getACCESSPROTOCOL().getValue());			
//				inter.setAccessProtocol(accessProtocol);
//			}
//			inter.setAddress(i.getBASEURL());
//
//			rep.getInterfaces().add(inter);
//		}
//
//		// TODO ask to fix schema
//		List<Serializable> list = profile.getBODY().getSTATUS().getContent();
//
//		for (int i = 0; i < list.size(); i++) {
//			Object o = list.get(i);
//
//			if (o instanceof JAXBElement) {
//				JAXBElement e = (JAXBElement) o;
//				if (e.getName().toString().equals("NUMBER_OF_OBJECTS")) {
//					BigInteger bint = (BigInteger) e.getValue();
//					rep.setNumberOfObjects(bint.intValue());
//				} else if (e.getName().toString().equals(
//						"HANDLED_DATASTRUCTURE")) {
//					BigInteger bint = (BigInteger) e.getValue();
//					rep.setHandledDatastructure(bint.intValue());
//				} else if (e.getName().toString().equals("USED_DISKSPACE")) {
//					BigInteger bint = (BigInteger) e.getValue();
//					rep.setUsedDiskspace(bint.intValue());
//				} else if (e.getName().toString().equals("LAST_UPDATE")) {
//					LASTUPDATEType lastUpdate = (LASTUPDATEType) e.getValue();
//					Date d = ConversionUtils.toDate(lastUpdate.getValue());
//					rep.setLastUpdate(d);
//				}
//			}
//		}
//
//		// BODY/QOS
//		String availability = profile.getBODY().getQOS().getAVAILABILITY();
//		if (availability != null)
//			rep.setAvailability(availability);
//
//		String capacity = profile.getBODY().getQOS().getCAPACITY();
//		if (capacity != null)
//			rep.setCapacity(capacity);
//
//		String responseTime = profile.getBODY().getQOS().getRESPONSETIME();
//		if (responseTime != null)
//			rep.setResponseTime(Integer.getInteger(responseTime));
//
//		// blackboard
//		BLACKBOARD bl = profile.getBODY().getBLACKBOARD();
//		if (bl != null) {
//			RepositoryBlackboard repBl = new RepositoryBlackboard();
//			if (bl.getLASTREQUEST() != null)
//				repBl.setLastrequest(bl.getLASTREQUEST());
//
//			if (bl.getLASTRESPONSE() != null)
//				repBl.setLastresponse(bl.getLASTRESPONSE());
//
//			for (MESSAGE m : bl.getMESSAGE()) {
//				Action action = Action.getAction(m.getACTION().value());
//				ActionStatus actionStatus = ActionStatus.getActionStatus
//					(m.getACTIONSTATUS().value());
//				String id = m.getId() == null ? "" : m.getId();
//
//				RepositoryBlackboardMessage rbm = new RepositoryBlackboardMessage(
//						id, action, actionStatus);
//
//				for (PARAMETERS param : m.getPARAMETERS()) {
//					rbm.getParameters().add(param.getName());
//				}
//				repBl.getMessages().add(rbm);
//			}
//			rep.setBlackboard(repBl);
//		}
//		
//		if (profile.getBODY().getCONFIGURATION().getDATASOURCEAGGREGATED() != null) {
//			rep.setDatasourceAggregated(new Boolean(profile.getBODY().getCONFIGURATION().getDATASOURCEAGGREGATED()));
//		} else {
//			rep.setDatasourceAggregated(false);
//		}
//		
//		rep.setDatasourceType(profile.getBODY().getCONFIGURATION().getDATASOURCETYPE());
//		rep.setDatasourceAggregatorId(profile.getBODY().getCONFIGURATION().getDATASOURCEAGGREGATORID());
//		
//		if (profile.getBODY().getCONFIGURATION().getDATASOURCEORIGINALID() != null) {
//			rep.setDatasourceOriginalIdProvenance(profile.getBODY().getCONFIGURATION().getDATASOURCEORIGINALID().getProvenance());
//			rep.setDatasourceOriginalIdValue(profile.getBODY().getCONFIGURATION().getDATASOURCEORIGINALID().getValue());
//		}
//		
//		if (profile.getBODY().getCONFIGURATION().getDATASOURCECOMPLIANCEDEGREE() != null) {
//			rep.setDatasourceComplianceDegreeEncoding(profile.getBODY().getCONFIGURATION().getDATASOURCECOMPLIANCEDEGREE().getEncoding());
//			rep.setDatasourceComplianceDegreeValue(profile.getBODY().getCONFIGURATION().getDATASOURCECOMPLIANCEDEGREE().getValue());
//		}
//		
//		if (profile.getBODY().getCONFIGURATION().getDATACOLLS() != null && 
//				profile.getBODY().getCONFIGURATION().getDATACOLLS().getDATACOLL() != null) {			
//			
//			for (DATACOLLType dataCollType : profile.getBODY().getCONFIGURATION().getDATACOLLS().getDATACOLL()) {				
//				DataCollectionType dataCollectionType = new DataCollectionType();
//				dataCollectionType.setGroup(dataCollType.getGroup());
//				dataCollectionType.setId(dataCollType.getId());
//				dataCollectionType.setLabel(dataCollType.getLabel());
//				
//				if (dataCollType.getINTERFACE() != null) {
//					DataCollectionInterface dataCollectionInterface = new DataCollectionInterface();
//					dataCollectionInterface.setBaseUrl(dataCollType.getINTERFACE().getBASEURL());
//					dataCollectionInterface.setFilter(dataCollType.getINTERFACE().getFILTER());
//					dataCollectionInterface.setFormat(dataCollType.getINTERFACE().getFORMAT());					
//									
//					if (dataCollType.getINTERFACE().getACCESSPROTOCOL() != null) {
//						DataCollectionAccessProtocol dataCollectionAccessProtocol =  new DataCollectionAccessProtocol();
//						dataCollectionAccessProtocol.setUsername(dataCollType.getINTERFACE().getACCESSPROTOCOL().getUsername());
//						dataCollectionAccessProtocol.setPassword(dataCollType.getINTERFACE().getACCESSPROTOCOL().getPassword());
//						dataCollectionAccessProtocol.setValue(dataCollType.getINTERFACE().getACCESSPROTOCOL().getValue());	
//						dataCollectionInterface.setProtocol(dataCollectionAccessProtocol);
//					}					
//					dataCollectionType.setDataCollectionInterface(dataCollectionInterface);					
//				}				
//				rep.getDataCollectionTypes().add(dataCollectionType);
//			}								
//		}
//		
//		if (profile.getBODY().getCONFIGURATION().getENVIRONMENTS() != null && profile.getBODY().getCONFIGURATION().getENVIRONMENTS().getENVIRONMENT() != null)
//			rep.getEnvironments().addAll(profile.getBODY().getCONFIGURATION().getENVIRONMENTS().getENVIRONMENT());
//		
//				
		return rep;
	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((RepositorySearchCriteria) criteria);
	}

	public String toXQueryString(RepositorySearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);
		
		String xQuery = collection; // "for $x in
		List<String> predicates = new ArrayList<String>();

		if (criteria != null) {
			if (criteria.getContains() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[contains(lower-case(.), \""
								+ criteria.getContains().toLowerCase() + "\")]");
			}
			if (criteria.getStartsWith() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[starts-with(lower-case(.), \""
								+ criteria.getStartsWith().toLowerCase()
								+ "\")]");
			}

			if (criteria.getEndsWith() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[ends-with(lower-case(.), \""
								+ criteria.getStartsWith().toLowerCase()
								+ "\")]");
			}

			if (criteria.getOfficialName() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[. = \""
								+ criteria.getOfficialName() + "\"]");
			}

			if (criteria.getHaveDocuments() != null) {
				predicates.add("$x//STATUS/NUMBER_OF_OBJECTS[. > 0]");
			}

			if (criteria.getAdminInfo() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/ADMIN_INFO[. = \""
								+ criteria.getAdminInfo() + "\"]");
			}

			if (criteria.getCountry() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/COUNTRY[. = \""
								+ criteria.getCountry() + "\"]");
			}

			if (criteria.getRegisteredBy() != null) {
				predicates
						.add("($x/RESOURCE_PROFILE/BODY/CONFIGURATION/REGISTERED_BY[. = \""
								+ criteria.getRegisteredBy()
								+ "\"] or $x/RESOURCE_PROFILE/BODY/CONFIGURATION/ADMIN_INFO[. = \""
								+ criteria.getRegisteredBy() + "\"])");
			}

			if (criteria.isVerified()) {

				predicates
						.add("(if ($x/RESOURCE_PROFILE/BODY/CONFIGURATION/EXTRA_FIELDS) then $x/RESOURCE_PROFILE/BODY/CONFIGURATION/EXTRA_FIELDS/FIELD[key = \"VERIFIED\"]/value[. = \""
								+ "YES" + "\"] else true())");

			}

			for (int i = 0; i < predicates.size(); i++) {
				String predicate = predicates.get(i);

				if (i > 0)
					xQuery += " and ";
				else
					xQuery += " where ";

				xQuery += predicate;
			}
		}

		xQuery += " return $x";
		return xQuery;

	}

	public String toXQueryString(Repository repository) {
		String xQuery = collection; // "for $x in
		xQuery += " let $date := xs:date($x/RESOURCE_PROFILE/BODY/CONFIGURATION/EXTRA_FIELDS/FIELD[key = \"REGISTER_DATE\"]/value)";
//		List<String> predicates = new ArrayList<String>();
//
//		if (repository != null) {
//			if (repository.getId() != null) {
//				predicates
//						.add("$x/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER[@value = \""
//								+ repository.getId() + "\"]");
//			}
//			if (repository.getOfficialName() != null) {
//				predicates
//						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[. = \""
//								+ repository.getOfficialName() + "\"]");
//			}
//			if (repository.getEnglishName() != null) {
//				predicates
//						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/ENGLISH_NAME[. = \""
//								+ repository.getEnglishName() + "\"]");
//			}
//			if (repository.getCountry() != null) {
//				predicates
//						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/COUNTRY[. = \""
//								+ repository.getCountry() + "\"]");
//			}
//			if (repository.getEntryUrl() != null) {
//				predicates
//						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/ENTRY_URL[. = \""
//								+ repository.getEntryUrl() + "\"]");
//			}
//			if (repository.getIconUrl() != null) {
//				predicates
//						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/ICON_URL[@value = \""
//								+ repository.getIconUrl() + "\"]");
//			}
//			if (repository.getRegistrationDate() != null) {
//				predicates
//						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/REGISTRATION_DATE[@value = \""
//								+ ConversionUtils.DateToString(repository
//										.getRegistrationDate()) + "\"]");
//			}
//			if (repository.getNumberOfObjects() != 0) {
//				predicates
//						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NUMBER_OF_OBJECTS[@value ="
//								+ repository.getNumberOfObjects() + "]");
//			}
//			
//			for (int i = 0; i < predicates.size(); i++) {
//				String predicate = predicates.get(i);
//
//				if (i > 0)
//					xQuery += " and ";
//				else
//					xQuery += " where ";
//
//				xQuery += predicate;
//			}
//		}
//
//		xQuery += " return $x";

		return xQuery;
	}
}