package gr.uoa.di.driver.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

import javax.xml.bind.JAXBException;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.QueryHash;
import eu.dnetlib.domain.functionality.QueryHashSearchCriteria;
import gr.uoa.di.driver.xml.queryResultsHashResource.ObjectFactory;
import gr.uoa.di.driver.xml.queryResultsHashResource.QUERYRESULTSType;
import gr.uoa.di.driver.xml.queryResultsHashResource.RESOURCEPROFILE;

public class QueryHashXmlConverter extends AbstractConverter<QueryHash> implements
		ResourceToXmlConverter<QueryHash> {
	private ObjectFactory of = new ObjectFactory();

	public QueryHashXmlConverter() throws JAXBException {
		super(RESOURCEPROFILE.class);
	}

	public String ObjectToXml(QueryHash queryHash) throws JAXBException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		RESOURCEPROFILE profile = of.createRESOURCEPROFILE();

		profile.setHEADER(of.createHEADERType());
		profile.setBODY(of.createBODYType());

		profile.getHEADER().setRESOURCEIDENTIFIER(of.createRESOURCEIDENTIFIERType());
		profile.getHEADER().setRESOURCEKIND(of.createRESOURCEKINDType());
		profile.getHEADER().setRESOURCETYPE(of.createRESOURCETYPEType());
		profile.getHEADER().setRESOURCEURI(of.createRESOURCEURIType());
		profile.getHEADER().setDATEOFCREATION(of.createDATEOFCREATIONType());

		profile.getHEADER().getRESOURCEKIND().setValue(queryHash.getResourceKind());
		profile.getHEADER().getRESOURCETYPE().setValue(queryHash.getResourceType());
		
		if (queryHash.getDateOfCreation() != null)
			profile.getHEADER().getDATEOFCREATION().setValue(
					ConversionUtils
							.DateToString(queryHash.getDateOfCreation()));
		else
			profile.getHEADER().getDATEOFCREATION().setValue("");

		if (queryHash.getResourceId() != null)
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue(
					queryHash.getResourceId());
		else
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
		
		if (queryHash.getResourceUri() != null)
			profile.getHEADER().getRESOURCEURI().setValue(
					queryHash.getResourceUri());
		else
			profile.getHEADER().getRESOURCEURI().setValue("");
		
		
		profile.getBODY().setUSERID(queryHash.getUserId());
		profile.getBODY().setHASHVALUE(
				new java.math.BigInteger(queryHash.getHashValue() + ""));
		profile.getBODY().setCQLQUERY( queryHash.getCqlQuery());
		
		if( queryHash.getQueryResults() != null ) {
			Set<String> keys = queryHash.getQueryResults().keySet();
			for( String key : keys ) {
				QUERYRESULTSType res = new QUERYRESULTSType();
				res.setDOCID( key );
				res.setISNEW( queryHash.getQueryResults().get(key) );
				profile.getBODY().getQUERYRESULTS().add(res);
			}
		}
		getMarshaller().marshal(profile, baos);

		return baos.toString();
	}

	public QueryHash XmlToObject(String xml) throws JAXBException {
		QueryHash queryHash = new QueryHash();

		RESOURCEPROFILE profile = (RESOURCEPROFILE) getUnmarshaller()
				.unmarshal(new ByteArrayInputStream(xml.getBytes()));

		queryHash.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER().getValue());
		queryHash.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
		if ( profile.getHEADER().getDATEOFCREATION().getValue() != null )
			queryHash.setDateOfCreation(ConversionUtils.parseDate(profile.getHEADER().getDATEOFCREATION().getValue()));
		queryHash.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
		queryHash.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());

		queryHash.setHashValue(profile.getBODY().getHASHVALUE().intValue());
		queryHash.setUserId(profile.getBODY().getUSERID());
		queryHash.setCqlQuery( profile.getBODY().getCQLQUERY() );
		Hashtable<String, Boolean> results = new Hashtable<String, Boolean>();
		List<QUERYRESULTSType> resultsType = profile.getBODY().getQUERYRESULTS();
		for( QUERYRESULTSType result : resultsType ) {
			results.put(result.getDOCID(), result.isISNEW() );
		}
		queryHash.setQueryResults( results );
		
		return queryHash;
	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((QueryHashSearchCriteria) criteria);
	}

	public String toXQueryString(QueryHashSearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);
		
		String xQuery = null;
		List<String> predicates = new ArrayList<String>();

		xQuery = "for $x in collection( \"/db/DRIVER/QueryHashDSResources/QueryHashDSResourceType\" )";

		if (criteria.getUserId() != null) {
			predicates.add("$x/RESOURCE_PROFILE/BODY[@USER_ID = \""
					+ criteria.getUserId() + "\"]");

		}

		for (int i = 0; i < predicates.size(); i++) {
			String predicate = predicates.get(i);

			if (i > 0)
				xQuery += " and ";
			else
				xQuery += " where ";

			xQuery += predicate;
		}
		xQuery += " return $x";
		// logger.debug( xQuery );
		return xQuery;
	}

	@Deprecated
	public String toXQueryString(QueryHash exampleInstance) {
		String xQuery = "for $x in collection( \"/db/DRIVER/QueryHashDSResources/QueryHashDSResourceType\" )";
		List<String> predicates = new ArrayList<String>();

		if (exampleInstance != null) {
			if (exampleInstance.getId() != null) {
				predicates.add("$x/RESOURCE_PROFILE/BODY[@USER_ID = \""
						+ exampleInstance.getId() + "\"]");
			}

			for (int i = 0; i < predicates.size(); i++) {
				String predicate = predicates.get(i);

				if (i > 0)
					xQuery += " and ";
				else
					xQuery += " where ";

				xQuery += predicate;
			}
		}

		xQuery += " return $x";
		// logger.debug( xQuery );
		return xQuery;
	}

	public static void main(String args[]) throws JAXBException {
		
		 QueryHash r = new QueryHash();
		 
		 r.setDateOfCreation( new Date() );			
		 r.setResourceId( "test" );
		 r.setCqlQuery("test query");
		 r.setUserId("kati");
		 r.setHashValue( 123 );
		 Hashtable<String, Boolean> results = new Hashtable< String, Boolean >();
		 results.put("1", true );
		 results.put("2", false );
		 results.put("3", true );
		 results.put("4", false );
		 
		 r.setQueryResults(results);
		
		 QueryHashXmlConverter conv;
		 conv = new QueryHashXmlConverter();
		 String xml = conv.ObjectToXml(r);
		 System.out.println( xml );
		 
		 QueryHash nr = conv.XmlToObject(xml);	
		 System.out.println( "cql is " + nr.getCqlQuery() );
		 System.out.println( "user is " + nr.getUserId() );
		 System.out.println( "Hash is " + nr.getHashValue() );
		 
		 Set<String> keys = nr.getQueryResults().keySet();
		 for( String key : keys ) {
			 System.out.println( "key is " + key + " value is " + nr.getQueryResults().get(key) );
		 }
		 
	}
}
