package gr.uoa.di.driver.enabling.vocabulary;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositorySearchCriteria;
import eu.dnetlib.domain.enabling.Vocabulary;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

import org.apache.log4j.Logger;

import com.googlecode.ehcache.annotations.Cacheable;

public class RepositoryVocabularyLoader implements VocabularyLoader {
	
	private ISLookUp<Repository> repositoryLookup = null;
	private Logger logger = Logger.getLogger(RepositoryVocabularyLoader.class);

	@Cacheable(cacheName="vocabularyCache")
	public Vocabulary getVocabulary(String vocabularyName, Locale locale, Locale defaultloLocale) {
		
		List<Repository> repositories = null;
		
		try {
			repositories = repositoryLookup.performQuickSearch(new RepositorySearchCriteria());
			
		} catch (ISLookUpException isle) {
			logger.debug("Error loading vocabulary " + vocabularyName, isle);
		}
		
		Map<String, String> map = new TreeMap<String, String>();
		
		for (Repository rep:repositories)
			map.put(rep.getOfficialName(), rep.getOfficialName());
		
		Vocabulary vocabulary = new Vocabulary(vocabularyName, map);
		
		return vocabulary;
	}

	public void setRepositoryLookup(ISLookUp<Repository> repositoryLookup) {
		this.repositoryLookup = repositoryLookup;
	}
}
